/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.settings;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.UiTheme;
import org.cryptomator.common.settings.VaultSettingsJson;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
class SettingsJson {
    @JsonProperty(value="directories")
    List<VaultSettingsJson> directories = List.of();
    @JsonProperty(value="writtenByVersion")
    String writtenByVersion;
    @JsonProperty(value="autoCloseVaults")
    boolean autoCloseVaults = false;
    @JsonProperty(value="debugMode")
    boolean debugMode = false;
    @JsonProperty(value="theme")
    UiTheme theme = Settings.DEFAULT_THEME;
    @JsonProperty(value="keychainProvider")
    String keychainProvider = Settings.DEFAULT_KEYCHAIN_PROVIDER;
    @JsonProperty(value="language")
    String language;
    @JsonProperty(value="licenseKey")
    String licenseKey;
    @JsonProperty(value="mountService")
    String mountService;
    @JsonProperty(value="numTrayNotifications")
    int numTrayNotifications = 3;
    @JsonProperty(value="port")
    int port = 42427;
    @JsonProperty(value="showTrayIcon")
    boolean showTrayIcon;
    @JsonProperty(value="compactMode")
    boolean compactMode;
    @JsonProperty(value="startHidden")
    boolean startHidden = false;
    @JsonProperty(value="uiOrientation")
    String uiOrientation = Settings.DEFAULT_USER_INTERFACE_ORIENTATION;
    @JsonProperty(value="useKeychain")
    boolean useKeychain = true;
    @JsonProperty(value="windowHeight")
    int windowHeight;
    @JsonProperty(value="windowWidth")
    int windowWidth;
    @JsonProperty(value="windowXPosition")
    int windowXPosition;
    @JsonProperty(value="windowYPosition")
    int windowYPosition;
    @Deprecated(since="1.7.0")
    @JsonProperty(value="preferredVolumeImpl", access=JsonProperty.Access.WRITE_ONLY)
    String preferredVolumeImpl;
    @JsonProperty(value="checkForUpdatesEnabled")
    boolean checkForUpdatesEnabled = false;
    @JsonProperty(value="lastReminderForUpdateCheck")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
    Instant lastReminderForUpdateCheck = Settings.DEFAULT_TIMESTAMP;
    @JsonProperty(value="lastSuccessfulUpdateCheck")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
    Instant lastSuccessfulUpdateCheck = Settings.DEFAULT_TIMESTAMP;
    @JsonProperty(value="useQuickAccess")
    boolean useQuickAccess = true;
    @JsonProperty(value="quickAccessService")
    String quickAccessService = Settings.DEFAULT_QUICKACCESS_SERVICE;
    @JsonProperty(value="previouslyUsedVaultDirectory")
    Path previouslyUsedVaultDirectory;

    SettingsJson() {
    }
}

