/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultComponent;
import org.cryptomator.common.vaults.VaultConfigCache;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.integrations.mount.MountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VaultPreparator {
    private static final Logger LOG = LoggerFactory.getLogger(VaultPreparator.class);

    private VaultPreparator() {
    }

    public static Vault prepareVault(Path selectedDirectory, VaultComponent.Factory vaultComponentFactory, List<MountService> mountServices, ResourceBundle resourceBundle) {
        VaultSettings vaultSettings = VaultSettings.withRandomId();
        vaultSettings.path.set((Object)selectedDirectory);
        if (selectedDirectory.getFileName() != null) {
            vaultSettings.displayName.set((Object)selectedDirectory.getFileName().toString());
        } else {
            vaultSettings.displayName.set((Object)resourceBundle.getString("defaults.vault.vaultName"));
        }
        VaultConfigCache wrapper = new VaultConfigCache(vaultSettings);
        Vault vault = vaultComponentFactory.create(vaultSettings, wrapper, VaultState.Value.LOCKED, null).vault();
        try {
            VaultListManager.determineVaultState(vault.getPath());
        }
        catch (IOException e) {
            LOG.warn("Failed to determine vault state for {}", vaultSettings.path.get(), (Object)e);
        }
        String nameOfWinfspLocalMounter = "org.cryptomator.frontend.fuse.mount.WinFspMountProvider";
        if (SystemUtils.IS_OS_WINDOWS && ((Path)vaultSettings.path.get()).toString().contains("Dropbox") && mountServices.stream().anyMatch(s -> s.getClass().getName().equals(nameOfWinfspLocalMounter))) {
            vaultSettings.mountService.setValue(nameOfWinfspLocalMounter);
        }
        return vault;
    }
}

