/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.recovery;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecoveryDirectory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryDirectory.class);
    private final Path recoveryPath;
    private final Path vaultPath;

    private RecoveryDirectory(Path vaultPath, Path recoveryPath) {
        this.vaultPath = vaultPath;
        this.recoveryPath = recoveryPath;
    }

    public static RecoveryDirectory create(Path vaultPath) throws IOException {
        Path tempDir = Files.createTempDirectory("cryptomator", new FileAttribute[0]);
        return new RecoveryDirectory(vaultPath, tempDir);
    }

    public void moveRecoveredFile(String file) throws IOException {
        Files.move(this.recoveryPath.resolve(file), this.vaultPath.resolve(file), StandardCopyOption.REPLACE_EXISTING);
    }

    private void deleteRecoveryDirectory() {
        try (Stream<Path> paths = Files.walk(this.recoveryPath, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    LOG.info("Unable to delete {}. Please delete it manually.", p);
                }
            });
        }
        catch (IOException e) {
            LOG.error("Failed to clean up recovery directory", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.deleteRecoveryDirectory();
    }

    public Path getRecoveryPath() {
        return this.recoveryPath;
    }
}

