/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.recovery;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.cryptomator.common.recovery.RecoveryDirectory;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MasterkeyService {
    private static final Logger LOG = LoggerFactory.getLogger(MasterkeyService.class);

    private MasterkeyService() {
    }

    public static void recoverFromRecoveryKey(String recoveryKey, RecoveryKeyFactory recoveryKeyFactory, Path recoveryPath, CharSequence newPassword) throws IOException {
        recoveryKeyFactory.newMasterkeyFileWithPassphrase(recoveryPath, recoveryKey, newPassword);
    }

    public static Masterkey load(MasterkeyFileAccess masterkeyFileAccess, Path masterkeyFilePath, CharSequence password) throws IOException {
        return masterkeyFileAccess.load(masterkeyFilePath, password);
    }

    public static CryptorProvider.Scheme validateRecoveryKeyAndDetectCombo(RecoveryKeyFactory recoveryKeyFactory, Vault vault, String recoveryKey, MasterkeyFileAccess masterkeyFileAccess) throws IOException, CryptoException, NoSuchElementException {
        String tmpPass = UUID.randomUUID().toString();
        try (RecoveryDirectory recoveryDirectory = RecoveryDirectory.create(vault.getPath());){
            CryptorProvider.Scheme scheme;
            block12: {
                Path tempRecoveryPath = recoveryDirectory.getRecoveryPath();
                MasterkeyService.recoverFromRecoveryKey(recoveryKey, recoveryKeyFactory, tempRecoveryPath, tmpPass);
                Path masterkeyFilePath = tempRecoveryPath.resolve("masterkey.cryptomator");
                Masterkey mk = MasterkeyService.load(masterkeyFileAccess, masterkeyFilePath, tmpPass);
                try {
                    scheme = MasterkeyService.detect(mk, vault.getPath()).orElseThrow();
                    if (mk == null) break block12;
                }
                catch (Throwable throwable) {
                    if (mk != null) {
                        try {
                            mk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                mk.close();
            }
            return scheme;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<CryptorProvider.Scheme> detect(Masterkey masterkey, Path vaultPath) {
        try (Stream<Path> paths = Files.walk(vaultPath.resolve("d"), new FileVisitOption[0]);){
            Optional<Path> c9rFile = paths.filter(p -> p.toString().endsWith(".c9r")).filter(p -> !p.endsWith("dir.c9r")).findFirst();
            if (c9rFile.isEmpty()) {
                LOG.info("Unable to detect Crypto scheme: No *.c9r file found in {}", (Object)vaultPath);
                Optional<CryptorProvider.Scheme> optional2 = Optional.empty();
                return optional2;
            }
            Optional<CryptorProvider.Scheme> optional = MasterkeyService.determineScheme(c9rFile.get(), masterkey);
            return optional;
        }
        catch (IOException e) {
            LOG.info("Unable to detect Crypto scheme: Failed to inspect vault", (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<CryptorProvider.Scheme> determineScheme(Path c9rFile, Masterkey masterkey) {
        return Arrays.stream(CryptorProvider.Scheme.values()).filter(scheme -> {
            boolean bl;
            block16: {
                Cryptor cryptor = CryptorProvider.forScheme((CryptorProvider.Scheme)scheme).provide(masterkey.copy(), SecureRandom.getInstanceStrong());
                try {
                    int headerSize = cryptor.fileHeaderCryptor().headerSize();
                    ByteBuffer headerBuf = ByteBuffer.allocate(headerSize);
                    try (FileChannel channel = FileChannel.open(c9rFile, StandardOpenOption.READ);){
                        channel.read(headerBuf, 0L);
                    }
                    headerBuf.flip();
                    cryptor.fileHeaderCryptor().decryptHeader(headerBuf.duplicate());
                    LOG.debug("Detected Crypto scheme: {}", scheme);
                    bl = true;
                    if (cryptor == null) break block16;
                }
                catch (Throwable t$) {
                    try {
                        if (cryptor != null) {
                            try {
                                cryptor.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (IllegalArgumentException | CryptoException e) {
                        LOG.debug("Could not decrypt with scheme: {}", scheme);
                        return false;
                    }
                    catch (IOException | NoSuchAlgorithmException e) {
                        LOG.warn("Unable to detect Crypto scheme: Failed to decrypt .c9r file", (Throwable)e);
                        return false;
                    }
                }
                cryptor.close();
            }
            return bl;
        }).findFirst();
    }
}

