/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.keychain;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javafx.application.Platform;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.Passphrase;
import org.cryptomator.common.keychain.NoKeychainAccessProviderException;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;

@Singleton
public class KeychainManager
implements KeychainAccessProvider {
    private final ObjectExpression<KeychainAccessProvider> keychain;
    private final LoadingCache<String, BooleanProperty> passphraseStoredProperties;
    private final ReentrantReadWriteLock lock;

    @Inject
    KeychainManager(ObjectExpression<KeychainAccessProvider> selectedKeychain) {
        this.keychain = selectedKeychain;
        this.passphraseStoredProperties = Caffeine.newBuilder().softValues().build(this::createStoredPassphraseProperty);
        this.keychain.addListener(ignored -> this.passphraseStoredProperties.invalidateAll());
        this.lock = new ReentrantReadWriteLock(false);
    }

    private KeychainAccessProvider getKeychainOrFail() throws KeychainAccessException {
        KeychainAccessProvider result = (KeychainAccessProvider)this.keychain.getValue();
        if (result == null) {
            throw new NoKeychainAccessProviderException();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        try {
            this.lock.writeLock().lock();
            this.getKeychainOrFail().storePassphrase(key, displayName, passphrase);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.setPassphraseStored(key, true);
    }

    public char[] loadPassphrase(String key) throws KeychainAccessException {
        char[] passphrase = null;
        try {
            this.lock.readLock().lock();
            passphrase = this.getKeychainOrFail().loadPassphrase(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.setPassphraseStored(key, passphrase != null);
        return passphrase;
    }

    public void deletePassphrase(String key) throws KeychainAccessException {
        try {
            this.lock.writeLock().lock();
            this.getKeychainOrFail().deletePassphrase(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.setPassphraseStored(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        if (this.isPassphraseStored(key)) {
            try {
                this.lock.writeLock().lock();
                this.getKeychainOrFail().changePassphrase(key, displayName, passphrase);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            this.setPassphraseStored(key, true);
        }
    }

    public boolean isSupported() {
        return this.keychain.getValue() != null;
    }

    public boolean isLocked() {
        return this.keychain.getValue() == null || ((KeychainAccessProvider)this.keychain.get()).isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPassphraseStored(String key) throws KeychainAccessException {
        char[] storedPw = null;
        try {
            storedPw = this.getKeychainOrFail().loadPassphrase(key);
            boolean bl = storedPw != null;
            return bl;
        }
        finally {
            if (storedPw != null) {
                Arrays.fill(storedPw, ' ');
            }
        }
    }

    private void setPassphraseStored(String key, boolean value) {
        BooleanProperty property = (BooleanProperty)this.passphraseStoredProperties.get((Object)key, string -> new SimpleBooleanProperty(value));
        if (Platform.isFxApplicationThread()) {
            property.set(value);
        } else {
            Platform.runLater(() -> property.set(value));
        }
    }

    public ReadOnlyBooleanProperty getPassphraseStoredProperty(String key) {
        return (ReadOnlyBooleanProperty)this.passphraseStoredProperties.get((Object)key);
    }

    private BooleanProperty createStoredPassphraseProperty(String key) {
        try {
            return new SimpleBooleanProperty(this.isPassphraseStored(key));
        }
        catch (KeychainAccessException e) {
            return new SimpleBooleanProperty(false);
        }
    }

    public ObjectExpression<KeychainAccessProvider> getKeychainImplementation() {
        return this.keychain;
    }

    public static void migrate(KeychainAccessProvider oldProvider, KeychainAccessProvider newProvider, Map<String, String> idsAndNames) throws KeychainAccessException {
        if (oldProvider instanceof KeychainManager || newProvider instanceof KeychainManager) {
            throw new IllegalArgumentException("KeychainManger must not be the source or target of migration");
        }
        for (Map.Entry<String, String> entry : idsAndNames.entrySet()) {
            char[] passphrase = oldProvider.loadPassphrase(entry.getKey());
            if (passphrase == null) continue;
            Passphrase wrapper = new Passphrase(passphrase);
            oldProvider.deletePassphrase(entry.getKey());
            newProvider.storePassphrase(entry.getKey(), entry.getValue(), (CharSequence)wrapper);
            wrapper.destroy();
        }
    }
}

