/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import org.cryptomator.frontend.fuse.FuseNioAdapter;
import org.cryptomator.frontend.fuse.mount.AbstractMount;
import org.cryptomator.frontend.fuse.mount.ProcessHelper;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.cryptomator.jfuse.api.Fuse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MacMountedVolume
extends AbstractMount {
    private static final Logger LOG = LoggerFactory.getLogger(MacMountedVolume.class);
    private boolean unmounted;

    public MacMountedVolume(Fuse fuse, FuseNioAdapter adapter, Path mountPoint) {
        super(fuse, adapter, mountPoint);
    }

    public void unmount() throws UnmountFailedException {
        ProcessBuilder command = new ProcessBuilder("umount", "--", this.mountpoint.getFileName().toString());
        command.directory(this.mountpoint.getParent().toFile());
        this.unmount(command, "`umount`");
    }

    public void unmountForced() throws UnmountFailedException {
        ProcessBuilder command = new ProcessBuilder("umount", "-f", "--", this.mountpoint.getFileName().toString());
        command.directory(this.mountpoint.getParent().toFile());
        this.unmount(command, "`umount -f`");
    }

    private void unmount(ProcessBuilder command, String cmdDescription) throws UnmountFailedException {
        try {
            Process p = command.start();
            ProcessHelper.waitForSuccess(p, 10, cmdDescription);
            this.fuse.close();
            this.unmounted = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UnmountFailedException((Exception)e);
        }
        catch (IOException | TimeoutException e) {
            throw new UnmountFailedException(e);
        }
        catch (ProcessHelper.CommandFailedException e) {
            if (e.stderr.contains("not currently mounted")) {
                LOG.info("{} already unmounted. Nothing to do.", (Object)this.mountpoint);
            }
            LOG.warn("{} failed with exit code {}:\nSTDOUT: {}\nSTDERR: {}\n", new Object[]{cmdDescription, e.exitCode, e.stdout, e.stderr});
            throw new UnmountFailedException((Exception)e);
        }
    }

    @Override
    public void close() throws UnmountFailedException, IOException {
        if (!this.unmounted) {
            this.unmountForced();
        }
        super.close();
    }
}

