#pragma once

/*
    File: typeid.h
*/

/*
Copyright (c) 2014, Christian E. Schafmeister

CLASP is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

See directory 'clasp/licenses' for full details.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
/* -^- */
// Copyright Daniel Wallin 2008. Use, modification and distribution is
// subject to the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <boost/operators.hpp>
#include <typeinfo>
#include "clasp/clbind/primitives.h"

namespace clbind {

#ifdef BOOST_MSVC
#pragma warning(push)
// std::type_info::before() returns int, rather than bool.
// At least on MSVC7.1, this is true for the comparison
// operators as well.
#pragma warning(disable : 4800)
#endif

class type_id : public boost::less_than_comparable<type_id> {
public:
  type_id() : id(&typeid(reg::null_type)) {}

  type_id(std::type_info const& id) : id(&id) {}

  bool operator!=(type_id const& other) const { return *id != *other.id; }

  bool operator==(type_id const& other) const { return *id == *other.id; }

  bool operator<(type_id const& other) const { return id->before(*other.id); }

  char const* name() const { return id->name(); }

  std::type_info const* get_type_info() const { return this->id; };

private:
  std::type_info const* id;
};

#ifdef BOOST_MSVC
#pragma warning(pop)
#endif

} // namespace clbind
