export const updateCssVariables = (targetNode, config) => {
    var _a, _b;
    const headerHeight = ((_a = targetNode.querySelector(".rm-first-page-header")) === null || _a === void 0 ? void 0 : _a.clientHeight) || 0;
    const footerHeight = ((_b = targetNode.querySelector(".rm-page-footer")) === null || _b === void 0 ? void 0 : _b.clientHeight) || 0;
    const _pageContentHeight = config.pageHeight - config.contentMarginTop - config.contentMarginBottom - config.marginTop - config.marginBottom - headerHeight - footerHeight;
    const cssVariables = {
        "rm-page-content-height": `${_pageContentHeight}px`,
        "rm-page-height": `${config.pageHeight}px`,
        "rm-page-header-height": `${headerHeight}px`,
        "rm-page-footer-height": `${footerHeight}px`,
        "rm-max-content-child-height": `${_pageContentHeight - 10}px`,
        "rm-margin-top": `${config.marginTop}px`,
        "rm-margin-bottom": `${config.marginBottom}px`,
        "rm-margin-left": `${config.marginLeft}px`,
        "rm-margin-right": `${config.marginRight}px`,
        "rm-content-margin-top": `${config.contentMarginTop}px`,
        "rm-content-margin-bottom": `${config.contentMarginBottom}px`,
        "rm-page-gap-border-color": `${config.pageGapBorderColor}`,
        "rm-page-width": `${config.pageWidth}px`,
    };
    Object.entries(cssVariables).forEach(([key, value]) => {
        targetNode.style.setProperty(`--${key}`, value);
    });
};
export const getPageSize = (height, width, marginTop, marginBottom, marginLeft, marginRight) => {
    return {
        pageHeight: height,
        pageWidth: width,
        marginTop,
        marginBottom,
        marginLeft,
        marginRight,
    };
};
