'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@tiptap/core');
require('@tiptap/extension-text-style');

var FontSize = /*#__PURE__*/core.Extension.create({
  name: 'fontSize',
  addOptions: function addOptions() {
    return {
      types: ['textStyle']
    };
  },
  addGlobalAttributes: function addGlobalAttributes() {
    return [{
      types: this.options.types,
      attributes: {
        fontSize: {
          "default": null,
          parseHTML: function parseHTML(element) {
            return element.style.fontSize.replace(/['"]+/g, '');
          },
          renderHTML: function renderHTML(attributes) {
            if (!attributes.fontSize) {
              return {};
            }

            return {
              style: "font-size: " + attributes.fontSize
            };
          }
        }
      }
    }];
  },
  addCommands: function addCommands() {
    return {
      setFontSize: function setFontSize(fontSize) {
        return function (_ref) {
          var chain = _ref.chain;
          return chain().setMark('textStyle', {
            fontSize: fontSize
          }).run();
        };
      },
      unsetFontSize: function unsetFontSize() {
        return function (_ref2) {
          var chain = _ref2.chain;
          return chain().setMark('textStyle', {
            fontSize: null
          }).removeEmptyTextStyle().run();
        };
      }
    };
  }
});

exports.FontSize = FontSize;
exports.default = FontSize;
//# sourceMappingURL=tiptap-extension-font-size.cjs.development.js.map
