var cardData = {"code":"000000","msg":"operation.successful","traceId":"71ce01ec38ce414692a88a2fd44e7330.18616.17631185286483121","data":[{"id":10,"printerType":"Bambu Lab H2D","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/H2_D_707d0aad42.jpg"},{"id":12,"printerType":"Bambu Lab H2S","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/H2_S_3a0c3a1ca4.png"},{"id":13,"printerType":"Bambu Lab P2S","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/p2s_9c0d9f2ea2.png"},{"id":6,"printerType":"Bambu Lab P1S","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/COVER_b084d22761.png"},{"id":9,"printerType":"Bambu Lab X1C","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/X1_C_f429ebb303.JPEG"},{"id":8,"printerType":"Bambu Lab A1","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/Group_47969_3x_bec3e4fd04.jpg"},{"id":3,"printerType":"Bambu Lab A1 mini","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/large_Bambu_Lab_A1_mini_8a462ea54c_21e037b9d7_9bb73390d0.png"},{"id":5,"printerType":"Bambu Studio","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/20250530_190020_7b93deceed.png"},{"id":11,"printerType":"Bambu Suite","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/suite_zh_35048b0409.png"},{"id":7,"printerType":"Bambu Handy","img":"https://bbl-cms.oss-cn-shanghai.aliyuncs.com/zh_5d9e7c4dbe.png"}]};

var youtubeData = [
  {
    "id": "8TQCRVS72Us",
    "title": "Intro: Overview of Bambu Studio"
  },
  {
    "id": "AdHUVQiVeDI",
    "title": "Episode 1: Set Up Your Environment"
  },
  {
    "id": "LDrCjCPYbhE",
    "title": "Episode 2: Import 3D Printing Models"
  },
  {
    "id": "3MYKsbd7k0c",
    "title": "Episode 3: Adjust the Models to Be Printable - Part 1"
  },
  {
    "id": "KcMBajgOzS0",
    "title": "Episode 4: Adjust the Models to Be Printable - Part 2"
  },
  {
    "id": "4W4vczKsiX8",
    "title": "Episode 5: Setup for Filaments"
  },
  {
    "id": "lQ4ySwPQeY4",
    "title": "Episode 6: Color Models for Multi-Color Prints"
  },
  {
    "id": "3tft_Ahkd_w",
    "title": "Episode 7: Divide and Print Your Models on Multiple Plates"
  },
  {
    "id": "ZH9xqdQYXsI",
    "title": "Episode 8: The Basic Quality Settings"
  },
  {
    "id": "FRLympzHsWY",
    "title": "Episode 9: The Basic Strength Settings"
  },
  {
    "id": "1QJ2UKDamzc",
    "title": "Episode 10: The Basic Support Settings"
  },
  {
    "id": "EHZtnnQLtGs",
    "title": "Episode 11: The Basic Other Settings"
  },
  {
    "id": "DWna4Mwjs5c",
    "title": "Episode 12: Check Your Sliced Model in Preview"
  },
  {
    "id": "pnd1CZ-Dp34",
    "title": "Episode 13: Send a Print Job to Your Printer"
  },
  {
    "id": "SZCWxYeMZro",
    "title": "Episode 14: During the Print"
  },
];

var topicData = [
  {
    "title": "Quick Start",
    "zhcn-title": "快速开始",
    "children": [
      {
        "title": "Bambu Studio Quick Start Guide",
        "zhcn-title": "Bambu Studio 快速上手教程",
        "link": "software/bambu-studio/studio-quick-start"
      },
      {
        "title": "Remote Control & Monitoring",
        "zhcn-title": "远程控制和监控打印机",
        "link": "software/bambu-studio/remote-control"
      },
      {
        "title": "Use AMS on Bambu Studio",
        "zhcn-title": "在 Bambu Studio 中使用 AMS",
        "link": "software/bambu-studio/use-ams-on-bambu-studio"
      },
      {
        "title": "Bambu Studio Multi Plate Printing Guide",
        "zhcn-title": "Bambu Studio 多盘打印指南",
        "link": "studio-handy/multi-plate-printing"
      }, 
    ]
  },
  {
    "title": "Gizmo",
    "zhcn-title": "顶部工具栏",
    "children": [
      {
        "title": "Variable Layer Height",
        "zhcn-title": "可变层高",
        "link": "software/bambu-studio/adaptive-layer-height"
      },
      {
        "title": "Cut Tool",
        "zhcn-title": "切割工具",
        "link": "software/bambu-studio/cut-tool"
      },
      {
        "title": "Auto Orientation",
        "zhcn-title": "自动朝向",
        "link": "software/bambu-studio/auto-orientation"
      },
      {
        "title": "Split to Objects/Parts",
        "zhcn-title": "拆分为对象/零件",
        "link": "software/bambu-studio/split-to-objects-parts"
      },
      {
        "title": "Support Painting Guide",
        "zhcn-title": "支撑绘制",
        "link": "software/bambu-studio/support-painting"
      },
      {
        "title": "3D Text",
        "zhcn-title": "添加 3D 文本",
        "link": "software/bambu-studio/3d-text"
      }
    ]
  },
  {
    "title": "Right-click Tool",
    "zhcn-title": "右键工具",
    "children": [
      {
        "title": "Fix Model",
        "zhcn-title": "修复模型",
        "link": "software/bambu-studio/fix-model"
      },
      {
        "title": "Simplify Model",
        "zhcn-title": "简化模型",
        "link": "software/bambu-studio/simplify-model"
      },
      {
        "title": "Negative Part",
        "zhcn-title": "负零件",
        "link": "software/bambu-studio/subtract-a-part"
      },
      {
        "title": "Bambu Studio Modifier Operation Guide",
        "zhcn-title": "Studio 修改器操作指南",
        "link": "software/bambu-studio/modifier"
      }
    ]
  },
  {
    "title": "Multi-material Printing",
    "zhcn-title": "多材料打印",
    "children": [
      {
        "title": "Introduction to Filament Grouping Strategy for Dual Nozzle Printers",   
        "zhcn-title": "双喷嘴打印机耗材切片分组",
        "link": "software/bambu-studio/manual/dual-nozzles-slicing-filament-grouping"
      },
      {
        "title": "Multi-Color Printing",   
        "zhcn-title": "多色打印指南",
        "link": "software/bambu-studio/multi-color-printing"
      },
      {
        "title": "Color Painting Tool",   
        "zhcn-title": "涂色工具使用指南",
        "link": "software/bambu-studio/color-painting-tool"
      },
      {
        "title": "Reduce Waste during Filament Change",   
        "zhcn-title": "减少多色打印时的材料浪费",
        "link": "software/bambu-studio/reduce-wasting-during-filament-change"
      },
    ]
  },
  {
    "title": "Print Settings",
    "zhcn-title": "打印设置",
    "children": [
      {
        "title": "Special Slicing Mode in Bambu Studio",
        "zhcn-title": "Bambu Studio 特殊切片模式",
        "link": "software/bambu-studio/special-slicing-modes"
      },
      {
        "title": "How to Create Custom Preset",
        "zhcn-title": "创建自定义预设",
        "link": "software/bambu-studio/preset"
      },
      {
        "title": "Seam Settings",
        "zhcn-title": "接缝设置",
        "link": "software/bambu-studio/Seam"
      },
      {
        "title": "Support settings in Bambu Studio",
        "zhcn-title": "支撑耗材与支撑功能的介绍",
        "link": "software/bambu-studio/support"
      },
      {
        "title": "Brim",
        "zhcn-title": "Brim",
        "link": "software/bambu-studio/auto-brim"
      },
    ]
  },
  {
    "title": "Calibration",
    "zhcn-title": "流量校准",
    "children": [
      {
        "title": "Flow Rate Calibration",
        "zhcn-title": "流量比例",
        "link": "software/bambu-studio/calibration_flow_rate"
      },
      {
        "title": "Flow Dynamics Calibration",
        "zhcn-title": "动态流量校准",
        "link": "software/bambu-studio/calibration_pa"
      }
    ]
  },
  {
    "title": "Troubleshooting",
    "zhcn-title": "故障排除",
    "children": [
      {
        "title": "Failed to send print files",
        "zhcn-title": "无法发送打印文件",
        "link": "software/bambu-studio/failed-to-send-print-files"
      },
      {
        "title": "Fails of live-view",
        "zhcn-title": "加载视频流失败排查",
        "link": "software/bambu-studio/faq/live-view"
      },
      {
        "title": "Bambu Studio crashes/freezes troubleshooting guide",
        "zhcn-title": "Bambu Studio 崩溃/冻结故障排除指南",
        "link": "bambu-studio/troubleshoot/crash-freeze-issue"
      },
      {
        "title": "Export Bambu Studio software log",
        "zhcn-title": "导出Bambu PC软件日志",
        "link": "x1/troubleshooting/bambu-studio-log"
      },
      {
        "title": "Bambu Studio failed to Connect Printer",
        "zhcn-title": "Bambu Studio 连接打印机失败",
        "link": "software/bambu-studio/failed-to-connect-printer"
      },
    ]
  }
];

var $prev;
var $next;

var video_prev;
var video_next;

function OnInit() {
  getAcademyData();
  createVideoHTML();
  if (IsChinese())
    $("#tutorial_block").hide();
  createTopicHTML();
  TranslatePage();

  $prev = $('#academy_Left_Btn');
  $next = $('#academy_Right_Btn');

  $prev.on('click', () => scrollByStep(-1));
  $next.on('click', () => scrollByStep(+1));
  $('#academy_content').on('scroll', updateButtons);
  $(window).on('resize', updateButtons);
  updateButtons();

  $video_prev = $('#tutorial_Left_Btn');
  $video_next = $('#tutorial_Right_Btn');
  $video_prev.on('click', () => scrollVideoByStep(-1));
  $video_next.on('click', () => scrollVideoByStep(+1));
  $('#tutorial_content').on('scroll', updateVideoButtons);
  $(window).on('resize', updateVideoButtons);
  updateVideoButtons();

  $("#Wiki_Search_Input").on("input", debounce(function() {
    let keyword = $(this).val();
    searchWiki(keyword);
  }, 500));
  $("#Wiki_Search_Input").on("focus", function () {
    if (this.value.trim().length) {
      $(this).trigger("input");
    }
  });

  // $(".searchResult").on("click", function(e) {
  //   console.log(e);
  // });
  $(document).on('click', function (e) {
    if (!$(e.target).closest('.search').length) {
      $('#search_result_area').empty();
    }
  });
}

function debounce(fn, delay){
  let t;
  return function(...args){
    clearTimeout(t);
    t = setTimeout(() => fn.apply(this, args), delay);
  };
}

// search

function searchWiki(keyword) {
  var tSend={};
	tSend['sequence_id']=Math.round(new Date() / 1000);
	tSend['command']="search_wiki";
  tSend['data']={};
  tSend['data']['keyword']=keyword;

	SendWXMessage( JSON.stringify(tSend) );
}

function updateSearchResult(result) {
  let data = result["pages"]["search"];
  $('#search_result_area').empty();
  if (data["totalHits"] > 0) {
    data["results"].forEach(element => {
      if (IsChinese()) {
        if (element["locale"] != "zh")
          return;
      }else {
        if (element["locale"] != "en")
          return;
      }
      let html = `<div class="searchResult" onclick="openWikiUrl('${element.path}')">${element.title}</div>`;
      $('#search_result_area').append(html);
    });
  }
}

//--------------- Academy Cards -------------------

function getAcademyData() {
  var tSend={};
	tSend['sequence_id']=Math.round(new Date() / 1000);
	tSend['command']="get_academy_list";
  tSend['data']={};
  if(IsChinese()) {
    tSend['data']['region'] = "mainland";
  }else {
    tSend['data']['region'] = "oversea";
  }
	SendWXMessage( JSON.stringify(tSend) );
}

function createCardHTML(data) {
  for (let i = 0; i < data.length; i++) {
    let html = `<div class="card" data-idx="${i}" onclick="openAcademyUrl('${data[i].id}')">
                  <img class="cardImg" src="${get_image_url(data[i].printerType)}" />
                  <div class="cardTitle TextS1">${data[i].printerType}</div>
                </div>`;
    $('#academy_Card_Content').append(html)
  }
}

function stepCardSize() {
  const $first = $('#academy_Card_Content').children().first();
  if ($first.length === 0) return 0;
  let gap = 16;
  return $first.outerWidth(true) + gap;
}

function maxScrollLeft() {
  var a = $('#academy_Card_Content').outerWidth(true);
  var b = $('#academy_content').innerWidth();
  return Math.max(0, $('#academy_Card_Content').outerWidth(true) - $('#academy_content').innerWidth());
}

function clampScroll(x) {
  const max = maxScrollLeft();
  return Math.min(Math.max(0, x), max);
}

function updateButtons() {
  const x = Math.round($('#academy_content').scrollLeft());
  const max = Math.round(maxScrollLeft());
  $prev.prop('disabled', x <= 0);
  $next.prop('disabled', x >= max);
}

function scrollByStep(dir) {
  const step = stepCardSize();
  if (!step) return;
  const current = $('#academy_content').scrollLeft();
  const target = clampScroll(current + dir * step);
  $('#academy_content').stop(true, false).animate({ scrollLeft: target }, 260, 'swing', updateButtons);
}

function openAcademyUrl(id)
{
  let open_url = "";
  if (IsChinese()){
    open_url = "https://bambulab.cn/zh-cn/support/academy/";
  }else{
    let strLang=langStringTransfer();
    open_url = "https://bambulab.com/" + strLang + "/support/academy/";
  }
  open_url += id;
  OpenUrlInLocalBrowser(open_url);
}


// ---------------- Tutorials -------------------

function createVideoHTML() {
  let academyData = youtubeData;
  for (let i = 0; i < academyData.length; i++) {
    let html = `<div class="videoCard" onclick="openVideoUrl('${academyData[i].id}')">
                  <img class="videoThumbnail" src="img/${academyData[i].id}.jpg" />
                  <div class="videoTitle TextS1">${academyData[i].title}</div>
                </div>`;
    $('#tutorial_Card_Content').append(html)
  }
}

function stepVideoCardSize() {
  const $first = $('#tutorial_Card_Content').children().first();
  if ($first.length === 0) return 0;
  let gap = 16;
  return $first.outerWidth(true) + gap;
}

function maxVideoScrollLeft() {
  var a = $('#tutorial_Card_Content').outerWidth(true);
  var b = $('#tutorial_content').innerWidth();
  return Math.max(0, $('#tutorial_Card_Content').outerWidth(true) - $('#tutorial_content').innerWidth());
}

function videoClampScroll(x) {
  const max = maxVideoScrollLeft();
  return Math.min(Math.max(0, x), max);
}

function updateVideoButtons() {
  const x = Math.round($('#tutorial_content').scrollLeft());
  const max = Math.round(maxVideoScrollLeft());
  $video_prev.prop('disabled', x <= 0);
  $video_next.prop('disabled', x >= max);
}

function scrollVideoByStep(dir) {
  const step = stepVideoCardSize();
  if (!step) return;
  const current = $('#tutorial_content').scrollLeft();
  const target = videoClampScroll(current + dir * step);
  $('#tutorial_content').stop(true, false).animate({ scrollLeft: target }, 260, 'swing', updateVideoButtons);
}

function openVideoUrl(path)
{
  let open_url = "https://www.youtube.com/watch?v=";
  open_url += path;
  OpenUrlInLocalBrowser(open_url);
}

// ---------------- topic -------------------

function createTopicHTML() {
  for (let i = 0; i < topicData.length; i++) {
    let title;
    if (IsChinese()){
      title = topicData[i]['zhcn-title'];
    } else {
      title = topicData[i].title;
    }
    let html = `<div class="topicCard">
          <div class="topicTitle TextS1">${title}</div>
          <ul>`
    for (let j=0; j < topicData[i].children.length; j++) {
      let child_title;
      if (IsChinese()){
        child_title = topicData[i].children[j]['zhcn-title'];
      } else {
        child_title = topicData[i].children[j].title;
      }
      html += `<li onclick="openWikiUrl('${topicData[i].children[j].link}')">${child_title}</li>`;
    }
    html += `</ul></div>`;
    $('#topic_content').append(html)
  }
}

function openWikiUrl(path)
{
  let open_url = "https://wiki.bambulab.com/"
  if (IsChinese()){
    open_url += "zh/";
  }else{
    open_url += "en/";
  }
  open_url += path;

  var tSend={};
	tSend['sequence_id']=Math.round(new Date() / 1000);
	tSend['command']="userguide_wiki_open";
	tSend['data']={};
	tSend['data']['url']=open_url;
	
	SendWXMessage( JSON.stringify(tSend) );	
}

// --------------------common ----------------

function IsChinese()
{
	let strLang=GetQueryString("lang");
	if(strLang!=null)
	{}else{
		strLang=localStorage.getItem(LANG_COOKIE_NAME);
	}
	
	if(strLang!=null)
		return strLang.includes('zh')
	else
		return false;
}

function langStringTransfer()
{
  let strLang=GetQueryString("lang");
  if(strLang==null)
    strLang=localStorage.getItem(LANG_COOKIE_NAME);
  
  if(strLang.includes('zh')){
    return 'zh';
  }else if(strLang.includes('en')){
    return 'en';
  }else if(strLang.includes('fr')){
    return 'fr-fr';
  }else if(strLang.includes('de')){
    return 'de-de';
  }else if(strLang.includes('es')){
    return 'es-mx';
  }else if(strLang.includes('it')){
    return 'it-it';
  }else if(strLang.includes('ja')){
    return 'ja-jp';
  }else if(strLang.includes('ko')){
    return 'ko-kr';
  }else if(strLang.includes('pt')){ 
    return 'pt-br';
  }else if(strLang.includes('nl')){
    return 'nl-nl';
  }else{
    return 'en';
  }
}

function get_image_url(printer_type) {
  const normalized = (printer_type || '')
    .toLowerCase()
    .replace(/[^a-z0-9]/g, '');

  const mappings = [
    { keywords: ['h2d'], src: 'img/printer_h2d.png' },
    { keywords: ['h2s'], src: 'img/printer_h2s.png' },
    { keywords: ['p2s'], src: 'img/printer_p2s.png' },
    { keywords: ['p1s'], src: 'img/printer_p1s.png' },
    { keywords: ['a1mini'], src: 'img/printer_a1mini.png' },
    { keywords: ['a1'], src: 'img/printer_a1.png' },
    { keywords: ['x1c'], src: 'img/printer_x1c.png' },
    { keywords: ['studio'], src: 'img/studio.png' },
    { keywords: ['suite'], src: 'img/suite.png' },
    { keywords: ['handy'], src: 'img/handy.png' },
  ];

  for (const item of mappings) {
    if (item.keywords.some(keyword => normalized.includes(keyword))) {
      return item.src;
    }
  }
  return 'img/printer_a1.png';
}

function HandleStudio( pVal )
{
  let strCmd = pVal['command'];
  if(strCmd=='search_wiki_get')
	{
		updateSearchResult(pVal['data']);
	}else if(strCmd=='academy_list_get') {
    createCardHTML(pVal['data']);
  }
}

//---------------Global-----------------
window.postMessage = HandleStudio;
