/// <reference types="node" />
import { Readable } from 'stream';
import { Metadata } from './metadata';
import { CreateReadStreamOptions, SourceDestination } from './source-destination';
import { Dictionary } from '../utils';
/**
 * Configuration for URLCompressedSource
 * Maps keys to their direct URLs (similar to what S3 would provide)
 */
export interface URLSourceConfig {
    VERSION: string;
    VERSION_HOSTOS: string;
    'device-type.json': string;
    'image.json': string;
    parts: Dictionary<string>;
}
export interface URLCompressedSourceOptions {
    urls: URLSourceConfig;
    format: 'zip' | 'gzip';
    filenamePrefix?: string;
    configuration?: Dictionary<any>;
    deviceType: string;
    buildId: string;
}
/**
 * URLCompressedSource - Downloads and streams compressed images from direct URLs
 * Similar to BalenaS3CompressedSource but uses pre-configured URLs instead of S3 paths
 *
 * Supports regular disk images (zipped or gzipped) and edison zip archives (zip only as it contains many files).
 * No random reads, you can't use this with ConfiguredSource.
 * Instead it handles the configuration on its own.
 * Partial compressed files are streamed from URLs.
 * If a partition (or disk image in the zip archive for edisons) needs configuration, it is downloaded, decompressed and recompressed.
 * The complete compressed stream is created from the partial compressed files from URLs and the configured parts described above.
 */
export declare class URLCompressedSource extends SourceDestination {
    readonly deviceType: string;
    readonly buildId: string;
    private urls;
    private format;
    private filenamePrefix?;
    private configuration?;
    private configuredParts;
    private imageJSON;
    private deviceTypeJSON;
    private supervisorVersion;
    private osVersion;
    private lastModified;
    private size;
    private filename;
    constructor({ urls, format, filenamePrefix, configuration, buildId, deviceType, }: URLCompressedSourceOptions);
    private getSize;
    private getFilename;
    protected _getMetadata(): Promise<Metadata>;
    private getSupervisorVersion;
    private getOsVersion;
    private getImageJSON;
    private getDeviceTypeJSON;
    private getPartStream;
    private download;
    private findPartitionPart;
    private findImagePart;
    private findPart;
    private extractDeflateToDisk;
    private configure;
    protected _open(): Promise<void>;
    private getParts;
    private createZipStream;
    private createGzipStream;
    private createStream;
    createReadStream(options?: CreateReadStreamOptions): Promise<Readable>;
    canCreateReadStream(): Promise<boolean>;
}
