# Change Log

All notable changes to this project will be documented in this file
automatically by Versionist. DO NOT EDIT THIS FILE MANUALLY!
This project adheres to [Semantic Versioning](http://semver.org/).

# v12.0.2
## (2024-04-08)

* Update actions/setup-python digest to 65d7f2d [Self-hosted Renovate Bot]

# v12.0.1
## (2024-04-08)

* Pin actions/setup-node action to 1a4442c [Self-hosted Renovate Bot]

# v12.0.0
## (2024-04-08)

* Update dependency node-addon-api to v8 [Self-hosted Renovate Bot]
* Drop support for node < 18 [Thodoris Greasidis]

# v11.2.2
## (2024-03-08)

* Bump node-gyp [Otavio Jacobi]

# v11.2.1
## (2024-02-15)

* Replace deprecated flowzone input tests_run_on [Kyle Harding]

# v11.2.0
## (2024-01-18)

* Add support to node20 [Otávio Jacobi]

# v11.1.1
## (2024-01-04)

* Remove repo config from flowzone.yml [Kyle Harding]

# v11.1.0
## (2023-01-05)

* Update dependencies [ab77]

# v11.0.4
## (2022-11-03)

* fix build [Zane Hitchcox]

# v11.0.3
## (2022-11-03)

* support node 16 [Zane Hitchcox]

# v11.0.2
## (2022-10-25)

* Update dependency @types/mocha to 10.0.0 [Renovate Bot]

# v11.0.1
## (2022-10-25)

* Switch to Flowzone [ab77]

# v11.0.0
## (2022-06-21)

* Switching to Napi [Zane Hitchcox]

# v10.0.0
## (2022-06-15)

* Switching to Napi [Zane Hitchcox]

# v9.2.4
## (2021-01-19)

* Pass strings between methods as std::string instead of char * [Floris Bos]

# v9.2.3
## (2021-01-19)

* Support lsblk versions that do no support the pttype column [Alexis Svinartchouk]

# v9.2.2
## (2020-11-30)

* Update typescript to v4.1.2 [Alexis Svinartchouk]
* Add versionbot changelog [Alexis Svinartchouk]

# v9.2.1
## (2020-11-19)

* Make drivelist context aware [warpdesign]

# v9.2.0
## (2020-11-19)

* An empty string is a valid description [Alexis Svinartchouk]
* Add partitionTableType field: 'gpt', 'mbr' or null (windows) [Alexis Svinartchouk]
* Add partitionTableType field: 'gpt', 'mbr' or null (mac) [Alexis Svinartchouk]
* Add partitionTableType field: 'gpt', 'mbr' or null (linux) [Alexis Svinartchouk]

# v9.1.0
## (2020-08-06)

* Load bindings once [Alexis Svinartchouk]
* Mark APFS media as virtual and assign its mountpoints to the source drive [Alexis Svinartchouk]

# v9.0.2
## (2020-05-29)

* Remove gitter link [Alexis Svinartchouk]

# v9.0.1
## (2020-05-29)

* Rename resin -> balena [Alexis Svinartchouk]

# v9.0.0
## (2020-05-27)

* Update resin-lint to @balena/lint [Alexis Svinartchouk]
* Remove mz dependency, target node 10 [Alexis Svinartchouk]

## 8.0.10 - 2020-02-18

* Fix lsblk --pairs parsing when a value has hexadecimal escapes [Alexis Svinartchouk]

## 8.0.9 - 2019-11-06

* Avoid segfaulting on mac when some disk description fields are null [Alexis Svinartchouk]

## 8.0.8 - 2019-10-08

* Fix tests [Alexis Svinartchouk]
* Fix typo in readme [Alexis Svinartchouk]

## 8.0.7 - 2019-09-20

* Update nan to ^2.14 to fix builds targetting electron 6 [Alexis Svinartchouk]

## 8.0.6 - 2019-03-20

* Update example in readme [Alexis Svinartchouk]

## 8.0.5 - 2019-03-20

* Update resin-lint to ^3.0.1 [Alexis Svinartchouk]

## 8.0.4 - 2019-03-19

* Unregister DASession callback to avoid crash [Robert Vojta]

## 8.0.3 - 2019-03-18

* Fix DASession and NSMutableArray leaks on macOS [Alexis Svinartchouk]

## 8.0.2 - 2019-03-04

* Fix isVirtual value on macOS [Robert Vojta]

## 8.0.1 - 2019-02-27

* Fix macOS crash when SD card is ejected [Robert Vojta]

## 8.0.0 - 2019-02-22

* Address PR comments [Alexis Svinartchouk]
* Try `lsblk --pairs` if parsing `lsblk --json` fails [Alexis Svinartchouk]
* Convert to typescript, use promises instead of callbacks [Alexis Svinartchouk]

## 7.0.3 - 2019-02-20

* Fix parsing lsblk --pairs output for disks with no partition table [Alexis Svinartchouk]

## 7.0.2 - 2019-02-20

* Update prebuild to ^8.1.2 [Alexis Svinartchouk]

## 7.0.1 - 2019-01-28

* Remove unused diskutil file and its tests [Alexis Svinartchouk]

## 7.0.0 - 2019-01-28

* Remove outdated docs. [Alexis Svinartchouk]
* Feat(mac): Native implementation for drivelist [Robin Andersson]

## 6.4.6 - 2019-01-10

* Fix tests incorrect mountpoints [Lorenzo Alberto Maria Ambrosi]
* Fix devices mountpoints for lsblk in pairs mode [Lorenzo Alberto Maria Ambrosi]

## 6.4.5 - 2019-01-10

* Fix tests incorrect device.size [Lorenzo Alberto Maria Ambrosi]
* Fix linting errors & add specs with plist return value assertions [Robin Andersson]

## 6.4.4 - 2019-01-10

* Fix build on xcode 10.1 [Alexis Svinartchouk]

## v6.4.3 - 2018-09-10

* Lsblk: Fix listing of empty mountpoints [Jonas Hermsmeier]

## v6.4.2 - 2018-09-03

* Lsblk: Check `hotplug` to set `isRemovable` [Jonas Hermsmeier]
* Ci: Add .resinci.yml [John (Jack) Brown]

## v6.4.1 - 2018-08-28

* Lsblk: Fix missing `devicePath` property [Jonas Hermsmeier]

## v6.4.0 - 2018-08-02

* Feat(diskutil): Populate devicePath on Mac OS #297 [Jonas Hermsmeier]

## v6.3.2 - 2018-08-02

* Fix(diskutil): Also probe Ejectable to determine removabililty #298 [Jonas Hermsmeier]

## v6.3.1 - 2018-08-01

* Test(lsblk): Add test case for root device mountpoints #293 [Jonas Hermsmeier]
* Fix(lsblk): Enumerate mountpoints on root devices #293 [Jonas Hermsmeier]
* Fix(lsblk): Fall back to mountpoint if no label given #293 [Jonas Hermsmeier]
* Fix(lsblk): Resolve relative device names #293 [Jonas Hermsmeier]

## v6.3.0 - 2018-07-09

* Fix(linux): Fix pair consolidation for lsblk #255 [Jonas Hermsmeier]
* Feat(lib): Use lsblk directly, parse json output #255 [Jonas Hermsmeier]

## v6.2.5 - 2018-07-06

* Fix(linux): Add flag to lsblk to list all devices #287 [Jonas Hermsmeier]

## v6.2.4 - 2018-07-04

* Fix(test): Add python requirements.txt for tests #288 [Jonas Hermsmeier]

## v6.2.3 - 2018-05-25

* Fix(src): Fix nan callback deprecation warning #284 [Jonas Hermsmeier]

## v6.2.2 - 2018-05-10

* Fix(ci): Fix Node version arg passed to prebuild script #280 [Jonas Hermsmeier]

## v6.2.1 - 2018-05-10

* Upgrade(package): Bump prebuild dependencies #279 [Jonas Hermsmeier]
* Fix(ci): Only prebuild with Node 10 #279 [Jonas Hermsmeier]

## v6.2.0 - 2018-05-09

* Feat(linux): Add unique device path #278 [User Name]

## v6.1.8 - 2018-04-26

* Chore(ci): Build, test & publish releases for Node.js v10 #273 [Tim Perry]

## v6.1.7 - 2018-04-16

* Fix(diskutil): Fall back to MediaName if EntryName is not available #270 [Jonas Hermsmeier]
* Fix(diskutil): Track & filter out device info errors #270 [Jonas Hermsmeier]

## v6.1.6 - 2018-04-13

* Fix(diskutil): Added an error for diskutil returning null [grumpyoldman-io]

## v6.1.5 - 2018-04-05

* Fix(diskutil): Fix ReferenceError when DeviceNode is undefined #266 [Jonas Hermsmeier]

## v6.1.4 - 2018-04-02

* Upgrade(package): Bump dependencies #264 [Jonas Hermsmeier]

## v6.1.3 - 2018-03-17

* Fix(diskutil): Use VolumeAllocationBlockSize if available #260 [Jonas Hermsmeier]

## v6.1.2 - 2018-03-16

* Fix(test): Avoid test timeout on AppVeyor #259 [Jonas Hermsmeier]
* Test(diskutil): Add tests for devices without partitions #259 [Jonas Hermsmeier]
* Fix(diskutil): Support mountpoints without partitions #259 [Jonas Hermsmeier]
* Fix(diskutil): Fix handling of devices without partitions #259 [Jonas Hermsmeier]

## v6.1.1 - 2018-03-13

* Fix(package): Remove obsolete bin entries #256 [Jonas Hermsmeier]

## v6.1.0 - 2018-03-09

* Feat(lib): Use diskutil directly, parse plist output #253 [Jonas Hermsmeier]

## v6.0.5 - 2018-03-02

* Upgrade(package): Bump dependencies #252 [Jonas Hermsmeier]

## v6.0.4 - 2018-01-18

* Fix(windows): Impl IsSystemDevice() #250 [Jonas Hermsmeier]

## v6.0.3 - 2018-01-18

* Fix crash on Windows 7 #249 [Jonas Hermsmeier]

## v6.0.2 - 2018-01-14

* Fix(darwin): Use proper flag to enable extended regexes in `sed` Fixes #247 #248 [Andrew Scheller]

## v6.0.1 - 2018-01-12

* Fix(darwin): Allow mountpoints containing space characters #246 [Andrew Scheller]

## v6.0.0 - 2018-01-05

* Feat: Rewrite native bindings to use IOCTL #243 [Jonas Hermsmeier]

## v5.2.12 - 2017-12-28

* Chore(package): Bump dependencies #242 [Jonas Hermsmeier]

## v5.2.11 - 2017-12-14

* Refactor: Remove lodash #235 [Jonas Hermsmeier]

## v5.2.10 - 2017-12-12

* Fix(package): Fix prebuild script being run on build #236 [Jonas Hermsmeier]

## v5.2.9 - 2017-12-09

* Fix: Remove the final usage of perl from darwin.sh #238 [Andrew Scheller]

## v5.2.8 - 2017-12-08

* Chore: pip on Travis OSX is now pip2 #239 [Andrew Scheller]

## v5.2.7 - 2017-10-17

* Upgrade(package): Bump dependencies #232 [Jonas Hermsmeier]

## v5.2.6 - 2017-10-13

* Fix(ci): Ensure the Travis box finds bash #230 [Jonas Hermsmeier]

## v5.2.5 - 2017-10-13

* Chore(ci): Add CI deployment scripts #227 [Jonas Hermsmeier]

## v5.2.4 - 2017-10-06

* Correctly execute macOS and GNU/Linux scripts inside directories mounted as `noexec`. #229 [Juan Cruz Viotti]

## v5.2.3 - 2017-10-06

* Fix: Bring back support for Node.js v4 #225 [Zoltan Kochan]

## v5.2.2 - 2017-10-02

* Chore(appveyor): Explicitly set base image #223 [Jonas Hermsmeier]

## v5.2.1 - 2017-09-28

* Upgrade(package): Update dependencies #221 [Jonas Hermsmeier]

## v5.2.0 - 2017-09-28

* Feat(package): Add prebuilds for native bindings #219 [Jonas Hermsmeier]

## v5.1.8 - 2017-08-28

* Store GNU/Linux temporary scripts in `$XDG_RUNTIME_DIR`. #209 [Juan Cruz Viotti]

## v5.1.7 - 2017-08-28

* Ensure all volume handles get closed on Windows. #212 [Juan Cruz Viotti]

## v5.1.6 - 2017-08-28

* Fix(windows): log the volume we're working on #211 [Juan Cruz Viotti]

## v5.1.5 - 2017-08-14

* Correctly handle BitLocker locked Windows volumes. #206 [Juan Cruz Viotti]

## v5.1.4 - 2017-08-07

* Get more detailed error codes from the Windows implementation. [Juan Cruz Viotti]

## v5.1.3 - 2017-08-01

* Fix "Couldn't scan the drives: An unknown error occurred" where there is a mounted virtual drive. [Juan Cruz Viotti]

## v5.1.2 - 2017-08-01

* Fix "Couldn't initialize the scanner: An unknown error occurred" error. [Juan Cruz Viotti]

## v5.1.1 - 2017-08-01

* Refactor(windows): don't use COM/WMI to retrieve a drive media type [Juan Cruz Viotti]

## v5.1.0 - 2017-07-31

* Feat: add a `displayName` property to drive objects [Juan Cruz Viotti]

## v5.0.28 - 2017-07-31

* Feat(windows): print HRESULT hex in debug information [Juan Cruz Viotti]

## v5.0.27 - 2017-07-19

* Fix: small typo in EAGAIN error message [Juan Cruz Viotti]

## v5.0.26 - 2017-07-18

* Fix: handle EAGAIN spawning errors [Juan Cruz Viotti]
* Refactor: reduce debug logging if unlink was successful [Juan Cruz Viotti]

## v5.0.25 - 2017-06-29

* Feat(windows): print debugging information when DRIVELIST_DEBUG is set [Juan Cruz Viotti]
* Fix: property clean up tmp file after exec [Jonas Hermsmeier]
* Fix(windows): ERROR_NOT_READY on empty SD Card reader [Juan Cruz Viotti]
* Chore(package): Fix missing EOL in package.json [Jonas Hermsmeier]
* Fix(windows): all drives are interpreted as read-only [Juan Cruz Viotti]
* Refactor(windows): don't use WMI to list volumes [Juan Cruz Viotti]
* Fix(windows): detect read-only flag on SD Cards without a filesystem (#183) [Juan Cruz Viotti]
* Refactor(windows): Use an IOCTL to determine the partition type (#181) [Juan Cruz Viotti]

## v5.0.24 - 2017-06-27

* Refactor(windows): implement volume::GetType() [Juan Cruz Viotti]

## v5.0.23 - 2017-06-15

* Upgrade(package): Bump dependencies [Jonas Hermsmeier]
* Doc(README): Add npm monthly download count [Jonas Hermsmeier]
* Adapt changelog for versionbot [Kostas Lekkas]
* Doc(README): Fix Travis link, use Etcher chat [Jonas Hermsmeier]

## v5.0.22

- Fix perl taking all the CPU in macOS in some cases

## v5.0.21

- Join volume and device names as descriptions if they both exists on macOS

## v5.0.20

- Inline platform scripts as a JSON file.

## v5.0.19

- Correctly deal with unicode characters coming from drive descriptions
- Correctly deal with invalid escape sequences coming from drive descriptions

## v5.0.18

- Fix mountpoints getting cut if they contain a `#` in GNU/Linux and macOS

## v5.0.17

- Fix literal `\040` on mountpoints that contain spaces in GNU/Linux

## v5.0.16

- Fix awk expression that replaces periods with underscores before evaluating
  `udevadm` output in GNU/Linux.

## v5.0.15

- Increase debug logging in the case of script errors
- Prevent errors when unplugging drives while the scripts are running

## v5.0.14

- Catch the exit code of the wrapped VBScript on Windows.

## v5.0.13

**Important:** v5.0.11 and v5.0.12 were both published to NPM from a Windows
machine. This messed up the execution permissions of the drive detection
scripts, causing `EACCES` errors.

This version is equal to v5.0.12, but was released from a UNIX based system.

## v5.0.12 [BROKEN]

- Ensure the Windows script has execution permissions.

## v5.0.11 [BROKEN]

- Omit empty SD Card readers on Windows.

## v5.0.10

- Don't include drive letters assigned to no file system in Windows mount points.

## v5.0.9

- Print platform scripts `stderr` output to a debug channel instead of throwing if the script exitted with code zero.
- Fix bug where only the first mount point is reported on GNU/Linux.
- Ensure every potentially problematic value is double quoted in the GNU/Linux and macOS scripts.

## v5.0.8

- Fix "is not recognised as an internal or external command" errors on Windows.

## v5.0.7

- Interpret "Fixed" drives as system drives in macOS.

## v5.0.6

- Fix uncaught error caused by a weird Windows configuration edge where multiple partitions were reported to have the same drive letter.

## v5.0.5

- Fix system drives being detected as removable drives on Mac Mini.

## v5.0.4

- Replace periods with underscores before evaluating `udevadm` output in GNU/Linux.

## v5.0.3

- Fix `drivelist` not detecting mountpoints in Windows due to a space/tab YAML parsing issue.

## v5.0.2

- Don't require .NET VBScript classes in Windows platform script.

## v5.0.1

- Fix `YAMLException: bad indentation of a sequence entry` Windows error.

## v5.0.0

- Transform `mountpoint` into an array of objects called `mountpoints`.
- Improve GNU/Linux detection performance.
- Correctly get SD Card readers descriptions in GNU/Linux.

## v4.0.0

- Ignore invalid YAML output from platform scripts.
- Group mount points of drives with multiple partitions in Windows.
- Switch project to JavaScript.
- Switch license to Apache 2.0.

## v3.3.4

- Ensure `%SYSTEMROOT%\System32` is in the `%PATH%` before calling `cscript.exe` on Windows.

## v3.3.3

- Default device name to device id if drive doesn't have an assigned letter in Windows.

## v3.3.2

- List all partition's mountpoints in OS X.

## v3.3.1

- Fix `blkid: command not found` in GNU/Linux.

## v3.3.0

- Fix `null` device when unplugging a device while detecting drives.
- Expose a "raw" property in all devices.
- Attempt to display the volume name as description in OS X.

## v3.2.6

- Fix internal removable drives being considered "system" in macOS Sierra.

## v3.2.5

- Fix YAML error when a description contains question marks in GNU/Linux.

## v3.2.4

- Fix missing sizes in macOS Sierra.

## v3.2.3

- Handle mountpoints with spaces in GNU/Linux.

## v3.2.2

- Check if drive is removable when the drive has no file system in Windows.

## v3.2.1

- Make use of `df` to determine mountpoints in GNU/Linux.

## v3.2.0

- Add a property called `protected`.

## v3.1.2

- Prevent certain system drives to be detected as removable in GNU/Linux.

## v3.1.1

- Fix issue that caused some hard drives to be listed as removable drives.

## v3.1.0

- Show non-mountable disk drives in Windows.

## v3.0.0

- Parse size as a number representing bytes.

## v2.0.14

- Detect mount points of drives mounted by UUID on GNU/Linux.

## v2.0.13

- Keep once decimal in Windows drive sizes.

## v2.0.12

- Make sure MacBook's internal SDCard readers are marked as removable.

## v2.0.11

- Escape double quotes in description to prevent YAML errors.

## v2.0.10

- Improve the way we detect system drives in Windows.

## v2.0.9

- Use `udev` to determine if a drive is removable on GNU/Linux.
- Mark internal and non-removable drives as system drives in OS X.
- Omit loop devices in GNU/Linux.
- Omit CD/DVD drives in GNU/Linux.

## v2.0.8

- Omit mounted DMG images in OS X.

## v2.0.7

- Add a display name property called `name`.

## v2.0.6

- Fix boolean values being surrounded by quotes.

## v2.0.5

- Trim trailing commas on GNU/Linux mountpoints.

## v2.0.4

- Support running inside Electron.

## v2.0.3

- Treat multiple mountpoint as a comma separated list of paths in GNU/Linux.

## v2.0.2

- Escape paths including spaces in unix based operating systems.

## v2.0.1

- Escape backslashes in Windows devices to avoid weird characters.

## v2.0.0

- Add example file for easy testing.
- Redesign Windows script to match the new output scheme.
- Refer to `osx` as Darwin everywhere.
- Implement GNU/Linux scanning bash script.
- Unify parsing between all supported operating systems.
- Add `system` property to returned drives.
- Remove `drivelist.isSystem()` predicate.
- Fix issue that caused some OS X drives to not be detected.

## v1.3.2

- Handle edge case where OS X drives contain a description within parenthesis in `diskutil list`.

## v1.3.1

- Surround Windows script path in double quotes to avoid issues with paths incuding white space.

## v1.3.0

- Add `mountpoint` attribute to drives.

## v1.2.2

- Fix issue where a removable drive was detected as a system drive in Linux.

## v1.2.1

- Fix win32 issue where DeviceID gets part of the device description.

## v1.2.0

- Implement isSystem predicate.

## v1.1.2

- Prevent empty lsblk model crash the module. Return `undefined` description instead.

## v1.1.1

- Prevent empty wmic size crash the module. Return `undefined` size instead.

## v1.1.0

- Return non supported OS error to the callback instead of just throwing it.
