import { Disk } from 'file-disk';
import { GPTPartition, MBRPartition } from 'partitioninfo';
import { TypedError } from 'typed-error';
/**
 * @summary An error to describe why getFsLabel() failed to find a filesystem label.
 */
export declare class LabelNotFound extends TypedError {
    constructor(partitionIndex: number, description: string);
}
/**
 * @summary Returns the label encoded in the filesystem for a given partition,
 * or throws LabelNotFound if can't determine label location.
 *
 * This function focuses on balenaOS devices and does not attempt to read the
 * many possible filesystem types.
 *
 * @example
 *
 * await filedisk.withOpenFile('/foo/bar.img', 'r', async (handle) => {
 *     const disk = new filedisk.FileDisk(handle);
 *     const info = partitioninfo.getPartitions(disk);
 *     for (const partition of info.partitions) {
 *         const label = await getFsLabel(disk, partition);
 *         console.log(`${partition.index}: ${label}`);
 *     }
 * }
 */
export declare function getFsLabel(disk: Disk, partition: GPTPartition | MBRPartition): Promise<string>;
