/// <reference types="node" />
import { Checksum } from './checksum';
import { Block } from './block';
/**
 * BlockMap (BLKX) data (aka Mish Data)
 */
export declare class BlockMap {
    /** Size of BlockMap structure in bytes (without Block entries) */
    static readonly SIZE = 204;
    /** BlockMap data signature */
    static readonly SIGNATURE = 1835627368;
    /** BLKX Version (latest known == 1) */
    static readonly VERSION = 1;
    static readonly Block: typeof Block;
    /** Signature */
    signature: number;
    /** Version number */
    version: number;
    /** LBA of starting sector */
    sectorNumber: number;
    /** Number of sectors in this block range */
    sectorCount: number;
    /** Offset of data (within what?) */
    dataOffset: number;
    /** Buffers needed (?) */
    buffersNeeded: number;
    /** Block descriptor number */
    blockDescriptorCount: number;
    /** Reserved 1 */
    reserved1: number;
    /** Reserved 2 */
    reserved2: number;
    /** Reserved 3 */
    reserved3: number;
    /** Reserved 4 */
    reserved4: number;
    /** Reserved 5 */
    reserved5: number;
    /** Reserved 6 */
    reserved6: number;
    /** Checksum descriptor */
    checksum: Checksum;
    /** Number of blocks in map */
    blockCount: number;
    /** List of mapped blocks */
    blocks: Block[];
    /** Parse BlockMap data from a buffer */
    static parse(buffer: Buffer, offset?: number): BlockMap;
    /** Parse BlockMap data from a buffer */
    parse(buffer: Buffer, offset?: number): this;
    /** Write BlockMap data to a buffer */
    write(buffer: Buffer, offset?: number): Buffer;
}
