/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import android.icu.text.DateFormatSymbols;
import android.icu.util.ULocale;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class CalendarDataUtility {
    private static final String ISLAMIC_CALENDAR = "islamic";
    private static final String GREGORIAN_CALENDAR = "gregorian";
    private static final String BUDDHIST_CALENDAR = "buddhist";
    private static final String JAPANESE_CALENDAR = "japanese";
    private static int[] REST_OF_STYLES = new int[]{32769, 2, 32770, 4, 32772};

    private CalendarDataUtility() {
    }

    public static String retrieveFieldValueName(String id, int field, int value, int style, Locale locale) {
        if (field == 0) {
            switch (CalendarDataUtility.normalizeCalendarType(id)) {
                case "buddhist": 
                case "islamic": {
                    --value;
                    break;
                }
                case "japanese": {
                    value += 231;
                    break;
                }
            }
        }
        if (value < 0) {
            return null;
        }
        String[] names = CalendarDataUtility.getNames(id, field, style, locale);
        if (value >= names.length) {
            return null;
        }
        return names[value];
    }

    public static String retrieveJavaTimeFieldValueName(String id, int field, int value, int style, Locale locale) {
        return CalendarDataUtility.retrieveFieldValueName(id, field, value, style, locale);
    }

    public static Map<String, Integer> retrieveFieldValueNames(String id, int field, int style, Locale locale) {
        Map<String, Integer> names;
        if (style == 0) {
            names = CalendarDataUtility.retrieveFieldValueNamesImpl(id, field, 1, locale);
            for (int st : REST_OF_STYLES) {
                names.putAll(CalendarDataUtility.retrieveFieldValueNamesImpl(id, field, st, locale));
            }
        } else {
            names = CalendarDataUtility.retrieveFieldValueNamesImpl(id, field, style, locale);
        }
        return names.isEmpty() ? null : names;
    }

    private static Map<String, Integer> retrieveFieldValueNamesImpl(String id, int field, int style, Locale locale) {
        String[] names = CalendarDataUtility.getNames(id, field, style, locale);
        int skipped = 0;
        int offset = 0;
        if (field == 0) {
            switch (CalendarDataUtility.normalizeCalendarType(id)) {
                case "buddhist": 
                case "islamic": {
                    offset = 1;
                    break;
                }
                case "japanese": {
                    skipped = 232;
                    offset = -231;
                    break;
                }
            }
        }
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (int i = skipped; i < names.length; ++i) {
            if (names[i].isEmpty() || result.put(names[i], i + offset) == null) continue;
            return new LinkedHashMap<String, Integer>();
        }
        return result;
    }

    public static Map<String, Integer> retrieveJavaTimeFieldValueNames(String id, int field, int style, Locale locale) {
        return CalendarDataUtility.retrieveFieldValueNames(id, field, style, locale);
    }

    private static String[] getNames(String id, int field, int style, Locale locale) {
        int context = CalendarDataUtility.toContext(style);
        int width = CalendarDataUtility.toWidth(style);
        DateFormatSymbols symbols = CalendarDataUtility.getDateFormatSymbols(id, locale);
        switch (field) {
            case 2: {
                return symbols.getMonths(context, width);
            }
            case 0: {
                switch (width) {
                    case 2: {
                        return symbols.getNarrowEras();
                    }
                    case 0: {
                        return symbols.getEras();
                    }
                    case 1: {
                        return symbols.getEraNames();
                    }
                }
                throw new UnsupportedOperationException("Unknown width: " + width);
            }
            case 7: {
                return symbols.getWeekdays(context, width);
            }
            case 9: {
                return symbols.getAmPmStrings();
            }
        }
        throw new UnsupportedOperationException("Unknown field: " + field);
    }

    private static DateFormatSymbols getDateFormatSymbols(String id, Locale locale) {
        String calendarType = CalendarDataUtility.normalizeCalendarType(id);
        return new DateFormatSymbols(ULocale.forLocale(locale), calendarType);
    }

    private static int toWidth(int style) {
        switch (style) {
            case 1: 
            case 32769: {
                return 0;
            }
            case 4: 
            case 32772: {
                return 2;
            }
            case 2: 
            case 32770: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid style: " + style);
    }

    private static int toContext(int style) {
        switch (style) {
            case 1: 
            case 2: 
            case 4: {
                return 0;
            }
            case 32769: 
            case 32770: 
            case 32772: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid style: " + style);
    }

    private static String normalizeCalendarType(String requestID) {
        String type = requestID.equals("gregory") || requestID.equals("iso8601") ? GREGORIAN_CALENDAR : (requestID.startsWith(ISLAMIC_CALENDAR) ? ISLAMIC_CALENDAR : requestID);
        return type;
    }
}

