/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Era;
import sun.util.calendar.Gregorian;
import sun.util.calendar.JulianCalendar;
import sun.util.calendar.LocalGregorianCalendar;

public abstract class CalendarSystem {
    private static final Map<String, Class<?>> names;
    private static final ConcurrentMap<String, CalendarSystem> calendars;
    private static final Gregorian GREGORIAN_INSTANCE;

    public static Gregorian getGregorianCalendar() {
        return GREGORIAN_INSTANCE;
    }

    public static CalendarSystem forName(String calendarName) {
        if ("gregorian".equals(calendarName)) {
            return GREGORIAN_INSTANCE;
        }
        CalendarSystem cal = (CalendarSystem)calendars.get(calendarName);
        if (cal != null) {
            return cal;
        }
        Class<LocalGregorianCalendar> calendarClass = names.get(calendarName);
        if (calendarClass == null) {
            return null;
        }
        if (calendarClass.isAssignableFrom(LocalGregorianCalendar.class)) {
            cal = LocalGregorianCalendar.getLocalGregorianCalendar(calendarName);
        } else {
            try {
                cal = (CalendarSystem)calendarClass.newInstance();
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }
        if (cal == null) {
            return null;
        }
        CalendarSystem cs = calendars.putIfAbsent(calendarName, cal);
        return cs == null ? cal : cs;
    }

    public static Properties getCalendarProperties() throws IOException {
        Properties calendarProps = new Properties();
        try (InputStream is = ClassLoader.getSystemResourceAsStream("calendars.properties");){
            calendarProps.load(is);
        }
        return calendarProps;
    }

    public abstract String getName();

    public abstract CalendarDate getCalendarDate();

    public abstract CalendarDate getCalendarDate(long var1);

    public abstract CalendarDate getCalendarDate(long var1, CalendarDate var3);

    public abstract CalendarDate getCalendarDate(long var1, TimeZone var3);

    public abstract CalendarDate newCalendarDate();

    public abstract CalendarDate newCalendarDate(TimeZone var1);

    public abstract long getTime(CalendarDate var1);

    public abstract int getYearLength(CalendarDate var1);

    public abstract int getYearLengthInMonths(CalendarDate var1);

    public abstract int getMonthLength(CalendarDate var1);

    public abstract int getWeekLength();

    public abstract Era getEra(String var1);

    public abstract Era[] getEras();

    public abstract void setEra(CalendarDate var1, String var2);

    public abstract CalendarDate getNthDayOfWeek(int var1, int var2, CalendarDate var3);

    public abstract CalendarDate setTimeOfDay(CalendarDate var1, int var2);

    public abstract boolean validate(CalendarDate var1);

    public abstract boolean normalize(CalendarDate var1);

    static {
        calendars = new ConcurrentHashMap<String, CalendarSystem>();
        names = new HashMap();
        names.put("gregorian", Gregorian.class);
        names.put("japanese", LocalGregorianCalendar.class);
        names.put("julian", JulianCalendar.class);
        GREGORIAN_INSTANCE = new Gregorian();
    }
}

