/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.util.Comparator;
import sun.security.x509.AVA;

class AVAComparator
implements Comparator<AVA> {
    private static final Comparator<AVA> INSTANCE = new AVAComparator();

    private AVAComparator() {
    }

    static Comparator<AVA> getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(AVA a1, AVA a2) {
        int pos;
        int len;
        boolean a1Has2253 = a1.hasRFC2253Keyword();
        boolean a2Has2253 = a2.hasRFC2253Keyword();
        if (a1Has2253) {
            if (a2Has2253) {
                return a1.toRFC2253CanonicalString().compareTo(a2.toRFC2253CanonicalString());
            }
            return -1;
        }
        if (a2Has2253) {
            return 1;
        }
        int[] a1Oid = a1.getObjectIdentifier().toIntArray();
        int[] a2Oid = a2.getObjectIdentifier().toIntArray();
        int n = len = a1Oid.length > a2Oid.length ? a2Oid.length : a1Oid.length;
        for (pos = 0; pos < len && a1Oid[pos] == a2Oid[pos]; ++pos) {
        }
        return pos == len ? a1Oid.length - a2Oid.length : a1Oid[pos] - a2Oid[pos];
    }
}

