/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.Key;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.ECParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import sun.security.util.Length;

public final class KeyUtil {
    public static final int getKeySize(Key key) {
        Object pubk;
        int size = -1;
        if (key instanceof Length) {
            try {
                Length ruler = (Length)((Object)key);
                size = ruler.length();
            }
            catch (UnsupportedOperationException ruler) {
                // empty catch block
            }
            if (size >= 0) {
                return size;
            }
        }
        if (key instanceof SecretKey) {
            SecretKey sk = (SecretKey)key;
            String format = sk.getFormat();
            if ("RAW".equals(format) && sk.getEncoded() != null) {
                size = sk.getEncoded().length * 8;
            }
        } else if (key instanceof RSAKey) {
            pubk = (RSAKey)((Object)key);
            size = pubk.getModulus().bitLength();
        } else if (key instanceof ECKey) {
            pubk = (ECKey)((Object)key);
            ECParameterSpec params = pubk.getParams();
            if (params != null) {
                size = params.getOrder().bitLength();
            }
        } else if (key instanceof DSAKey) {
            pubk = (DSAKey)((Object)key);
            DSAParams params = pubk.getParams();
            size = params != null ? params.getP().bitLength() : -1;
        } else if (key instanceof DHKey) {
            pubk = (DHKey)((Object)key);
            size = pubk.getParams().getP().bitLength();
        }
        return size;
    }
}

