/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Debug {
    private String prefix;
    private static String args;
    private static final char[] hexDigits;

    public static Debug getInstance(String option) {
        return Debug.getInstance(option, option);
    }

    public static Debug getInstance(String option, String prefix) {
        if (Debug.isOn(option)) {
            Debug d = new Debug();
            d.prefix = prefix;
            return d;
        }
        return null;
    }

    public static boolean isOn(String option) {
        if (args == null) {
            return false;
        }
        if (args.indexOf("all") != -1) {
            return true;
        }
        return args.indexOf(option) != -1;
    }

    public void println(String message) {
        System.err.println(this.prefix + ": " + message);
    }

    public void println() {
        System.err.println(this.prefix + ":");
    }

    public static String toHexString(BigInteger b) {
        String hexValue = b.toString(16);
        StringBuffer buf = new StringBuffer(hexValue.length() * 2);
        if (hexValue.startsWith("-")) {
            buf.append("   -");
            hexValue = hexValue.substring(1);
        } else {
            buf.append("    ");
        }
        if (hexValue.length() % 2 != 0) {
            hexValue = "0" + hexValue;
        }
        int i = 0;
        while (i < hexValue.length()) {
            buf.append(hexValue.substring(i, i + 2));
            if ((i += 2) == hexValue.length()) continue;
            if (i % 64 == 0) {
                buf.append("\n    ");
                continue;
            }
            if (i % 8 != 0) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    private static String marshal(String args) {
        if (args != null) {
            String matched;
            StringBuffer target = new StringBuffer();
            StringBuffer source = new StringBuffer(args);
            String keyReg = "[Pp][Ee][Rr][Mm][Ii][Ss][Ss][Ii][Oo][Nn]=";
            String keyStr = "permission=";
            String reg = keyReg + "[a-zA-Z_$][a-zA-Z0-9_$]*([.][a-zA-Z_$][a-zA-Z0-9_$]*)*";
            Pattern pattern = Pattern.compile(reg);
            Matcher matcher = pattern.matcher(source);
            StringBuffer left = new StringBuffer();
            while (matcher.find()) {
                matched = matcher.group();
                target.append(matched.replaceFirst(keyReg, keyStr));
                target.append("  ");
                matcher.appendReplacement(left, "");
            }
            matcher.appendTail(left);
            source = left;
            keyReg = "[Cc][Oo][Dd][Ee][Bb][Aa][Ss][Ee]=";
            keyStr = "codebase=";
            reg = keyReg + "[^, ;]*";
            pattern = Pattern.compile(reg);
            matcher = pattern.matcher(source);
            left = new StringBuffer();
            while (matcher.find()) {
                matched = matcher.group();
                target.append(matched.replaceFirst(keyReg, keyStr));
                target.append("  ");
                matcher.appendReplacement(left, "");
            }
            matcher.appendTail(left);
            source = left;
            target.append(source.toString().toLowerCase(Locale.ENGLISH));
            return target.toString();
        }
        return null;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return "(null)";
        }
        StringBuilder sb = new StringBuilder(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            int k = b[i] & 0xFF;
            if (i != 0) {
                sb.append(':');
            }
            sb.append(hexDigits[k >>> 4]);
            sb.append(hexDigits[k & 0xF]);
        }
        return sb.toString();
    }

    static {
        hexDigits = "0123456789abcdef".toCharArray();
    }
}

