/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AdaptableX509CertSelector;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.PKIX;
import sun.security.provider.certpath.State;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ForwardBuilder
extends Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    private final Set<X509Certificate> trustedCerts;
    private final Set<X500Principal> trustedSubjectDNs;
    private final Set<TrustAnchor> trustAnchors;
    private X509CertSelector eeSelector;
    private AdaptableX509CertSelector caSelector;
    private X509CertSelector caTargetSelector;
    TrustAnchor trustAnchor;
    private boolean searchAllCertStores = true;

    ForwardBuilder(PKIX.BuilderParams buildParams, boolean searchAllCertStores) {
        super(buildParams);
        this.trustAnchors = buildParams.trustAnchors();
        this.trustedCerts = new HashSet<X509Certificate>(this.trustAnchors.size());
        this.trustedSubjectDNs = new HashSet<X500Principal>(this.trustAnchors.size());
        for (TrustAnchor anchor : this.trustAnchors) {
            X509Certificate trustedCert = anchor.getTrustedCert();
            if (trustedCert != null) {
                this.trustedCerts.add(trustedCert);
                this.trustedSubjectDNs.add(trustedCert.getSubjectX500Principal());
                continue;
            }
            this.trustedSubjectDNs.add(anchor.getCA());
        }
        this.searchAllCertStores = searchAllCertStores;
    }

    @Override
    Collection<X509Certificate> getMatchingCerts(State currentState, List<CertStore> certStores) throws CertStoreException, CertificateException, IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCerts()...");
        }
        ForwardState currState = (ForwardState)currentState;
        PKIXCertComparator comparator = new PKIXCertComparator(this.trustedSubjectDNs, currState.cert);
        TreeSet<X509Certificate> certs = new TreeSet<X509Certificate>(comparator);
        if (currState.isInitial()) {
            this.getMatchingEECerts(currState, certStores, certs);
        }
        this.getMatchingCACerts(currState, certStores, certs);
        return certs;
    }

    private void getMatchingEECerts(ForwardState currentState, List<CertStore> certStores, Collection<X509Certificate> eeCerts) throws IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingEECerts()...");
        }
        if (this.eeSelector == null) {
            this.eeSelector = (X509CertSelector)this.targetCertConstraints.clone();
            this.eeSelector.setCertificateValid(this.buildParams.date());
            if (this.buildParams.explicitPolicyRequired()) {
                this.eeSelector.setPolicy(this.getMatchingPolicies());
            }
            this.eeSelector.setBasicConstraints(-2);
        }
        this.addMatchingCerts(this.eeSelector, certStores, eeCerts, this.searchAllCertStores);
    }

    private void getMatchingCACerts(ForwardState currentState, List<CertStore> certStores, Collection<X509Certificate> caCerts) throws IOException {
        AuthorityInfoAccessExtension aiaExt;
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCACerts()...");
        }
        int initialSize = caCerts.size();
        X509CertSelector sel = null;
        if (currentState.isInitial()) {
            if (this.targetCertConstraints.getBasicConstraints() == -2) {
                return;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts(): the target is a CA");
            }
            if (this.caTargetSelector == null) {
                this.caTargetSelector = (X509CertSelector)this.targetCertConstraints.clone();
                if (this.buildParams.explicitPolicyRequired()) {
                    this.caTargetSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            sel = this.caTargetSelector;
        } else {
            if (this.caSelector == null) {
                this.caSelector = new AdaptableX509CertSelector();
                if (this.buildParams.explicitPolicyRequired()) {
                    this.caSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caSelector.setSubject(currentState.issuerDN);
            CertPathHelper.setPathToNames(this.caSelector, currentState.subjectNamesTraversed);
            this.caSelector.setValidityPeriod(currentState.cert.getNotBefore(), currentState.cert.getNotAfter());
            sel = this.caSelector;
        }
        sel.setBasicConstraints(-1);
        for (X509Certificate trustedCert : this.trustedCerts) {
            if (!sel.match(trustedCert)) continue;
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts: found matching trust anchor.\n  SN: " + Debug.toHexString(trustedCert.getSerialNumber()) + "\n  Subject: " + trustedCert.getSubjectX500Principal() + "\n  Issuer: " + trustedCert.getIssuerX500Principal());
            }
            if (!caCerts.add(trustedCert) || this.searchAllCertStores) continue;
            return;
        }
        sel.setCertificateValid(this.buildParams.date());
        sel.setBasicConstraints(currentState.traversedCACerts);
        if ((currentState.isInitial() || this.buildParams.maxPathLength() == -1 || this.buildParams.maxPathLength() > currentState.traversedCACerts) && this.addMatchingCerts(sel, certStores, caCerts, this.searchAllCertStores) && !this.searchAllCertStores) {
            return;
        }
        if (!currentState.isInitial() && Builder.USE_AIA && (aiaExt = currentState.cert.getAuthorityInfoAccessExtension()) != null) {
            this.getCerts(aiaExt, caCerts);
        }
        if (debug != null) {
            int numCerts = caCerts.size() - initialSize;
            debug.println("ForwardBuilder.getMatchingCACerts: found " + numCerts + " CA certs");
        }
    }

    private boolean getCerts(AuthorityInfoAccessExtension aiaExt, Collection<X509Certificate> certs) {
        if (!Builder.USE_AIA) {
            return false;
        }
        List<AccessDescription> adList = aiaExt.getAccessDescriptions();
        if (adList == null || adList.isEmpty()) {
            return false;
        }
        boolean add = false;
        for (AccessDescription ad : adList) {
            CertStore cs = URICertStore.getInstance(ad);
            if (cs == null) continue;
            try {
                if (!certs.addAll(cs.getCertificates(this.caSelector))) continue;
                add = true;
                if (this.searchAllCertStores) continue;
                return true;
            }
            catch (CertStoreException cse) {
                if (debug == null) continue;
                debug.println("exception getting certs from CertStore:");
                cse.printStackTrace();
            }
        }
        return add;
    }

    @Override
    void verifyCert(X509Certificate cert, State currentState, List<X509Certificate> certPathList) throws GeneralSecurityException {
        boolean isTrustedCert;
        if (debug != null) {
            debug.println("ForwardBuilder.verifyCert(SN: " + Debug.toHexString(cert.getSerialNumber()) + "\n  Issuer: " + cert.getIssuerX500Principal() + ")\n  Subject: " + cert.getSubjectX500Principal() + ")");
        }
        ForwardState currState = (ForwardState)currentState;
        if (certPathList != null) {
            for (X509Certificate cpListCert : certPathList) {
                if (!cert.equals(cpListCert)) continue;
                if (debug != null) {
                    debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        if (!(isTrustedCert = this.trustedCerts.contains(cert))) {
            Set<String> unresCritExts = cert.getCriticalExtensionOIDs();
            if (unresCritExts == null) {
                unresCritExts = Collections.emptySet();
            }
            for (PKIXCertPathChecker checker : currState.forwardCheckers) {
                checker.check(cert, unresCritExts);
            }
            for (PKIXCertPathChecker checker : this.buildParams.certPathCheckers()) {
                Set<String> supportedExts;
                if (checker.isForwardCheckingSupported() || (supportedExts = checker.getSupportedExtensions()) == null) continue;
                unresCritExts.removeAll(supportedExts);
            }
            if (!unresCritExts.isEmpty()) {
                unresCritExts.remove(PKIXExtensions.BasicConstraints_Id.toString());
                unresCritExts.remove(PKIXExtensions.NameConstraints_Id.toString());
                unresCritExts.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                unresCritExts.remove(PKIXExtensions.PolicyMappings_Id.toString());
                unresCritExts.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                unresCritExts.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                unresCritExts.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                unresCritExts.remove(PKIXExtensions.KeyUsage_Id.toString());
                unresCritExts.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                if (!unresCritExts.isEmpty()) {
                    throw new CertPathValidatorException("Unrecognized critical extension(s)", null, null, -1, PKIXReason.UNRECOGNIZED_CRIT_EXT);
                }
            }
        }
        if (currState.isInitial()) {
            return;
        }
        if (!isTrustedCert) {
            if (cert.getBasicConstraints() == -1) {
                throw new CertificateException("cert is NOT a CA cert");
            }
            KeyChecker.verifyCAKeyUsage(cert);
        }
        if (!currState.keyParamsNeeded()) {
            if (this.buildParams.sigProvider() != null) {
                currState.cert.verify(cert.getPublicKey(), this.buildParams.sigProvider());
            } else {
                currState.cert.verify(cert.getPublicKey());
            }
        }
    }

    @Override
    boolean isPathCompleted(X509Certificate cert) {
        PublicKey publicKey;
        X500Principal principal;
        ArrayList<TrustAnchor> otherAnchors = new ArrayList<TrustAnchor>();
        for (TrustAnchor anchor : this.trustAnchors) {
            if (anchor.getTrustedCert() != null) {
                if (!cert.equals(anchor.getTrustedCert())) continue;
                this.trustAnchor = anchor;
                return true;
            }
            principal = anchor.getCA();
            publicKey = anchor.getCAPublicKey();
            if (principal != null && publicKey != null && principal.equals(cert.getSubjectX500Principal()) && publicKey.equals(cert.getPublicKey())) {
                this.trustAnchor = anchor;
                return true;
            }
            otherAnchors.add(anchor);
        }
        for (TrustAnchor anchor : otherAnchors) {
            principal = anchor.getCA();
            publicKey = anchor.getCAPublicKey();
            if (principal == null || !principal.equals(cert.getIssuerX500Principal()) || PKIX.isDSAPublicKeyWithoutParams(publicKey)) continue;
            try {
                if (this.buildParams.sigProvider() != null) {
                    cert.verify(publicKey, this.buildParams.sigProvider());
                } else {
                    cert.verify(publicKey);
                }
            }
            catch (InvalidKeyException ike) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() invalid DSA key found");
                continue;
            }
            catch (GeneralSecurityException e) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() unexpected exception");
                e.printStackTrace();
                continue;
            }
            this.trustAnchor = anchor;
            return true;
        }
        return false;
    }

    @Override
    void addCertToPath(X509Certificate cert, LinkedList<X509Certificate> certPathList) {
        certPathList.addFirst(cert);
    }

    @Override
    void removeFinalCertFromPath(LinkedList<X509Certificate> certPathList) {
        certPathList.removeFirst();
    }

    static class PKIXCertComparator
    implements Comparator<X509Certificate> {
        static final String METHOD_NME = "PKIXCertComparator.compare()";
        private final Set<X500Principal> trustedSubjectDNs;
        private final X509CertSelector certSkidSelector;

        PKIXCertComparator(Set<X500Principal> trustedSubjectDNs, X509CertImpl previousCert) throws IOException {
            this.trustedSubjectDNs = trustedSubjectDNs;
            this.certSkidSelector = this.getSelector(previousCert);
        }

        private X509CertSelector getSelector(X509CertImpl previousCert) throws IOException {
            byte[] skid;
            AuthorityKeyIdentifierExtension akidExt;
            if (previousCert != null && (akidExt = previousCert.getAuthorityKeyIdentifierExtension()) != null && (skid = akidExt.getEncodedKeyIdentifier()) != null) {
                X509CertSelector selector = new X509CertSelector();
                selector.setSubjectKeyIdentifier(skid);
                return selector;
            }
            return null;
        }

        @Override
        public int compare(X509Certificate oCert1, X509Certificate oCert2) {
            int distanceTto2;
            int distanceTto1;
            X500Name tSubjectName;
            if (oCert1.equals(oCert2)) {
                return 0;
            }
            if (this.certSkidSelector != null) {
                if (this.certSkidSelector.match(oCert1)) {
                    return -1;
                }
                if (this.certSkidSelector.match(oCert2)) {
                    return 1;
                }
            }
            X500Principal cIssuer1 = oCert1.getIssuerX500Principal();
            X500Principal cIssuer2 = oCert2.getIssuerX500Principal();
            X500Name cIssuer1Name = X500Name.asX500Name(cIssuer1);
            X500Name cIssuer2Name = X500Name.asX500Name(cIssuer2);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() o1 Issuer:  " + cIssuer1);
                debug.println("PKIXCertComparator.compare() o2 Issuer:  " + cIssuer2);
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() MATCH TRUSTED SUBJECT TEST...");
            }
            boolean m1 = this.trustedSubjectDNs.contains(cIssuer1);
            boolean m2 = this.trustedSubjectDNs.contains(cIssuer2);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() m1: " + m1);
                debug.println("PKIXCertComparator.compare() m2: " + m2);
            }
            if (m1 && m2) {
                return -1;
            }
            if (m1) {
                return -1;
            }
            if (m2) {
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() NAMING DESCENDANT TEST...");
            }
            for (X500Principal tSubject : this.trustedSubjectDNs) {
                tSubjectName = X500Name.asX500Name(tSubject);
                distanceTto1 = Builder.distance(tSubjectName, cIssuer1Name, -1);
                distanceTto2 = Builder.distance(tSubjectName, cIssuer2Name, -1);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() distanceTto1: " + distanceTto1);
                    debug.println("PKIXCertComparator.compare() distanceTto2: " + distanceTto2);
                }
                if (distanceTto1 <= 0 && distanceTto2 <= 0) continue;
                if (distanceTto1 == distanceTto2) {
                    return -1;
                }
                if (distanceTto1 > 0 && distanceTto2 <= 0) {
                    return -1;
                }
                if (distanceTto1 <= 0 && distanceTto2 > 0) {
                    return 1;
                }
                if (distanceTto1 < distanceTto2) {
                    return -1;
                }
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() NAMING ANCESTOR TEST...");
            }
            for (X500Principal tSubject : this.trustedSubjectDNs) {
                tSubjectName = X500Name.asX500Name(tSubject);
                distanceTto1 = Builder.distance(tSubjectName, cIssuer1Name, Integer.MAX_VALUE);
                distanceTto2 = Builder.distance(tSubjectName, cIssuer2Name, Integer.MAX_VALUE);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() distanceTto1: " + distanceTto1);
                    debug.println("PKIXCertComparator.compare() distanceTto2: " + distanceTto2);
                }
                if (distanceTto1 >= 0 && distanceTto2 >= 0) continue;
                if (distanceTto1 == distanceTto2) {
                    return -1;
                }
                if (distanceTto1 < 0 && distanceTto2 >= 0) {
                    return -1;
                }
                if (distanceTto1 >= 0 && distanceTto2 < 0) {
                    return 1;
                }
                if (distanceTto1 > distanceTto2) {
                    return -1;
                }
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() SAME NAMESPACE AS TRUSTED TEST...");
            }
            for (X500Principal tSubject : this.trustedSubjectDNs) {
                tSubjectName = X500Name.asX500Name(tSubject);
                X500Name tAo1 = tSubjectName.commonAncestor(cIssuer1Name);
                X500Name tAo2 = tSubjectName.commonAncestor(cIssuer2Name);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() tAo1: " + String.valueOf(tAo1));
                    debug.println("PKIXCertComparator.compare() tAo2: " + String.valueOf(tAo2));
                }
                if (tAo1 == null && tAo2 == null) continue;
                if (tAo1 != null && tAo2 != null) {
                    int hopsTto1 = Builder.hops(tSubjectName, cIssuer1Name, Integer.MAX_VALUE);
                    int hopsTto2 = Builder.hops(tSubjectName, cIssuer2Name, Integer.MAX_VALUE);
                    if (debug != null) {
                        debug.println("PKIXCertComparator.compare() hopsTto1: " + hopsTto1);
                        debug.println("PKIXCertComparator.compare() hopsTto2: " + hopsTto2);
                    }
                    if (hopsTto1 == hopsTto2) continue;
                    if (hopsTto1 > hopsTto2) {
                        return 1;
                    }
                    return -1;
                }
                if (tAo1 == null) {
                    return 1;
                }
                return -1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() CERT ISSUER/SUBJECT COMPARISON TEST...");
            }
            X500Principal cSubject1 = oCert1.getSubjectX500Principal();
            X500Principal cSubject2 = oCert2.getSubjectX500Principal();
            X500Name cSubject1Name = X500Name.asX500Name(cSubject1);
            X500Name cSubject2Name = X500Name.asX500Name(cSubject2);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() o1 Subject: " + cSubject1);
                debug.println("PKIXCertComparator.compare() o2 Subject: " + cSubject2);
            }
            int distanceStoI1 = Builder.distance(cSubject1Name, cIssuer1Name, Integer.MAX_VALUE);
            int distanceStoI2 = Builder.distance(cSubject2Name, cIssuer2Name, Integer.MAX_VALUE);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() distanceStoI1: " + distanceStoI1);
                debug.println("PKIXCertComparator.compare() distanceStoI2: " + distanceStoI2);
            }
            if (distanceStoI2 > distanceStoI1) {
                return -1;
            }
            if (distanceStoI2 < distanceStoI1) {
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() no tests matched; RETURN 0");
            }
            return -1;
        }
    }
}

