/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import sun.security.util.Cache;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

public class X509Factory {
    private static final int ENC_MAX_LENGTH = 0x400000;
    private static final Cache<Object, X509CertImpl> certCache = Cache.newSoftMemoryCache(750);
    private static final Cache<Object, X509CRLImpl> crlCache = Cache.newSoftMemoryCache(750);

    public static synchronized X509CertImpl intern(X509Certificate c) throws CertificateException {
        if (c == null) {
            return null;
        }
        boolean isImpl = c instanceof X509CertImpl;
        byte[] encoding = isImpl ? ((X509CertImpl)c).getEncodedInternal() : c.getEncoded();
        X509CertImpl newC = X509Factory.getFromCache(certCache, encoding);
        if (newC != null) {
            return newC;
        }
        if (isImpl) {
            newC = (X509CertImpl)c;
        } else {
            newC = new X509CertImpl(encoding);
            encoding = newC.getEncodedInternal();
        }
        X509Factory.addToCache(certCache, encoding, newC);
        return newC;
    }

    public static synchronized X509CRLImpl intern(X509CRL c) throws CRLException {
        if (c == null) {
            return null;
        }
        boolean isImpl = c instanceof X509CRLImpl;
        byte[] encoding = isImpl ? ((X509CRLImpl)c).getEncodedInternal() : c.getEncoded();
        X509CRLImpl newC = X509Factory.getFromCache(crlCache, encoding);
        if (newC != null) {
            return newC;
        }
        if (isImpl) {
            newC = (X509CRLImpl)c;
        } else {
            newC = new X509CRLImpl(encoding);
            encoding = newC.getEncodedInternal();
        }
        X509Factory.addToCache(crlCache, encoding, newC);
        return newC;
    }

    private static synchronized <K, V> V getFromCache(Cache<K, V> cache, byte[] encoding) {
        Cache.EqualByteArray key = new Cache.EqualByteArray(encoding);
        return cache.get(key);
    }

    private static synchronized <V> void addToCache(Cache<Object, V> cache, byte[] encoding, V value) {
        if (encoding.length > 0x400000) {
            return;
        }
        Cache.EqualByteArray key = new Cache.EqualByteArray(encoding);
        cache.put(key, value);
    }
}

