/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class PKCS7 {
    private ObjectIdentifier contentType;
    private BigInteger version = null;
    private AlgorithmId[] digestAlgorithmIds = null;
    private ContentInfo contentInfo = null;
    private X509Certificate[] certificates = null;
    private X509CRL[] crls = null;
    private SignerInfo[] signerInfos = null;
    private boolean oldStyle = false;
    private Principal[] certIssuerNames;

    public PKCS7(InputStream in) throws ParsingException, IOException {
        DataInputStream dis = new DataInputStream(in);
        byte[] data = new byte[dis.available()];
        dis.readFully(data);
        this.parse(new DerInputStream(data));
    }

    public PKCS7(DerInputStream derin) throws ParsingException {
        this.parse(derin);
    }

    public PKCS7(byte[] bytes) throws ParsingException {
        try {
            DerInputStream derin = new DerInputStream(bytes);
            this.parse(derin);
        }
        catch (IOException ioe1) {
            ParsingException pe = new ParsingException("Unable to parse the encoded bytes");
            pe.initCause(ioe1);
            throw pe;
        }
    }

    private void parse(DerInputStream derin) throws ParsingException {
        try {
            derin.mark(derin.available());
            this.parse(derin, false);
        }
        catch (IOException ioe) {
            try {
                derin.reset();
                this.parse(derin, true);
                this.oldStyle = true;
            }
            catch (IOException ioe1) {
                ParsingException pe = new ParsingException(ioe1.getMessage());
                pe.initCause(ioe);
                pe.addSuppressed(ioe1);
                throw pe;
            }
        }
    }

    private void parse(DerInputStream derin, boolean oldStyle) throws IOException {
        this.contentInfo = new ContentInfo(derin, oldStyle);
        this.contentType = this.contentInfo.contentType;
        DerValue content = this.contentInfo.getContent();
        if (this.contentType.equals((Object)ContentInfo.SIGNED_DATA_OID)) {
            this.parseSignedData(content);
        } else if (this.contentType.equals((Object)ContentInfo.OLD_SIGNED_DATA_OID)) {
            this.parseOldSignedData(content);
        } else if (this.contentType.equals((Object)ContentInfo.NETSCAPE_CERT_SEQUENCE_OID)) {
            this.parseNetscapeCertChain(content);
        } else {
            throw new ParsingException("content type " + this.contentType + " not supported.");
        }
    }

    public PKCS7(AlgorithmId[] digestAlgorithmIds, ContentInfo contentInfo, X509Certificate[] certificates, X509CRL[] crls, SignerInfo[] signerInfos) {
        this.version = BigInteger.ONE;
        this.digestAlgorithmIds = digestAlgorithmIds;
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.crls = crls;
        this.signerInfos = signerInfos;
    }

    public PKCS7(AlgorithmId[] digestAlgorithmIds, ContentInfo contentInfo, X509Certificate[] certificates, SignerInfo[] signerInfos) {
        this(digestAlgorithmIds, contentInfo, certificates, null, signerInfos);
    }

    private void parseNetscapeCertChain(DerValue val) throws ParsingException, IOException {
        DerInputStream dis = new DerInputStream(val.toByteArray());
        DerValue[] contents = dis.getSequence(2, true);
        this.certificates = new X509Certificate[contents.length];
        CertificateFactory certfac = null;
        try {
            certfac = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        for (int i = 0; i < contents.length; ++i) {
            try (ByteArrayInputStream bais = null;){
                byte[] original = contents[i].getOriginalEncodedForm();
                if (certfac == null) {
                    this.certificates[i] = new X509CertImpl(contents[i], original);
                    continue;
                }
                bais = new ByteArrayInputStream(original);
                this.certificates[i] = new VerbatimX509Certificate((X509Certificate)certfac.generateCertificate(bais), original);
                bais.close();
                bais = null;
                continue;
            }
        }
    }

    private void parseSignedData(DerValue val) throws ParsingException, IOException {
        int i;
        DerInputStream dis = val.toDerInputStream();
        this.version = dis.getBigInteger();
        DerValue[] digestAlgorithmIdVals = dis.getSet(1);
        int len = digestAlgorithmIdVals.length;
        this.digestAlgorithmIds = new AlgorithmId[len];
        try {
            for (int i2 = 0; i2 < len; ++i2) {
                DerValue oid = digestAlgorithmIdVals[i2];
                this.digestAlgorithmIds[i2] = AlgorithmId.parse(oid);
            }
        }
        catch (IOException e) {
            ParsingException pe = new ParsingException("Error parsing digest AlgorithmId IDs: " + e.getMessage());
            pe.initCause(e);
            throw pe;
        }
        this.contentInfo = new ContentInfo(dis);
        CertificateFactory certfac = null;
        try {
            certfac = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException pe) {
            // empty catch block
        }
        if ((byte)dis.peekByte() == -96) {
            DerValue[] certVals = dis.getSet(2, true, true);
            len = certVals.length;
            this.certificates = new X509Certificate[len];
            int count = 0;
            for (int i3 = 0; i3 < len; ++i3) {
                ParsingException pe;
                try (ByteArrayInputStream bais = null;){
                    byte tag = certVals[i3].getTag();
                    if (tag != 48) continue;
                    byte[] original = certVals[i3].getOriginalEncodedForm();
                    if (certfac == null) {
                        this.certificates[count] = new X509CertImpl(certVals[i3], original);
                    } else {
                        bais = new ByteArrayInputStream(original);
                        this.certificates[count] = new VerbatimX509Certificate((X509Certificate)certfac.generateCertificate(bais), original);
                        bais.close();
                        bais = null;
                    }
                    ++count;
                    continue;
                }
            }
            if (count != len) {
                this.certificates = Arrays.copyOf(this.certificates, count);
            }
        }
        if ((byte)dis.peekByte() == -95) {
            DerValue[] crlVals = dis.getSet(1, true);
            len = crlVals.length;
            this.crls = new X509CRL[len];
            for (i = 0; i < len; ++i) {
                try (ByteArrayInputStream bais = null;){
                    if (certfac == null) {
                        this.crls[i] = new X509CRLImpl(crlVals[i]);
                        continue;
                    }
                    byte[] encoded = crlVals[i].toByteArray();
                    bais = new ByteArrayInputStream(encoded);
                    this.crls[i] = (X509CRL)certfac.generateCRL(bais);
                    bais.close();
                    bais = null;
                    continue;
                }
            }
        }
        DerValue[] signerInfoVals = dis.getSet(1);
        len = signerInfoVals.length;
        this.signerInfos = new SignerInfo[len];
        for (i = 0; i < len; ++i) {
            DerInputStream in = signerInfoVals[i].toDerInputStream();
            this.signerInfos[i] = new SignerInfo(in);
        }
    }

    private void parseOldSignedData(DerValue val) throws ParsingException, IOException {
        DerInputStream dis = val.toDerInputStream();
        this.version = dis.getBigInteger();
        DerValue[] digestAlgorithmIdVals = dis.getSet(1);
        int len = digestAlgorithmIdVals.length;
        this.digestAlgorithmIds = new AlgorithmId[len];
        try {
            for (int i = 0; i < len; ++i) {
                DerValue oid = digestAlgorithmIdVals[i];
                this.digestAlgorithmIds[i] = AlgorithmId.parse(oid);
            }
        }
        catch (IOException e) {
            throw new ParsingException("Error parsing digest AlgorithmId IDs");
        }
        this.contentInfo = new ContentInfo(dis, true);
        CertificateFactory certfac = null;
        try {
            certfac = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException oid) {
            // empty catch block
        }
        DerValue[] certVals = dis.getSet(2, false, true);
        len = certVals.length;
        this.certificates = new X509Certificate[len];
        for (int i = 0; i < len; ++i) {
            try (ByteArrayInputStream bais = null;){
                byte[] original = certVals[i].getOriginalEncodedForm();
                if (certfac == null) {
                    this.certificates[i] = new X509CertImpl(certVals[i], original);
                    continue;
                }
                bais = new ByteArrayInputStream(original);
                this.certificates[i] = new VerbatimX509Certificate((X509Certificate)certfac.generateCertificate(bais), original);
                bais.close();
                bais = null;
                continue;
            }
        }
        dis.getSet(0);
        DerValue[] signerInfoVals = dis.getSet(1);
        len = signerInfoVals.length;
        this.signerInfos = new SignerInfo[len];
        for (int i = 0; i < len; ++i) {
            DerInputStream in = signerInfoVals[i].toDerInputStream();
            this.signerInfos[i] = new SignerInfo(in, true);
        }
    }

    public void encodeSignedData(OutputStream out) throws IOException {
        DerOutputStream derout = new DerOutputStream();
        this.encodeSignedData(derout);
        out.write(derout.toByteArray());
    }

    public void encodeSignedData(DerOutputStream out) throws IOException {
        DerOutputStream signedData = new DerOutputStream();
        signedData.putInteger(this.version);
        signedData.putOrderedSetOf((byte)49, this.digestAlgorithmIds);
        this.contentInfo.encode(signedData);
        if (this.certificates != null && this.certificates.length != 0) {
            DerEncoder[] implCerts = new X509CertImpl[this.certificates.length];
            for (int i = 0; i < this.certificates.length; ++i) {
                if (this.certificates[i] instanceof X509CertImpl) {
                    implCerts[i] = (X509CertImpl)this.certificates[i];
                    continue;
                }
                try {
                    byte[] encoded = this.certificates[i].getEncoded();
                    implCerts[i] = new X509CertImpl(encoded);
                    continue;
                }
                catch (CertificateException ce) {
                    throw new IOException(ce);
                }
            }
            signedData.putOrderedSetOf((byte)-96, implCerts);
        }
        if (this.crls != null && this.crls.length != 0) {
            HashSet<X509CRLImpl> implCRLs = new HashSet<X509CRLImpl>(this.crls.length);
            for (X509CRL crl : this.crls) {
                if (crl instanceof X509CRLImpl) {
                    implCRLs.add((X509CRLImpl)crl);
                    continue;
                }
                try {
                    byte[] encoded = crl.getEncoded();
                    implCRLs.add(new X509CRLImpl(encoded));
                }
                catch (CRLException ce) {
                    throw new IOException(ce);
                }
            }
            signedData.putOrderedSetOf((byte)-95, implCRLs.toArray(new X509CRLImpl[implCRLs.size()]));
        }
        signedData.putOrderedSetOf((byte)49, this.signerInfos);
        DerValue signedDataSeq = new DerValue(48, signedData.toByteArray());
        ContentInfo block = new ContentInfo(ContentInfo.SIGNED_DATA_OID, signedDataSeq);
        block.encode(out);
    }

    public SignerInfo verify(SignerInfo info, byte[] bytes) throws NoSuchAlgorithmException, SignatureException {
        return info.verify(this, bytes);
    }

    public SignerInfo verify(SignerInfo info, InputStream dataInputStream) throws NoSuchAlgorithmException, SignatureException, IOException {
        return info.verify(this, dataInputStream);
    }

    public SignerInfo[] verify(byte[] bytes) throws NoSuchAlgorithmException, SignatureException {
        Vector<SignerInfo> intResult = new Vector<SignerInfo>();
        for (int i = 0; i < this.signerInfos.length; ++i) {
            SignerInfo signerInfo = this.verify(this.signerInfos[i], bytes);
            if (signerInfo == null) continue;
            intResult.addElement(signerInfo);
        }
        if (!intResult.isEmpty()) {
            Object[] result = new SignerInfo[intResult.size()];
            intResult.copyInto(result);
            return result;
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Certificate[] getCertificates() {
        if (this.certificates != null) {
            return (X509Certificate[])this.certificates.clone();
        }
        return null;
    }

    public X509CRL[] getCRLs() {
        if (this.crls != null) {
            return (X509CRL[])this.crls.clone();
        }
        return null;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Certificate getCertificate(BigInteger serial, X500Name issuerName) {
        if (this.certificates != null) {
            if (this.certIssuerNames == null) {
                this.populateCertIssuerNames();
            }
            for (int i = 0; i < this.certificates.length; ++i) {
                X509Certificate cert = this.certificates[i];
                BigInteger thisSerial = cert.getSerialNumber();
                if (!serial.equals(thisSerial) || !issuerName.equals(this.certIssuerNames[i])) continue;
                return cert;
            }
        }
        return null;
    }

    private void populateCertIssuerNames() {
        if (this.certificates == null) {
            return;
        }
        this.certIssuerNames = new Principal[this.certificates.length];
        for (int i = 0; i < this.certificates.length; ++i) {
            X509Certificate cert = this.certificates[i];
            Principal certIssuerName = cert.getIssuerDN();
            if (!(certIssuerName instanceof X500Name)) {
                try {
                    X509CertInfo tbsCert = new X509CertInfo(cert.getTBSCertificate());
                    certIssuerName = (Principal)tbsCert.get("issuer.dname");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.certIssuerNames[i] = certIssuerName;
        }
    }

    public String toString() {
        int i;
        String out = "";
        out = out + this.contentInfo + "\n";
        if (this.version != null) {
            out = out + "PKCS7 :: version: " + Debug.toHexString(this.version) + "\n";
        }
        if (this.digestAlgorithmIds != null) {
            out = out + "PKCS7 :: digest AlgorithmIds: \n";
            for (i = 0; i < this.digestAlgorithmIds.length; ++i) {
                out = out + "\t" + this.digestAlgorithmIds[i] + "\n";
            }
        }
        if (this.certificates != null) {
            out = out + "PKCS7 :: certificates: \n";
            for (i = 0; i < this.certificates.length; ++i) {
                out = out + "\t" + i + ".   " + this.certificates[i] + "\n";
            }
        }
        if (this.crls != null) {
            out = out + "PKCS7 :: crls: \n";
            for (i = 0; i < this.crls.length; ++i) {
                out = out + "\t" + i + ".   " + this.crls[i] + "\n";
            }
        }
        if (this.signerInfos != null) {
            out = out + "PKCS7 :: signer infos: \n";
            for (i = 0; i < this.signerInfos.length; ++i) {
                out = out + "\t" + i + ".  " + this.signerInfos[i] + "\n";
            }
        }
        return out;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }

    private static class WrappedX509Certificate
    extends X509Certificate {
        private final X509Certificate wrapped;

        public WrappedX509Certificate(X509Certificate wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return this.wrapped.getCriticalExtensionOIDs();
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return this.wrapped.getExtensionValue(oid);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return this.wrapped.getNonCriticalExtensionOIDs();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return this.wrapped.hasUnsupportedCriticalExtension();
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            this.wrapped.checkValidity();
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            this.wrapped.checkValidity(date);
        }

        @Override
        public int getVersion() {
            return this.wrapped.getVersion();
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.wrapped.getSerialNumber();
        }

        @Override
        public Principal getIssuerDN() {
            return this.wrapped.getIssuerDN();
        }

        @Override
        public Principal getSubjectDN() {
            return this.wrapped.getSubjectDN();
        }

        @Override
        public Date getNotBefore() {
            return this.wrapped.getNotBefore();
        }

        @Override
        public Date getNotAfter() {
            return this.wrapped.getNotAfter();
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return this.wrapped.getTBSCertificate();
        }

        @Override
        public byte[] getSignature() {
            return this.wrapped.getSignature();
        }

        @Override
        public String getSigAlgName() {
            return this.wrapped.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return this.wrapped.getSigAlgOID();
        }

        @Override
        public byte[] getSigAlgParams() {
            return this.wrapped.getSigAlgParams();
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return this.wrapped.getIssuerUniqueID();
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return this.wrapped.getSubjectUniqueID();
        }

        @Override
        public boolean[] getKeyUsage() {
            return this.wrapped.getKeyUsage();
        }

        @Override
        public int getBasicConstraints() {
            return this.wrapped.getBasicConstraints();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return this.wrapped.getEncoded();
        }

        @Override
        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            this.wrapped.verify(key);
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            this.wrapped.verify(key, sigProvider);
        }

        @Override
        public String toString() {
            return this.wrapped.toString();
        }

        @Override
        public PublicKey getPublicKey() {
            return this.wrapped.getPublicKey();
        }

        @Override
        public List<String> getExtendedKeyUsage() throws CertificateParsingException {
            return this.wrapped.getExtendedKeyUsage();
        }

        @Override
        public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
            return this.wrapped.getIssuerAlternativeNames();
        }

        @Override
        public X500Principal getIssuerX500Principal() {
            return this.wrapped.getIssuerX500Principal();
        }

        @Override
        public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
            return this.wrapped.getSubjectAlternativeNames();
        }

        @Override
        public X500Principal getSubjectX500Principal() {
            return this.wrapped.getSubjectX500Principal();
        }

        @Override
        public void verify(PublicKey key, Provider sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
            this.wrapped.verify(key, sigProvider);
        }
    }

    private static class VerbatimX509Certificate
    extends WrappedX509Certificate {
        private byte[] encodedVerbatim;

        public VerbatimX509Certificate(X509Certificate wrapped, byte[] encodedVerbatim) {
            super(wrapped);
            this.encodedVerbatim = encodedVerbatim;
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return this.encodedVerbatim;
        }
    }
}

