/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.Provider;
import sun.security.jca.ProviderList;

public class Providers {
    private static final ThreadLocal<ProviderList> threadLists = new InheritableThreadLocal<ProviderList>();
    private static volatile int threadListsUsed;
    private static volatile ProviderList providerList;
    private static final String BACKUP_PROVIDER_CLASSNAME = "sun.security.provider.VerificationProvider";
    private static final String[] jarVerificationProviders;

    private Providers() {
    }

    public static Provider getSunProvider() {
        try {
            Class<?> clazz = Class.forName(jarVerificationProviders[0]);
            return (Provider)clazz.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> clazz = Class.forName(BACKUP_PROVIDER_CLASSNAME);
                return (Provider)clazz.newInstance();
            }
            catch (Exception ee) {
                throw new RuntimeException("Sun provider not found", e);
            }
        }
    }

    public static Object startJarVerification() {
        ProviderList currentList = Providers.getProviderList();
        ProviderList jarList = currentList.getJarList(jarVerificationProviders);
        return Providers.beginThreadProviderList(jarList);
    }

    public static void stopJarVerification(Object obj) {
        Providers.endThreadProviderList((ProviderList)obj);
    }

    public static ProviderList getProviderList() {
        ProviderList list = Providers.getThreadProviderList();
        if (list == null) {
            list = Providers.getSystemProviderList();
        }
        return list;
    }

    public static void setProviderList(ProviderList newList) {
        if (Providers.getThreadProviderList() == null) {
            Providers.setSystemProviderList(newList);
        } else {
            Providers.changeThreadProviderList(newList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProviderList getFullProviderList() {
        Class<Providers> clazz = Providers.class;
        synchronized (Providers.class) {
            ProviderList list = Providers.getThreadProviderList();
            if (list != null) {
                ProviderList newList = list.removeInvalid();
                if (newList != list) {
                    Providers.changeThreadProviderList(newList);
                    list = newList;
                }
                // ** MonitorExit[var1] (shouldn't be in output)
                return list;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            list = Providers.getSystemProviderList();
            ProviderList newList = list.removeInvalid();
            if (newList != list) {
                Providers.setSystemProviderList(newList);
                list = newList;
            }
            return list;
        }
    }

    private static ProviderList getSystemProviderList() {
        return providerList;
    }

    private static void setSystemProviderList(ProviderList list) {
        providerList = list;
    }

    public static ProviderList getThreadProviderList() {
        if (threadListsUsed == 0) {
            return null;
        }
        return threadLists.get();
    }

    private static void changeThreadProviderList(ProviderList list) {
        threadLists.set(list);
    }

    public static synchronized ProviderList beginThreadProviderList(ProviderList list) {
        if (ProviderList.debug != null) {
            ProviderList.debug.println("ThreadLocal providers: " + list);
        }
        ProviderList oldList = threadLists.get();
        ++threadListsUsed;
        threadLists.set(list);
        return oldList;
    }

    public static synchronized void endThreadProviderList(ProviderList list) {
        if (list == null) {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Disabling ThreadLocal providers");
            }
            threadLists.remove();
        } else {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Restoring previous ThreadLocal providers: " + list);
            }
            threadLists.set(list);
        }
        --threadListsUsed;
    }

    static {
        providerList = ProviderList.EMPTY;
        providerList = ProviderList.fromSecurityProperties();
        int numConfiguredProviders = (providerList = providerList.removeInvalid()).size();
        if (numConfiguredProviders != providerList.size()) {
            throw new AssertionError((Object)"Unable to configure default providers");
        }
        jarVerificationProviders = new String[]{"com.android.org.bouncycastle.jce.provider.BouncyCastleProvider", "org.apache.harmony.security.provider.crypto.CryptoProvider", "com.wolfssl.provider.jsse.WolfSSLProvider", BACKUP_PROVIDER_CLASSNAME};
    }
}

