/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import dalvik.system.CloseGuard;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class UnixDirectoryStream
implements DirectoryStream<Path> {
    private final UnixPath dir;
    private final long dp;
    private final DirectoryStream.Filter<? super Path> filter;
    private final ReentrantReadWriteLock streamLock = new ReentrantReadWriteLock(true);
    private volatile boolean isClosed;
    private Iterator<Path> iterator;
    private final CloseGuard guard = CloseGuard.get();

    UnixDirectoryStream(UnixPath dir, long dp, DirectoryStream.Filter<? super Path> filter) {
        this.dir = dir;
        this.dp = dp;
        this.filter = filter;
        this.guard.open("close");
    }

    protected final UnixPath directory() {
        return this.dir;
    }

    protected final Lock readLock() {
        return this.streamLock.readLock();
    }

    protected final Lock writeLock() {
        return this.streamLock.writeLock();
    }

    protected final boolean isOpen() {
        return !this.isClosed;
    }

    protected final boolean closeImpl() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            try {
                UnixNativeDispatcher.closedir(this.dp);
            }
            catch (UnixException x) {
                throw new IOException(x.errorString());
            }
            this.guard.close();
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.writeLock().lock();
        try {
            this.closeImpl();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Iterator<Path> iterator(DirectoryStream<Path> ds) {
        if (this.isClosed) {
            throw new IllegalStateException("Directory stream is closed");
        }
        UnixDirectoryStream unixDirectoryStream = this;
        synchronized (unixDirectoryStream) {
            if (this.iterator != null) {
                throw new IllegalStateException("Iterator already obtained");
            }
            this.iterator = new UnixDirectoryIterator(ds);
            return this.iterator;
        }
    }

    @Override
    public Iterator<Path> iterator() {
        return this.iterator(this);
    }

    protected void finalize() throws IOException {
        if (this.guard != null) {
            this.guard.warnIfOpen();
        }
        this.close();
    }

    private class UnixDirectoryIterator
    implements Iterator<Path> {
        private final DirectoryStream<Path> stream;
        private boolean atEof = false;
        private Path nextEntry;

        UnixDirectoryIterator(DirectoryStream<Path> stream) {
            this.stream = stream;
        }

        private boolean isSelfOrParent(byte[] nameAsBytes) {
            return nameAsBytes[0] == 46 && (nameAsBytes.length == 1 || nameAsBytes.length == 2 && nameAsBytes[1] == 46);
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Path readNextEntry() {
            assert (Thread.holdsLock(this));
            while (true) {
                byte[] nameAsBytes = null;
                UnixDirectoryStream.this.readLock().lock();
                try {
                    if (UnixDirectoryStream.this.isOpen()) {
                        nameAsBytes = UnixNativeDispatcher.readdir(UnixDirectoryStream.this.dp);
                    }
                }
                catch (UnixException x) {
                    IOException ioe = x.asIOException(UnixDirectoryStream.this.dir);
                    throw new DirectoryIteratorException(ioe);
                }
                finally {
                    UnixDirectoryStream.this.readLock().unlock();
                }
                if (nameAsBytes == null) {
                    this.atEof = true;
                    return null;
                }
                if (this.isSelfOrParent(nameAsBytes)) continue;
                UnixPath entry = UnixDirectoryStream.this.dir.resolve(nameAsBytes);
                if (UnixDirectoryStream.this.filter == null || UnixDirectoryStream.this.filter.accept(entry)) return entry;
                continue;
                break;
            }
            catch (IOException ioe) {
                throw new DirectoryIteratorException(ioe);
            }
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.nextEntry == null && !this.atEof) {
                this.nextEntry = this.readNextEntry();
            }
            return this.nextEntry != null;
        }

        @Override
        public synchronized Path next() {
            Path result;
            if (this.nextEntry == null && !this.atEof) {
                result = this.readNextEntry();
            } else {
                result = this.nextEntry;
                this.nextEntry = null;
            }
            if (result == null) {
                throw new NoSuchElementException();
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

