/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.Path;
import libcore.net.MimeUtils;
import sun.nio.fs.AbstractFileTypeDetector;

class MimeTypesFileTypeDetector
extends AbstractFileTypeDetector {
    MimeTypesFileTypeDetector() {
    }

    @Override
    protected String implProbeContentType(Path path) {
        String mimeType;
        Path fn = path.getFileName();
        if (fn == null) {
            return null;
        }
        String ext = MimeTypesFileTypeDetector.getExtension(fn.toString());
        if (ext.isEmpty()) {
            return null;
        }
        do {
            if ((mimeType = MimeUtils.guessMimeTypeFromExtension(ext)) != null) continue;
            ext = MimeTypesFileTypeDetector.getExtension(ext);
        } while (mimeType == null && !ext.isEmpty());
        return mimeType;
    }

    private static String getExtension(String name) {
        int dot;
        String ext = "";
        if (name != null && !name.isEmpty() && (dot = name.indexOf(46)) >= 0 && dot < name.length() - 1) {
            ext = name.substring(dot + 1);
        }
        return ext;
    }
}

