/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;
import sun.nio.fs.AbstractUserDefinedFileAttributeView;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixConstants;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

class LinuxUserDefinedFileAttributeView
extends AbstractUserDefinedFileAttributeView {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final String USER_NAMESPACE = "user.";
    private static final int XATTR_NAME_MAX = 255;
    private final UnixPath file;
    private final boolean followLinks;

    private byte[] nameAsBytes(UnixPath file, String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("'name' is null");
        }
        name = USER_NAMESPACE + name;
        byte[] bytes = Util.toBytes(name);
        if (bytes.length > 255) {
            throw new FileSystemException(file.getPathForExceptionMessage(), null, "'" + name + "' is too big");
        }
        return bytes;
    }

    private List<String> asList(long address, int size) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        for (int pos = 0; pos < size; ++pos) {
            if (unsafe.getByte(address + (long)pos) != 0) continue;
            int len = pos - start;
            byte[] value = new byte[len];
            for (int i = 0; i < len; ++i) {
                value[i] = unsafe.getByte(address + (long)start + (long)i);
            }
            String s = Util.toString(value);
            if (s.startsWith(USER_NAMESPACE)) {
                s = s.substring(USER_NAMESPACE.length());
                list.add(s);
            }
            start = pos + 1;
        }
        return list;
    }

    LinuxUserDefinedFileAttributeView(UnixPath file, boolean followLinks) {
        this.file = file;
        this.followLinks = followLinks;
    }

    @Override
    public List<String> list() throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int fd = this.file.openForAttributeAccess(this.followLinks);
        NativeBuffer buffer = null;
        try {
            int size = 1024;
            buffer = NativeBuffers.getNativeBuffer(size);
            while (true) {
                try {
                    int n = LinuxNativeDispatcher.flistxattr(fd, buffer.address(), size);
                    List<String> list = this.asList(buffer.address(), n);
                    List<String> list2 = Collections.unmodifiableList(list);
                    return list2;
                }
                catch (UnixException x) {
                    if (x.errno() == UnixConstants.ERANGE && size < 32768) {
                        buffer.release();
                        buffer = null;
                        buffer = NativeBuffers.getNativeBuffer(size *= 2);
                        continue;
                    }
                    throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get list of extended attributes: " + x.getMessage());
                }
                break;
            }
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
            LinuxNativeDispatcher.close(fd);
        }
    }

    @Override
    public int size(String name) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int fd = this.file.openForAttributeAccess(this.followLinks);
        try {
            int n = LinuxNativeDispatcher.fgetxattr(fd, this.nameAsBytes(this.file, name), 0L, 0);
            return n;
        }
        catch (UnixException x) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get size of extended attribute '" + name + "': " + x.getMessage());
        }
        finally {
            LinuxNativeDispatcher.close(fd);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int read(String name, ByteBuffer dst) throws IOException {
        long address;
        NativeBuffer nb;
        int rem;
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        int pos = dst.position();
        int lim = dst.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (dst instanceof DirectBuffer) {
            nb = null;
            address = ((DirectBuffer)((Object)dst)).address() + (long)pos;
        } else {
            nb = NativeBuffers.getNativeBuffer(rem);
            address = nb.address();
        }
        int fd = this.file.openForAttributeAccess(this.followLinks);
        try {
            int i;
            try {
                int n2 = LinuxNativeDispatcher.fgetxattr(fd, this.nameAsBytes(this.file, name), address, rem);
                if (rem == 0) {
                    if (n2 > 0) {
                        throw new UnixException(UnixConstants.ERANGE);
                    }
                    int n3 = 0;
                    return n3;
                }
                if (nb != null) {
                    for (i = 0; i < n2; ++i) {
                        dst.put(unsafe.getByte(address + (long)i));
                    }
                }
                dst.position(pos + n2);
                i = n2;
            }
            catch (UnixException x) {
                String msg = x.errno() == UnixConstants.ERANGE ? "Insufficient space in buffer" : x.getMessage();
                throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Error reading extended attribute '" + name + "': " + msg);
            }
            finally {
                LinuxNativeDispatcher.close(fd);
            }
            return i;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (nb != null) {
                nb.release();
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int write(String name, ByteBuffer src) throws IOException {
        int i;
        long address;
        NativeBuffer nb;
        int rem;
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (src instanceof DirectBuffer) {
            nb = null;
            address = ((DirectBuffer)((Object)src)).address() + (long)pos;
        } else {
            nb = NativeBuffers.getNativeBuffer(rem);
            address = nb.address();
            if (src.hasArray()) {
                for (int i2 = 0; i2 < rem; ++i2) {
                    unsafe.putByte(address + (long)i2, src.get());
                }
            } else {
                byte[] tmp = new byte[rem];
                src.get(tmp);
                src.position(pos);
                for (i = 0; i < rem; ++i) {
                    unsafe.putByte(address + (long)i, tmp[i]);
                }
            }
        }
        int fd = this.file.openForAttributeAccess(this.followLinks);
        try {
            try {
                LinuxNativeDispatcher.fsetxattr(fd, this.nameAsBytes(this.file, name), address, rem);
                src.position(pos + rem);
                i = rem;
                return i;
            }
            catch (UnixException x) {
                throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Error writing extended attribute '" + name + "': " + x.getMessage());
            }
            finally {
                LinuxNativeDispatcher.close(fd);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (nb != null) {
                nb.release();
            }
        }
    }

    @Override
    public void delete(String name) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        int fd = this.file.openForAttributeAccess(this.followLinks);
        try {
            LinuxNativeDispatcher.fremovexattr(fd, this.nameAsBytes(this.file, name));
        }
        catch (UnixException x) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to delete extended attribute '" + name + "': " + x.getMessage());
        }
        finally {
            LinuxNativeDispatcher.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyExtendedAttributes(int ofd, int nfd) {
        NativeBuffer buffer = null;
        try {
            int size = 1024;
            buffer = NativeBuffers.getNativeBuffer(size);
            while (true) {
                try {
                    size = LinuxNativeDispatcher.flistxattr(ofd, buffer.address(), size);
                }
                catch (UnixException x) {
                    if (x.errno() == UnixConstants.ERANGE && size < 32768) {
                        buffer.release();
                        buffer = null;
                        buffer = NativeBuffers.getNativeBuffer(size *= 2);
                        continue;
                    }
                    if (buffer != null) {
                        buffer.release();
                    }
                    return;
                }
                break;
            }
            long address = buffer.address();
            int start = 0;
            for (int pos = 0; pos < size; ++pos) {
                if (unsafe.getByte(address + (long)pos) != 0) continue;
                int len = pos - start;
                byte[] name = new byte[len];
                for (int i = 0; i < len; ++i) {
                    name[i] = unsafe.getByte(address + (long)start + (long)i);
                }
                try {
                    LinuxUserDefinedFileAttributeView.copyExtendedAttribute(ofd, name, nfd);
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
                start = pos + 1;
            }
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyExtendedAttribute(int ofd, byte[] name, int nfd) throws UnixException {
        int size = LinuxNativeDispatcher.fgetxattr(ofd, name, 0L, 0);
        NativeBuffer buffer = NativeBuffers.getNativeBuffer(size);
        try {
            long address = buffer.address();
            size = LinuxNativeDispatcher.fgetxattr(ofd, name, address, size);
            LinuxNativeDispatcher.fsetxattr(nfd, name, address, size);
        }
        finally {
            buffer.release();
        }
    }
}

