/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractBasicFileAttributeView;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixConstants;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributeViews;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

class LinuxDosFileAttributeView
extends UnixFileAttributeViews.Basic
implements DosFileAttributeView {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final String READONLY_NAME = "readonly";
    private static final String ARCHIVE_NAME = "archive";
    private static final String SYSTEM_NAME = "system";
    private static final String HIDDEN_NAME = "hidden";
    private static final String DOS_XATTR_NAME = "user.DOSATTRIB";
    private static final byte[] DOS_XATTR_NAME_AS_BYTES = Util.toBytes("user.DOSATTRIB");
    private static final int DOS_XATTR_READONLY = 1;
    private static final int DOS_XATTR_HIDDEN = 2;
    private static final int DOS_XATTR_SYSTEM = 4;
    private static final int DOS_XATTR_ARCHIVE = 32;
    private static final Set<String> dosAttributeNames = Util.newSet(basicAttributeNames, new String[]{"readonly", "archive", "system", "hidden"});

    LinuxDosFileAttributeView(UnixPath file, boolean followLinks) {
        super(file, followLinks);
    }

    @Override
    public String name() {
        return "dos";
    }

    @Override
    public void setAttribute(String attribute, Object value) throws IOException {
        if (attribute.equals(READONLY_NAME)) {
            this.setReadOnly((Boolean)value);
            return;
        }
        if (attribute.equals(ARCHIVE_NAME)) {
            this.setArchive((Boolean)value);
            return;
        }
        if (attribute.equals(SYSTEM_NAME)) {
            this.setSystem((Boolean)value);
            return;
        }
        if (attribute.equals(HIDDEN_NAME)) {
            this.setHidden((Boolean)value);
            return;
        }
        super.setAttribute(attribute, value);
    }

    @Override
    public Map<String, Object> readAttributes(String[] attributes) throws IOException {
        AbstractBasicFileAttributeView.AttributesBuilder builder = AbstractBasicFileAttributeView.AttributesBuilder.create(dosAttributeNames, attributes);
        DosFileAttributes attrs = this.readAttributes();
        this.addRequestedBasicAttributes(attrs, builder);
        if (builder.match(READONLY_NAME)) {
            builder.add(READONLY_NAME, attrs.isReadOnly());
        }
        if (builder.match(ARCHIVE_NAME)) {
            builder.add(ARCHIVE_NAME, attrs.isArchive());
        }
        if (builder.match(SYSTEM_NAME)) {
            builder.add(SYSTEM_NAME, attrs.isSystem());
        }
        if (builder.match(HIDDEN_NAME)) {
            builder.add(HIDDEN_NAME, attrs.isHidden());
        }
        return builder.unmodifiableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DosFileAttributes readAttributes() throws IOException {
        this.file.checkRead();
        int fd = this.file.openForAttributeAccess(this.followLinks);
        try {
            final UnixFileAttributes attrs = UnixFileAttributes.get(fd);
            final int dosAttribute = this.getDosAttribute(fd);
            DosFileAttributes dosFileAttributes = new DosFileAttributes(){

                @Override
                public FileTime lastModifiedTime() {
                    return attrs.lastModifiedTime();
                }

                @Override
                public FileTime lastAccessTime() {
                    return attrs.lastAccessTime();
                }

                @Override
                public FileTime creationTime() {
                    return attrs.creationTime();
                }

                @Override
                public boolean isRegularFile() {
                    return attrs.isRegularFile();
                }

                @Override
                public boolean isDirectory() {
                    return attrs.isDirectory();
                }

                @Override
                public boolean isSymbolicLink() {
                    return attrs.isSymbolicLink();
                }

                @Override
                public boolean isOther() {
                    return attrs.isOther();
                }

                @Override
                public long size() {
                    return attrs.size();
                }

                @Override
                public Object fileKey() {
                    return attrs.fileKey();
                }

                @Override
                public boolean isReadOnly() {
                    return (dosAttribute & 1) != 0;
                }

                @Override
                public boolean isHidden() {
                    return (dosAttribute & 2) != 0;
                }

                @Override
                public boolean isArchive() {
                    return (dosAttribute & 0x20) != 0;
                }

                @Override
                public boolean isSystem() {
                    return (dosAttribute & 4) != 0;
                }
            };
            return dosFileAttributes;
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file);
            DosFileAttributes dosFileAttributes = null;
            return dosFileAttributes;
        }
        finally {
            UnixNativeDispatcher.close(fd);
        }
    }

    @Override
    public void setReadOnly(boolean value) throws IOException {
        this.updateDosAttribute(1, value);
    }

    @Override
    public void setHidden(boolean value) throws IOException {
        this.updateDosAttribute(2, value);
    }

    @Override
    public void setArchive(boolean value) throws IOException {
        this.updateDosAttribute(32, value);
    }

    @Override
    public void setSystem(boolean value) throws IOException {
        this.updateDosAttribute(4, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getDosAttribute(int fd) throws UnixException {
        int size = 24;
        NativeBuffer buffer = NativeBuffers.getNativeBuffer(24);
        try {
            int len = LinuxNativeDispatcher.fgetxattr(fd, DOS_XATTR_NAME_AS_BYTES, buffer.address(), 24);
            if (len <= 0) throw new UnixException("Value of user.DOSATTRIB attribute is invalid");
            if (unsafe.getByte(buffer.address() + (long)len - 1L) == 0) {
                --len;
            }
            byte[] buf = new byte[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = unsafe.getByte(buffer.address() + (long)i);
            }
            String value = Util.toString(buf);
            if (value.length() < 3 || !value.startsWith("0x")) throw new UnixException("Value of user.DOSATTRIB attribute is invalid");
            try {
                int n = Integer.parseInt(value.substring(2), 16);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    throw new UnixException("Value of user.DOSATTRIB attribute is invalid");
                }
                catch (UnixException x) {
                    if (x.errno() != UnixConstants.ENODATA) throw x;
                    int n = 0;
                    return n;
                }
            }
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDosAttribute(int flag, boolean enable) throws IOException {
        block8: {
            this.file.checkWrite();
            int fd = this.file.openForAttributeAccess(this.followLinks);
            try {
                int oldValue;
                int newValue = oldValue = this.getDosAttribute(fd);
                newValue = enable ? (newValue |= flag) : (newValue &= ~flag);
                if (newValue == oldValue) break block8;
                byte[] value = Util.toBytes("0x" + Integer.toHexString(newValue));
                NativeBuffer buffer = NativeBuffers.asNativeBuffer(value);
                try {
                    LinuxNativeDispatcher.fsetxattr(fd, DOS_XATTR_NAME_AS_BYTES, buffer.address(), value.length + 1);
                }
                finally {
                    buffer.release();
                }
            }
            catch (UnixException x) {
                x.rethrowAsIOException(this.file);
            }
            finally {
                UnixNativeDispatcher.close(fd);
            }
        }
    }
}

