/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessController;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import sun.net.NetHooks;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Net;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.Port;
import sun.nio.ch.SocketDispatcher;
import sun.security.action.GetPropertyAction;

class UnixAsynchronousSocketChannelImpl
extends AsynchronousSocketChannelImpl
implements Port.PollableChannel {
    private static final NativeDispatcher nd = new SocketDispatcher();
    private static final boolean disableSynchronousRead;
    private final Port port;
    private final int fdVal;
    private final Object updateLock = new Object();
    private boolean connectPending;
    private CompletionHandler<Void, Object> connectHandler;
    private Object connectAttachment;
    private PendingFuture<Void, Object> connectFuture;
    private SocketAddress pendingRemote;
    private boolean readPending;
    private boolean isScatteringRead;
    private ByteBuffer readBuffer;
    private ByteBuffer[] readBuffers;
    private CompletionHandler<Number, Object> readHandler;
    private Object readAttachment;
    private PendingFuture<Number, Object> readFuture;
    private Future<?> readTimer;
    private boolean writePending;
    private boolean isGatheringWrite;
    private ByteBuffer writeBuffer;
    private ByteBuffer[] writeBuffers;
    private CompletionHandler<Number, Object> writeHandler;
    private Object writeAttachment;
    private PendingFuture<Number, Object> writeFuture;
    private Future<?> writeTimer;
    private final CloseGuard guard = CloseGuard.get();
    private Runnable readTimeoutTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CompletionHandler handler = null;
            Object att = null;
            PendingFuture future = null;
            Object object = UnixAsynchronousSocketChannelImpl.this.updateLock;
            synchronized (object) {
                if (!UnixAsynchronousSocketChannelImpl.this.readPending) {
                    return;
                }
                UnixAsynchronousSocketChannelImpl.this.readPending = false;
                handler = UnixAsynchronousSocketChannelImpl.this.readHandler;
                att = UnixAsynchronousSocketChannelImpl.this.readAttachment;
                future = UnixAsynchronousSocketChannelImpl.this.readFuture;
            }
            UnixAsynchronousSocketChannelImpl.this.enableReading(true);
            InterruptedByTimeoutException exc = new InterruptedByTimeoutException();
            if (handler == null) {
                future.setFailure(exc);
            } else {
                UnixAsynchronousSocketChannelImpl ch = UnixAsynchronousSocketChannelImpl.this;
                Invoker.invokeIndirectly(ch, handler, att, null, exc);
            }
        }
    };
    private Runnable writeTimeoutTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CompletionHandler handler = null;
            Object att = null;
            PendingFuture future = null;
            Object object = UnixAsynchronousSocketChannelImpl.this.updateLock;
            synchronized (object) {
                if (!UnixAsynchronousSocketChannelImpl.this.writePending) {
                    return;
                }
                UnixAsynchronousSocketChannelImpl.this.writePending = false;
                handler = UnixAsynchronousSocketChannelImpl.this.writeHandler;
                att = UnixAsynchronousSocketChannelImpl.this.writeAttachment;
                future = UnixAsynchronousSocketChannelImpl.this.writeFuture;
            }
            UnixAsynchronousSocketChannelImpl.this.enableWriting(true);
            InterruptedByTimeoutException exc = new InterruptedByTimeoutException();
            if (handler != null) {
                Invoker.invokeIndirectly(UnixAsynchronousSocketChannelImpl.this, handler, att, null, exc);
            } else {
                future.setFailure(exc);
            }
        }
    };

    UnixAsynchronousSocketChannelImpl(Port port) throws IOException {
        super(port);
        try {
            IOUtil.configureBlocking(this.fd, false);
        }
        catch (IOException x) {
            nd.close(this.fd);
            throw x;
        }
        this.port = port;
        this.fdVal = IOUtil.fdVal(this.fd);
        port.register(this.fdVal, this);
        this.guard.open("close");
    }

    UnixAsynchronousSocketChannelImpl(Port port, FileDescriptor fd, InetSocketAddress remote) throws IOException {
        super(port, fd, remote);
        this.fdVal = IOUtil.fdVal(fd);
        IOUtil.configureBlocking(fd, false);
        try {
            port.register(this.fdVal, this);
        }
        catch (ShutdownChannelGroupException x) {
            throw new IOException(x);
        }
        this.port = port;
        this.guard.open("close");
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.port;
    }

    private void updateEvents() {
        assert (Thread.holdsLock(this.updateLock));
        int events = 0;
        if (this.readPending) {
            events |= Net.POLLIN;
        }
        if (this.connectPending || this.writePending) {
            events |= Net.POLLOUT;
        }
        if (events != 0) {
            this.port.startPoll(this.fdVal, events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndUpdateEvents() {
        Object object = this.updateLock;
        synchronized (object) {
            this.updateEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean mayInvokeDirect, boolean readable, boolean writable) {
        boolean finishRead = false;
        boolean finishWrite = false;
        boolean finishConnect = false;
        Object object = this.updateLock;
        synchronized (object) {
            if (readable && this.readPending) {
                this.readPending = false;
                finishRead = true;
            }
            if (writable) {
                if (this.writePending) {
                    this.writePending = false;
                    finishWrite = true;
                } else if (this.connectPending) {
                    this.connectPending = false;
                    finishConnect = true;
                }
            }
        }
        if (finishRead) {
            if (finishWrite) {
                this.finishWrite(false);
            }
            this.finishRead(mayInvokeDirect);
            return;
        }
        if (finishWrite) {
            this.finishWrite(mayInvokeDirect);
        }
        if (finishConnect) {
            this.finishConnect(mayInvokeDirect);
        }
    }

    @Override
    public void onEvent(int events, boolean mayInvokeDirect) {
        boolean writable;
        boolean readable = (events & Net.POLLIN) > 0;
        boolean bl = writable = (events & Net.POLLOUT) > 0;
        if ((events & (Net.POLLERR | Net.POLLHUP)) > 0) {
            readable = true;
            writable = true;
        }
        this.finish(mayInvokeDirect, readable, writable);
    }

    @Override
    void implClose() throws IOException {
        this.guard.close();
        this.port.unregister(this.fdVal);
        nd.close(this.fd);
        this.finish(false, true, true);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void onCancel(PendingFuture<?, ?> task) {
        if (task.getContext() == OpType.CONNECT) {
            this.killConnect();
        }
        if (task.getContext() == OpType.READ) {
            this.killReading();
        }
        if (task.getContext() == OpType.WRITE) {
            this.killWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = 2;
            this.localAddress = Net.localAddress(this.fd);
            this.remoteAddress = (InetSocketAddress)this.pendingRemote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishConnect(boolean mayInvokeDirect) {
        Throwable e = null;
        try {
            this.begin();
            UnixAsynchronousSocketChannelImpl.checkConnect(this.fdVal);
            this.setConnected();
        }
        catch (Throwable x2) {
            AsynchronousCloseException x2;
            if (x2 instanceof ClosedChannelException) {
                x2 = new AsynchronousCloseException();
            }
            e = x2;
        }
        finally {
            this.end();
        }
        if (e != null) {
            try {
                this.close();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
        }
        CompletionHandler<Void, Object> handler = this.connectHandler;
        Object att = this.connectAttachment;
        PendingFuture<Void, Object> future = this.connectFuture;
        if (handler == null) {
            future.setResult(null, e);
        } else if (mayInvokeDirect) {
            Invoker.invokeUnchecked(handler, att, null, e);
        } else {
            Invoker.invokeIndirectly(this, handler, att, null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <A> Future<Void> implConnect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        boolean notifyBeforeTcpConnect;
        if (!this.isOpen()) {
            ClosedChannelException e = new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withFailure(e);
            }
            Invoker.invoke(this, handler, attachment, null, e);
            return null;
        }
        InetSocketAddress isa = Net.checkAddress(remote);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(isa.getAddress().getHostAddress(), isa.getPort());
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
            this.state = 1;
            this.pendingRemote = remote;
            notifyBeforeTcpConnect = this.localAddress == null;
        }
        Throwable e = null;
        try {
            int n;
            this.begin();
            if (notifyBeforeTcpConnect) {
                NetHooks.beforeTcpConnect(this.fd, isa.getAddress(), isa.getPort());
            }
            if ((n = Net.connect(this.fd, isa.getAddress(), isa.getPort())) == -2) {
                PendingFuture result = null;
                PendingFuture pendingFuture = this.updateLock;
                synchronized (pendingFuture) {
                    if (handler == null) {
                        result = new PendingFuture(this, (Object)OpType.CONNECT);
                        this.connectFuture = result;
                    } else {
                        this.connectHandler = handler;
                        this.connectAttachment = attachment;
                    }
                    this.connectPending = true;
                    this.updateEvents();
                }
                pendingFuture = result;
                return pendingFuture;
            }
            this.setConnected();
        }
        catch (Throwable x2) {
            AsynchronousCloseException x2;
            if (x2 instanceof ClosedChannelException) {
                x2 = new AsynchronousCloseException();
            }
            e = x2;
        }
        finally {
            this.end();
        }
        if (e != null) {
            try {
                this.close();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
        }
        if (handler == null) {
            return CompletedFuture.withResult(null, e);
        }
        Invoker.invoke(this, handler, attachment, null, e);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRead(boolean mayInvokeDirect) {
        Integer result;
        int n = -1;
        Throwable exc = null;
        boolean scattering = this.isScatteringRead;
        CompletionHandler<Number, Object> handler = this.readHandler;
        Object att = this.readAttachment;
        PendingFuture<Number, Object> future = this.readFuture;
        Future<?> timeout = this.readTimer;
        try {
            this.begin();
            n = scattering ? (int)IOUtil.read(this.fd, this.readBuffers, nd) : IOUtil.read(this.fd, this.readBuffer, -1L, nd);
            if (n == -2) {
                Object object = this.updateLock;
                synchronized (object) {
                    this.readPending = true;
                }
                return;
            }
            this.readBuffer = null;
            this.readBuffers = null;
            this.readAttachment = null;
            this.enableReading();
        }
        catch (Throwable x2) {
            AsynchronousCloseException x2;
            this.enableReading();
            if (x2 instanceof ClosedChannelException) {
                x2 = new AsynchronousCloseException();
            }
            exc = x2;
        }
        finally {
            if (!(exc instanceof AsynchronousCloseException)) {
                this.lockAndUpdateEvents();
            }
            this.end();
        }
        if (timeout != null) {
            timeout.cancel(false);
        }
        Number number = exc != null ? null : (result = scattering ? (Number)Long.valueOf(n) : (Number)n);
        if (handler == null) {
            future.setResult(result, exc);
        } else if (mayInvokeDirect) {
            Invoker.invokeUnchecked(handler, att, result, exc);
        } else {
            Invoker.invokeIndirectly(this, handler, att, result, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <V extends Number, A> Future<V> implRead(boolean isScatteringRead, ByteBuffer dst, ByteBuffer[] dsts, long timeout, TimeUnit unit, A attachment, CompletionHandler<V, ? super A> handler) {
        Integer result;
        Throwable exc;
        int n;
        boolean invokeDirect;
        Invoker.GroupAndInvokeCount myGroupAndInvokeCount;
        block18: {
            myGroupAndInvokeCount = null;
            invokeDirect = false;
            boolean attemptRead = false;
            if (!disableSynchronousRead) {
                attemptRead = handler == null ? true : (invokeDirect = Invoker.mayInvokeDirect(myGroupAndInvokeCount = Invoker.getGroupAndInvokeCount(), this.port)) || !this.port.isFixedThreadPool();
            }
            n = -2;
            exc = null;
            boolean pending = false;
            try {
                this.begin();
                if (attemptRead) {
                    n = isScatteringRead ? (int)IOUtil.read(this.fd, dsts, nd) : IOUtil.read(this.fd, dst, -1L, nd);
                }
                if (n != -2) break block18;
                PendingFuture result2 = null;
                PendingFuture pendingFuture = this.updateLock;
                synchronized (pendingFuture) {
                    this.isScatteringRead = isScatteringRead;
                    this.readBuffer = dst;
                    this.readBuffers = dsts;
                    if (handler == null) {
                        this.readHandler = null;
                        result2 = new PendingFuture(this, (Object)OpType.READ);
                        this.readFuture = result2;
                        this.readAttachment = null;
                    } else {
                        this.readHandler = handler;
                        this.readAttachment = attachment;
                        this.readFuture = null;
                    }
                    if (timeout > 0L) {
                        this.readTimer = this.port.schedule(this.readTimeoutTask, timeout, unit);
                    }
                    this.readPending = true;
                    this.updateEvents();
                }
                pending = true;
                pendingFuture = result2;
                return pendingFuture;
            }
            catch (Throwable x2) {
                AsynchronousCloseException x2;
                if (x2 instanceof ClosedChannelException) {
                    x2 = new AsynchronousCloseException();
                }
                exc = x2;
            }
            finally {
                if (!pending) {
                    this.enableReading();
                }
                this.end();
            }
        }
        Number number = exc != null ? null : (result = isScatteringRead ? (Number)Long.valueOf(n) : (Number)n);
        if (handler != null) {
            if (invokeDirect) {
                Invoker.invokeDirect(myGroupAndInvokeCount, handler, attachment, result, exc);
            } else {
                Invoker.invokeIndirectly(this, handler, attachment, result, exc);
            }
            return null;
        }
        return CompletedFuture.withResult(result, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWrite(boolean mayInvokeDirect) {
        Integer result;
        int n = -1;
        Throwable exc = null;
        boolean gathering = this.isGatheringWrite;
        CompletionHandler<Number, Object> handler = this.writeHandler;
        Object att = this.writeAttachment;
        PendingFuture<Number, Object> future = this.writeFuture;
        Future<?> timer = this.writeTimer;
        try {
            this.begin();
            n = gathering ? (int)IOUtil.write(this.fd, this.writeBuffers, nd) : IOUtil.write(this.fd, this.writeBuffer, -1L, nd);
            if (n == -2) {
                Object object = this.updateLock;
                synchronized (object) {
                    this.writePending = true;
                }
                return;
            }
            this.writeBuffer = null;
            this.writeBuffers = null;
            this.writeAttachment = null;
            this.enableWriting();
        }
        catch (Throwable x2) {
            AsynchronousCloseException x2;
            this.enableWriting();
            if (x2 instanceof ClosedChannelException) {
                x2 = new AsynchronousCloseException();
            }
            exc = x2;
        }
        finally {
            if (!(exc instanceof AsynchronousCloseException)) {
                this.lockAndUpdateEvents();
            }
            this.end();
        }
        if (timer != null) {
            timer.cancel(false);
        }
        Number number = exc != null ? null : (result = gathering ? (Number)Long.valueOf(n) : (Number)n);
        if (handler == null) {
            future.setResult(result, exc);
        } else if (mayInvokeDirect) {
            Invoker.invokeUnchecked(handler, att, result, exc);
        } else {
            Invoker.invokeIndirectly(this, handler, att, result, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <V extends Number, A> Future<V> implWrite(boolean isGatheringWrite, ByteBuffer src, ByteBuffer[] srcs, long timeout, TimeUnit unit, A attachment, CompletionHandler<V, ? super A> handler) {
        Integer result;
        Throwable exc;
        int n;
        boolean invokeDirect;
        Invoker.GroupAndInvokeCount myGroupAndInvokeCount;
        block17: {
            myGroupAndInvokeCount = Invoker.getGroupAndInvokeCount();
            invokeDirect = Invoker.mayInvokeDirect(myGroupAndInvokeCount, this.port);
            boolean attemptWrite = handler == null || invokeDirect || !this.port.isFixedThreadPool();
            n = -2;
            exc = null;
            boolean pending = false;
            try {
                this.begin();
                if (attemptWrite) {
                    n = isGatheringWrite ? (int)IOUtil.write(this.fd, srcs, nd) : IOUtil.write(this.fd, src, -1L, nd);
                }
                if (n != -2) break block17;
                PendingFuture result2 = null;
                PendingFuture pendingFuture = this.updateLock;
                synchronized (pendingFuture) {
                    this.isGatheringWrite = isGatheringWrite;
                    this.writeBuffer = src;
                    this.writeBuffers = srcs;
                    if (handler == null) {
                        this.writeHandler = null;
                        result2 = new PendingFuture(this, (Object)OpType.WRITE);
                        this.writeFuture = result2;
                        this.writeAttachment = null;
                    } else {
                        this.writeHandler = handler;
                        this.writeAttachment = attachment;
                        this.writeFuture = null;
                    }
                    if (timeout > 0L) {
                        this.writeTimer = this.port.schedule(this.writeTimeoutTask, timeout, unit);
                    }
                    this.writePending = true;
                    this.updateEvents();
                }
                pending = true;
                pendingFuture = result2;
                return pendingFuture;
            }
            catch (Throwable x2) {
                AsynchronousCloseException x2;
                if (x2 instanceof ClosedChannelException) {
                    x2 = new AsynchronousCloseException();
                }
                exc = x2;
            }
            finally {
                if (!pending) {
                    this.enableWriting();
                }
                this.end();
            }
        }
        Number number = exc != null ? null : (result = isGatheringWrite ? (Number)Long.valueOf(n) : (Number)n);
        if (handler != null) {
            if (invokeDirect) {
                Invoker.invokeDirect(myGroupAndInvokeCount, handler, attachment, result, exc);
            } else {
                Invoker.invokeIndirectly(this, handler, attachment, result, exc);
            }
            return null;
        }
        return CompletedFuture.withResult(result, exc);
    }

    private static native void checkConnect(int var0) throws IOException;

    static {
        String propValue = AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.disableSynchronousRead", "false"));
        disableSynchronousRead = propValue.length() == 0 ? true : Boolean.valueOf(propValue);
    }

    private static enum OpType {
        CONNECT,
        READ,
        WRITE;

    }
}

