/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;

public class DatagramSocketAdaptor
extends DatagramSocket {
    private final DatagramChannelImpl dc;
    private volatile int timeout = 0;
    private static final DatagramSocketImpl dummyDatagramSocket = new DatagramSocketImpl(){

        @Override
        protected void create() throws SocketException {
        }

        @Override
        protected void bind(int lport, InetAddress laddr) throws SocketException {
        }

        @Override
        protected void send(DatagramPacket p) throws IOException {
        }

        @Override
        protected int peek(InetAddress i) throws IOException {
            return 0;
        }

        @Override
        protected int peekData(DatagramPacket p) throws IOException {
            return 0;
        }

        @Override
        protected void receive(DatagramPacket p) throws IOException {
        }

        @Override
        @Deprecated
        protected void setTTL(byte ttl) throws IOException {
        }

        @Override
        @Deprecated
        protected byte getTTL() throws IOException {
            return 0;
        }

        @Override
        protected void setTimeToLive(int ttl) throws IOException {
        }

        @Override
        protected int getTimeToLive() throws IOException {
            return 0;
        }

        @Override
        protected void join(InetAddress inetaddr) throws IOException {
        }

        @Override
        protected void leave(InetAddress inetaddr) throws IOException {
        }

        @Override
        protected void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        }

        @Override
        protected void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        }

        @Override
        protected void close() {
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            return null;
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
        }
    };

    private DatagramSocketAdaptor(DatagramChannelImpl dc) throws IOException {
        super(dummyDatagramSocket);
        this.dc = dc;
    }

    public static DatagramSocket create(DatagramChannelImpl dc) {
        try {
            return new DatagramSocketAdaptor(dc);
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    private void connectInternal(SocketAddress remote) throws SocketException {
        InetSocketAddress isa = Net.asInetSocketAddress(remote);
        int port = isa.getPort();
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("connect: " + port);
        }
        if (remote == null) {
            throw new IllegalArgumentException("connect: null address");
        }
        if (this.isClosed()) {
            return;
        }
        try {
            this.dc.connect(remote);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public void bind(SocketAddress local) throws SocketException {
        try {
            if (local == null) {
                local = new InetSocketAddress(0);
            }
            this.dc.bind(local);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public void connect(InetAddress address, int port) {
        try {
            this.connectInternal(new InetSocketAddress(address, port));
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void connect(SocketAddress remote) throws SocketException {
        if (remote == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        this.connectInternal(remote);
    }

    @Override
    public void disconnect() {
        try {
            this.dc.disconnect();
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    @Override
    public boolean isBound() {
        return this.dc.localAddress() != null;
    }

    @Override
    public boolean isConnected() {
        return this.dc.remoteAddress() != null;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getAddress() : null;
    }

    @Override
    public int getPort() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getPort() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(DatagramPacket p) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket = p;
                synchronized (datagramPacket) {
                    ByteBuffer bb = ByteBuffer.wrap(p.getData(), p.getOffset(), p.getLength());
                    if (this.dc.isConnected()) {
                        if (p.getAddress() == null) {
                            InetSocketAddress isa = (InetSocketAddress)this.dc.remoteAddress();
                            p.setPort(isa.getPort());
                            p.setAddress(isa.getAddress());
                            this.dc.write(bb);
                        } else {
                            this.dc.send(bb, p.getSocketAddress());
                        }
                    } else {
                        this.dc.send(bb, p.getSocketAddress());
                    }
                }
            }
            catch (IOException x) {
                Net.translateException(x);
            }
        }
    }

    private SocketAddress receive(ByteBuffer bb) throws IOException {
        if (this.timeout == 0) {
            return this.dc.receive(bb);
        }
        this.dc.configureBlocking(false);
        try {
            long st;
            SocketAddress sender = this.dc.receive(bb);
            if (sender != null) {
                SocketAddress socketAddress = sender;
                return socketAddress;
            }
            long to = this.timeout;
            do {
                if (!this.dc.isOpen()) {
                    throw new ClosedChannelException();
                }
                st = System.currentTimeMillis();
                int result = this.dc.poll(Net.POLLIN, to);
                if (result <= 0 || (result & Net.POLLIN) == 0 || (sender = this.dc.receive(bb)) == null) continue;
                SocketAddress socketAddress = sender;
                return socketAddress;
            } while ((to -= System.currentTimeMillis() - st) > 0L);
            throw new SocketTimeoutException();
        }
        finally {
            if (this.dc.isOpen()) {
                this.dc.configureBlocking(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(DatagramPacket p) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket = p;
                synchronized (datagramPacket) {
                    ByteBuffer bb = ByteBuffer.wrap(p.getData(), p.getOffset(), p.getLength());
                    SocketAddress sender = this.receive(bb);
                    p.setSocketAddress(sender);
                    p.setLength(bb.position() - p.getOffset());
                }
            }
            catch (IOException x) {
                Net.translateException(x);
            }
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        SocketAddress local = this.dc.localAddress();
        if (local == null) {
            local = new InetSocketAddress(0);
        }
        InetAddress result = ((InetSocketAddress)local).getAddress();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkConnect(result.getHostAddress(), -1);
            }
            catch (SecurityException x) {
                return new InetSocketAddress(0).getAddress();
            }
        }
        return result;
    }

    @Override
    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            SocketAddress local = this.dc.getLocalAddress();
            if (local != null) {
                return ((InetSocketAddress)local).getPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    private void setBooleanOption(SocketOption<Boolean> name, boolean value) throws SocketException {
        try {
            this.dc.setOption((SocketOption)name, (Object)value);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    private void setIntOption(SocketOption<Integer> name, int value) throws SocketException {
        try {
            this.dc.setOption((SocketOption)name, (Object)value);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    private boolean getBooleanOption(SocketOption<Boolean> name) throws SocketException {
        try {
            return this.dc.getOption(name);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return false;
        }
    }

    private int getIntOption(SocketOption<Integer> name) throws SocketException {
        try {
            return this.dc.getOption(name);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return -1;
        }
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setIntOption(StandardSocketOptions.SO_SNDBUF, size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_SNDBUF);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setIntOption(StandardSocketOptions.SO_RCVBUF, size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_RCVBUF);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_REUSEADDR, on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_REUSEADDR);
    }

    @Override
    public void setBroadcast(boolean on) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_BROADCAST, on);
    }

    @Override
    public boolean getBroadcast() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_BROADCAST);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.setIntOption(StandardSocketOptions.IP_TOS, tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.getIntOption(StandardSocketOptions.IP_TOS);
    }

    @Override
    public void close() {
        try {
            this.dc.close();
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    @Override
    public boolean isClosed() {
        return !this.dc.isOpen();
    }

    @Override
    public DatagramChannel getChannel() {
        return this.dc;
    }

    @Override
    public final FileDescriptor getFileDescriptor$() {
        return this.dc.fd;
    }
}

