/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.SelectableChannel;

public class ChannelInputStream
extends InputStream {
    protected final ReadableByteChannel ch;
    private ByteBuffer bb = null;
    private byte[] bs = null;
    private byte[] b1 = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int read(ReadableByteChannel ch, ByteBuffer bb) throws IOException {
        if (ch instanceof SelectableChannel) {
            SelectableChannel sc = (SelectableChannel)((Object)ch);
            Object object = sc.blockingLock();
            synchronized (object) {
                boolean bm = sc.isBlocking();
                if (!bm) {
                    throw new IllegalBlockingModeException();
                }
                int n = ch.read(bb);
                return n;
            }
        }
        return ch.read(bb);
    }

    public ChannelInputStream(ReadableByteChannel ch) {
        this.ch = ch;
    }

    @Override
    public synchronized int read() throws IOException {
        int n;
        if (this.b1 == null) {
            this.b1 = new byte[1];
        }
        if ((n = this.read(this.b1)) == 1) {
            return this.b1[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] bs, int off, int len) throws IOException {
        if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer bb = this.bs == bs ? this.bb : ByteBuffer.wrap(bs);
        bb.limit(Math.min(off + len, bb.capacity()));
        bb.position(off);
        this.bb = bb;
        this.bs = bs;
        return this.read(bb);
    }

    protected int read(ByteBuffer bb) throws IOException {
        return ChannelInputStream.read(this.ch, bb);
    }

    @Override
    public int available() throws IOException {
        if (this.ch instanceof SeekableByteChannel) {
            SeekableByteChannel sbc = (SeekableByteChannel)this.ch;
            long rem = Math.max(0L, sbc.size() - sbc.position());
            return rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rem;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }
}

