/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.ftp;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import libcore.net.NetworkSecurityPolicy;
import sun.net.ProgressMonitor;
import sun.net.ProgressSource;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpLoginException;
import sun.net.ftp.FtpProtocolException;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;
import sun.security.action.GetPropertyAction;

public class FtpURLConnection
extends URLConnection {
    private Proxy instProxy;
    InputStream is = null;
    OutputStream os = null;
    FtpClient ftp = null;
    Permission permission;
    String password;
    String user;
    String host;
    String pathname;
    String filename;
    String fullpath;
    int port;
    static final int NONE = 0;
    static final int ASCII = 1;
    static final int BIN = 2;
    static final int DIR = 3;
    int type = 0;
    private int connectTimeout = -1;
    private int readTimeout = -1;

    public FtpURLConnection(URL url) throws IOException {
        this(url, null);
    }

    FtpURLConnection(URL url, Proxy p) throws IOException {
        super(url);
        this.instProxy = p;
        this.host = url.getHost();
        this.port = url.getPort();
        String userInfo = url.getUserInfo();
        if (!NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted()) {
            throw new IOException("Cleartext traffic not permitted: " + url.getProtocol() + "://" + this.host + (url.getPort() >= 0 ? ":" + url.getPort() : ""));
        }
        if (userInfo != null) {
            int delimiter = userInfo.indexOf(58);
            if (delimiter == -1) {
                this.user = ParseUtil.decode(userInfo);
                this.password = null;
            } else {
                this.user = ParseUtil.decode(userInfo.substring(0, delimiter++));
                this.password = ParseUtil.decode(userInfo.substring(delimiter));
            }
        }
    }

    private void setTimeouts() {
        if (this.ftp != null) {
            if (this.connectTimeout >= 0) {
                this.ftp.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout >= 0) {
                this.ftp.setReadTimeout(this.readTimeout);
            }
        }
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        Proxy p2 = null;
        if (this.instProxy == null) {
            ProxySelector sel = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

                @Override
                public ProxySelector run() {
                    return ProxySelector.getDefault();
                }
            });
            if (sel != null) {
                URI uri = ParseUtil.toURI(this.url);
                for (Proxy p2 : sel.select(uri)) {
                    if (p2 == null || p2 == Proxy.NO_PROXY || p2.type() == Proxy.Type.SOCKS) break;
                    if (p2.type() != Proxy.Type.HTTP || !(p2.address() instanceof InetSocketAddress)) {
                        sel.connectFailed(uri, p2.address(), new IOException("Wrong proxy type"));
                        continue;
                    }
                    sel.connectFailed(uri, p2.address(), new IOException("FTP connections over HTTP proxy not supported"));
                }
            }
        } else {
            p2 = this.instProxy;
        }
        if (this.user == null) {
            this.user = "anonymous";
            String vers = AccessController.doPrivileged(new GetPropertyAction("java.version"));
            this.password = AccessController.doPrivileged(new GetPropertyAction("ftp.protocol.user", "Java" + vers + "@"));
        }
        try {
            this.ftp = FtpClient.create();
            if (p2 != null) {
                this.ftp.setProxy(p2);
            }
            this.setTimeouts();
            if (this.port != -1) {
                this.ftp.connect(new InetSocketAddress(this.host, this.port));
            } else {
                this.ftp.connect(new InetSocketAddress(this.host, FtpClient.defaultPort()));
            }
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (FtpProtocolException fe) {
            throw new IOException(fe);
        }
        try {
            this.ftp.login(this.user, this.password == null ? null : this.password.toCharArray());
        }
        catch (FtpProtocolException e) {
            this.ftp.close();
            throw new FtpLoginException("Invalid username/password");
        }
        this.connected = true;
    }

    private void decodePath(String path) {
        int i = path.indexOf(";type=");
        if (i >= 0) {
            String s1 = path.substring(i + 6, path.length());
            if ("i".equalsIgnoreCase(s1)) {
                this.type = 2;
            }
            if ("a".equalsIgnoreCase(s1)) {
                this.type = 1;
            }
            if ("d".equalsIgnoreCase(s1)) {
                this.type = 3;
            }
            path = path.substring(0, i);
        }
        if (path != null && path.length() > 1 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path == null || path.length() == 0) {
            path = "./";
        }
        if (!path.endsWith("/")) {
            i = path.lastIndexOf(47);
            if (i > 0) {
                this.filename = path.substring(i + 1, path.length());
                this.filename = ParseUtil.decode(this.filename);
                this.pathname = path.substring(0, i);
            } else {
                this.filename = ParseUtil.decode(path);
                this.pathname = null;
            }
        } else {
            this.pathname = path.substring(0, path.length() - 1);
            this.filename = null;
        }
        this.fullpath = this.pathname != null ? this.pathname + "/" + (this.filename != null ? this.filename : "") : this.filename;
    }

    private void cd(String path) throws FtpProtocolException, IOException {
        if (path == null || path.isEmpty()) {
            return;
        }
        if (path.indexOf(47) == -1) {
            this.ftp.changeDirectory(ParseUtil.decode(path));
            return;
        }
        StringTokenizer token = new StringTokenizer(path, "/");
        while (token.hasMoreTokens()) {
            this.ftp.changeDirectory(ParseUtil.decode(token.nextToken()));
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.os != null) {
            throw new IOException("Already opened for output");
        }
        if (this.is != null) {
            return this.is;
        }
        MessageHeader msgh = new MessageHeader();
        boolean isAdir = false;
        try {
            this.decodePath(this.url.getPath());
            if (this.filename == null || this.type == 3) {
                this.ftp.setAsciiType();
                this.cd(this.pathname);
                this.is = this.filename == null ? new FtpInputStream(this.ftp, this.ftp.list(null)) : new FtpInputStream(this.ftp, this.ftp.nameList(this.filename));
            } else {
                if (this.type == 1) {
                    this.ftp.setAsciiType();
                } else {
                    this.ftp.setBinaryType();
                }
                this.cd(this.pathname);
                this.is = new FtpInputStream(this.ftp, this.ftp.getFileStream(this.filename));
            }
            try {
                long l = this.ftp.getLastTransferSize();
                msgh.add("content-length", Long.toString(l));
                if (l > 0L) {
                    boolean meteredInput = ProgressMonitor.getDefault().shouldMeterInput(this.url, "GET");
                    ProgressSource pi = null;
                    if (meteredInput) {
                        pi = new ProgressSource(this.url, "GET", l);
                        pi.beginTracking();
                    }
                    this.is = new MeteredStream(this.is, pi, l);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (isAdir) {
                msgh.add("content-type", "text/plain");
                msgh.add("access-type", "directory");
            } else {
                msgh.add("access-type", "file");
                String ftype = FtpURLConnection.guessContentTypeFromName(this.fullpath);
                if (ftype == null && this.is.markSupported()) {
                    ftype = FtpURLConnection.guessContentTypeFromStream(this.is);
                }
                if (ftype != null) {
                    msgh.add("content-type", ftype);
                }
            }
        }
        catch (FileNotFoundException e) {
            try {
                this.cd(this.fullpath);
                this.ftp.setAsciiType();
                this.is = new FtpInputStream(this.ftp, this.ftp.list(null));
                msgh.add("content-type", "text/plain");
                msgh.add("access-type", "directory");
            }
            catch (IOException ex) {
                throw new FileNotFoundException(this.fullpath);
            }
            catch (FtpProtocolException ex2) {
                throw new FileNotFoundException(this.fullpath);
            }
        }
        catch (FtpProtocolException ftpe) {
            throw new IOException(ftpe);
        }
        this.setProperties(msgh);
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.is != null) {
            throw new IOException("Already opened for input");
        }
        if (this.os != null) {
            return this.os;
        }
        this.decodePath(this.url.getPath());
        if (this.filename == null || this.filename.length() == 0) {
            throw new IOException("illegal filename for a PUT");
        }
        try {
            if (this.pathname != null) {
                this.cd(this.pathname);
            }
            if (this.type == 1) {
                this.ftp.setAsciiType();
            } else {
                this.ftp.setBinaryType();
            }
            this.os = new FtpOutputStream(this.ftp, this.ftp.putFileStream(this.filename, false));
        }
        catch (FtpProtocolException e) {
            throw new IOException(e);
        }
        return this.os;
    }

    String guessContentTypeFromFilename(String fname) {
        return FtpURLConnection.guessContentTypeFromName(fname);
    }

    @Override
    public Permission getPermission() {
        if (this.permission == null) {
            int urlport = this.url.getPort();
            urlport = urlport < 0 ? FtpClient.defaultPort() : urlport;
            String urlhost = this.host + ":" + urlport;
            this.permission = new SocketPermission(urlhost, "connect");
        }
        return this.permission;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        super.setRequestProperty(key, value);
        if ("type".equals(key)) {
            if ("i".equalsIgnoreCase(value)) {
                this.type = 2;
            } else if ("a".equalsIgnoreCase(value)) {
                this.type = 1;
            } else if ("d".equalsIgnoreCase(value)) {
                this.type = 3;
            } else {
                throw new IllegalArgumentException("Value of '" + key + "' request property was '" + value + "' when it must be either 'i', 'a' or 'd'");
            }
        }
    }

    @Override
    public String getRequestProperty(String key) {
        String value = super.getRequestProperty(key);
        if (value == null && "type".equals(key)) {
            value = this.type == 1 ? "a" : (this.type == 3 ? "d" : "i");
        }
        return value;
    }

    @Override
    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.connectTimeout = timeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? 0 : this.connectTimeout;
    }

    @Override
    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.readTimeout = timeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout < 0 ? 0 : this.readTimeout;
    }

    protected class FtpOutputStream
    extends FilterOutputStream {
        FtpClient ftp;

        FtpOutputStream(FtpClient cl, OutputStream fd) {
            super(fd);
            this.ftp = cl;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.ftp != null) {
                this.ftp.close();
            }
        }
    }

    protected class FtpInputStream
    extends FilterInputStream {
        FtpClient ftp;

        FtpInputStream(FtpClient cl, InputStream fd) {
            super(new BufferedInputStream(fd));
            this.ftp = cl;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.ftp != null) {
                this.ftp.close();
            }
        }
    }
}

