/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.ProgressSource;

public class MeteredStream
extends FilterInputStream {
    protected boolean closed = false;
    protected long expected;
    protected long count = 0L;
    protected long markedCount = 0L;
    protected int markLimit = -1;
    protected ProgressSource pi;

    public MeteredStream(InputStream is, ProgressSource pi, long expected) {
        super(is);
        this.pi = pi;
        this.expected = expected;
        if (pi != null) {
            pi.updateProgress(0L, expected);
        }
    }

    private final void justRead(long n) throws IOException {
        if (n == -1L) {
            if (!this.isMarked()) {
                this.close();
            }
            return;
        }
        this.count += n;
        if (this.count - this.markedCount > (long)this.markLimit) {
            this.markLimit = -1;
        }
        if (this.pi != null) {
            this.pi.updateProgress(this.count, this.expected);
        }
        if (this.isMarked()) {
            return;
        }
        if (this.expected > 0L && this.count >= this.expected) {
            this.close();
        }
    }

    private boolean isMarked() {
        if (this.markLimit < 0) {
            return false;
        }
        return this.count - this.markedCount <= (long)this.markLimit;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int c = this.in.read();
        if (c != -1) {
            this.justRead(1L);
        } else {
            this.justRead(c);
        }
        return c;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n = this.in.read(b, off, len);
        this.justRead(n);
        return n;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (this.closed) {
            return 0L;
        }
        long min = n > this.expected - this.count ? this.expected - this.count : n;
        n = this.in.skip(min);
        this.justRead(n);
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.pi != null) {
            this.pi.finishTracking();
        }
        this.closed = true;
        this.in.close();
    }

    @Override
    public synchronized int available() throws IOException {
        return this.closed ? 0 : this.in.available();
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (this.closed) {
            return;
        }
        super.mark(readLimit);
        this.markedCount = this.count;
        this.markLimit = readLimit;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.isMarked()) {
            throw new IOException("Resetting to an invalid mark");
        }
        this.count = this.markedCount;
        super.reset();
    }

    @Override
    public boolean markSupported() {
        if (this.closed) {
            return false;
        }
        return super.markSupported();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            if (this.pi != null) {
                this.pi.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

