/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import dalvik.annotation.optimization.FastNative;
import dalvik.system.VMStack;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class Unsafe {
    private static final Unsafe THE_ONE;
    private static final Unsafe theUnsafe;
    public static final int INVALID_FIELD_OFFSET = -1;

    private Unsafe() {
    }

    public static Unsafe getUnsafe() {
        ClassLoader calling = VMStack.getCallingClassLoader();
        if (calling != null && calling != Unsafe.class.getClassLoader()) {
            throw new SecurityException("Unsafe access denied");
        }
        return THE_ONE;
    }

    public long objectFieldOffset(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("valid for instance fields only");
        }
        return field.getOffset();
    }

    public int arrayBaseOffset(Class clazz) {
        Class<?> component = clazz.getComponentType();
        if (component == null) {
            throw new IllegalArgumentException("Valid for array classes only: " + clazz);
        }
        return Unsafe.getArrayBaseOffsetForComponentType(component);
    }

    public int arrayIndexScale(Class clazz) {
        Class<?> component = clazz.getComponentType();
        if (component == null) {
            throw new IllegalArgumentException("Valid for array classes only: " + clazz);
        }
        return Unsafe.getArrayIndexScaleForComponentType(component);
    }

    @FastNative
    private static native int getArrayBaseOffsetForComponentType(Class var0);

    @FastNative
    private static native int getArrayIndexScaleForComponentType(Class var0);

    @FastNative
    public native boolean compareAndSwapInt(Object var1, long var2, int var4, int var5);

    @FastNative
    public native boolean compareAndSwapLong(Object var1, long var2, long var4, long var6);

    @FastNative
    public native boolean compareAndSwapObject(Object var1, long var2, Object var4, Object var5);

    @FastNative
    public native int getIntVolatile(Object var1, long var2);

    @FastNative
    public native void putIntVolatile(Object var1, long var2, int var4);

    @FastNative
    public native long getLongVolatile(Object var1, long var2);

    @FastNative
    public native void putLongVolatile(Object var1, long var2, long var4);

    @FastNative
    public native Object getObjectVolatile(Object var1, long var2);

    @FastNative
    public native void putObjectVolatile(Object var1, long var2, Object var4);

    @FastNative
    public native int getInt(Object var1, long var2);

    @FastNative
    public native void putInt(Object var1, long var2, int var4);

    @FastNative
    public native void putOrderedInt(Object var1, long var2, int var4);

    @FastNative
    public native long getLong(Object var1, long var2);

    @FastNative
    public native void putLong(Object var1, long var2, long var4);

    @FastNative
    public native void putOrderedLong(Object var1, long var2, long var4);

    @FastNative
    public native Object getObject(Object var1, long var2);

    @FastNative
    public native void putObject(Object var1, long var2, Object var4);

    @FastNative
    public native void putOrderedObject(Object var1, long var2, Object var4);

    @FastNative
    public native boolean getBoolean(Object var1, long var2);

    @FastNative
    public native void putBoolean(Object var1, long var2, boolean var4);

    @FastNative
    public native byte getByte(Object var1, long var2);

    @FastNative
    public native void putByte(Object var1, long var2, byte var4);

    @FastNative
    public native char getChar(Object var1, long var2);

    @FastNative
    public native void putChar(Object var1, long var2, char var4);

    @FastNative
    public native short getShort(Object var1, long var2);

    @FastNative
    public native void putShort(Object var1, long var2, short var4);

    @FastNative
    public native float getFloat(Object var1, long var2);

    @FastNative
    public native void putFloat(Object var1, long var2, float var4);

    @FastNative
    public native double getDouble(Object var1, long var2);

    @FastNative
    public native void putDouble(Object var1, long var2, double var4);

    public native void park(boolean var1, long var2);

    @FastNative
    public native void unpark(Object var1);

    public native Object allocateInstance(Class<?> var1);

    @FastNative
    public native int addressSize();

    @FastNative
    public native int pageSize();

    @FastNative
    public native long allocateMemory(long var1);

    @FastNative
    public native void freeMemory(long var1);

    @FastNative
    public native void setMemory(long var1, long var3, byte var5);

    @FastNative
    public native byte getByte(long var1);

    @FastNative
    public native void putByte(long var1, byte var3);

    @FastNative
    public native short getShort(long var1);

    @FastNative
    public native void putShort(long var1, short var3);

    @FastNative
    public native char getChar(long var1);

    @FastNative
    public native void putChar(long var1, char var3);

    @FastNative
    public native int getInt(long var1);

    @FastNative
    public native void putInt(long var1, int var3);

    @FastNative
    public native long getLong(long var1);

    @FastNative
    public native void putLong(long var1, long var3);

    @FastNative
    public native float getFloat(long var1);

    @FastNative
    public native void putFloat(long var1, float var3);

    @FastNative
    public native double getDouble(long var1);

    @FastNative
    public native void putDouble(long var1, double var3);

    @FastNative
    public native void copyMemoryToPrimitiveArray(long var1, Object var3, long var4, long var6);

    @FastNative
    public native void copyMemoryFromPrimitiveArray(Object var1, long var2, long var4, long var6);

    @FastNative
    public native void copyMemory(long var1, long var3, long var5);

    public final int getAndAddInt(Object o, long offset, int delta) {
        int v;
        while (!this.compareAndSwapInt(o, offset, v = this.getIntVolatile(o, offset), v + delta)) {
        }
        return v;
    }

    public final long getAndAddLong(Object o, long offset, long delta) {
        long v;
        while (!this.compareAndSwapLong(o, offset, v = this.getLongVolatile(o, offset), v + delta)) {
        }
        return v;
    }

    public final int getAndSetInt(Object o, long offset, int newValue) {
        int v;
        while (!this.compareAndSwapInt(o, offset, v = this.getIntVolatile(o, offset), newValue)) {
        }
        return v;
    }

    public final long getAndSetLong(Object o, long offset, long newValue) {
        long v;
        while (!this.compareAndSwapLong(o, offset, v = this.getLongVolatile(o, offset), newValue)) {
        }
        return v;
    }

    public final Object getAndSetObject(Object o, long offset, Object newValue) {
        Object v;
        while (!this.compareAndSwapObject(o, offset, v = this.getObjectVolatile(o, offset), newValue)) {
        }
        return v;
    }

    @FastNative
    public native void loadFence();

    @FastNative
    public native void storeFence();

    @FastNative
    public native void fullFence();

    static {
        theUnsafe = THE_ONE = new Unsafe();
    }
}

