/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;

public class VerifyAccess {
    private static final int PACKAGE_ONLY = 0;
    private static final int PACKAGE_ALLOWED = 8;
    private static final int PROTECTED_OR_PACKAGE_ALLOWED = 12;
    private static final int ALL_ACCESS_MODES = 7;
    private static final boolean ALLOW_NESTMATE_ACCESS = false;

    private VerifyAccess() {
    }

    public static boolean isMemberAccessible(Class<?> refc, Class<?> defc, int mods, Class<?> lookupClass, int allowedModes) {
        if (allowedModes == 0) {
            return false;
        }
        assert ((allowedModes & 1) != 0 && (allowedModes & 0xFFFFFFF0) == 0);
        if (!VerifyAccess.isClassAccessible(refc, lookupClass, allowedModes)) {
            return false;
        }
        if (defc == lookupClass && (allowedModes & 2) != 0) {
            return true;
        }
        switch (mods & 7) {
            case 1: {
                return true;
            }
            case 4: {
                assert (!defc.isInterface());
                if ((allowedModes & 0xC) != 0 && VerifyAccess.isSamePackage(defc, lookupClass)) {
                    return true;
                }
                if ((allowedModes & 4) == 0) {
                    return false;
                }
                if ((mods & 8) != 0 && !VerifyAccess.isRelatedClass(refc, lookupClass)) {
                    return false;
                }
                return (allowedModes & 4) != 0 && VerifyAccess.isSubClass(lookupClass, defc);
            }
            case 0: {
                assert (!defc.isInterface());
                return (allowedModes & 8) != 0 && VerifyAccess.isSamePackage(defc, lookupClass);
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("bad modifiers: " + Modifier.toString(mods));
    }

    static boolean isRelatedClass(Class<?> refc, Class<?> lookupClass) {
        return refc == lookupClass || VerifyAccess.isSubClass(refc, lookupClass) || VerifyAccess.isSubClass(lookupClass, refc);
    }

    static boolean isSubClass(Class<?> lookupClass, Class<?> defc) {
        return defc.isAssignableFrom(lookupClass) && !lookupClass.isInterface();
    }

    public static boolean isClassAccessible(Class<?> refc, Class<?> lookupClass, int allowedModes) {
        if (allowedModes == 0) {
            return false;
        }
        if (Modifier.isPublic(refc.getModifiers())) {
            return true;
        }
        return (allowedModes & 8) != 0 && VerifyAccess.isSamePackage(lookupClass, refc);
    }

    public static boolean isTypeVisible(Class<?> type, Class<?> refc) {
        if (type == refc) {
            return true;
        }
        while (type.isArray()) {
            type = type.getComponentType();
        }
        if (type.isPrimitive() || type == Object.class) {
            return true;
        }
        ClassLoader parent = type.getClassLoader();
        if (parent == null) {
            return true;
        }
        ClassLoader child = refc.getClassLoader();
        if (child == null) {
            return false;
        }
        if (parent == child || VerifyAccess.loadersAreRelated(parent, child, true)) {
            return true;
        }
        try {
            Class<?> res = child.loadClass(type.getName());
            return type == res;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isTypeVisible(MethodType type, Class<?> refc) {
        int max = type.parameterCount();
        for (int n = -1; n < max; ++n) {
            Class<?> ptype;
            Class<?> clazz = ptype = n < 0 ? type.returnType() : type.parameterType(n);
            if (VerifyAccess.isTypeVisible(ptype, refc)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSamePackage(Class<?> class1, Class<?> class2) {
        if (class1.isArray() || class2.isArray()) {
            throw new IllegalArgumentException();
        }
        if (class1 == class2) {
            return true;
        }
        if (class1.getClassLoader() != class2.getClassLoader()) {
            return false;
        }
        String name1 = class1.getName();
        String name2 = class2.getName();
        int dot = name1.lastIndexOf(46);
        if (dot != name2.lastIndexOf(46)) {
            return false;
        }
        for (int i = 0; i < dot; ++i) {
            if (name1.charAt(i) == name2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String getPackageName(Class<?> cls) {
        assert (!cls.isArray());
        String name = cls.getName();
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return name.substring(0, dot);
    }

    public static boolean isSamePackageMember(Class<?> class1, Class<?> class2) {
        if (class1 == class2) {
            return true;
        }
        if (!VerifyAccess.isSamePackage(class1, class2)) {
            return false;
        }
        return VerifyAccess.getOutermostEnclosingClass(class1) == VerifyAccess.getOutermostEnclosingClass(class2);
    }

    private static Class<?> getOutermostEnclosingClass(Class<?> c) {
        Class<?> pkgmem = c;
        Class<?> enc = c;
        while ((enc = enc.getEnclosingClass()) != null) {
            pkgmem = enc;
        }
        return pkgmem;
    }

    private static boolean loadersAreRelated(ClassLoader loader1, ClassLoader loader2, boolean loader1MustBeParent) {
        if (loader1 == loader2 || loader1 == null || loader2 == null && !loader1MustBeParent) {
            return true;
        }
        for (ClassLoader scan2 = loader2; scan2 != null; scan2 = scan2.getParent()) {
            if (scan2 != loader1) continue;
            return true;
        }
        if (loader1MustBeParent) {
            return false;
        }
        for (ClassLoader scan1 = loader1; scan1 != null; scan1 = scan1.getParent()) {
            if (scan1 != loader2) continue;
            return true;
        }
        return false;
    }

    public static boolean classLoaderIsAncestor(Class<?> parentClass, Class<?> childClass) {
        return VerifyAccess.loadersAreRelated(parentClass.getClassLoader(), childClass.getClassLoader(), true);
    }
}

