/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import dalvik.system.VMRuntime;
import sun.misc.Cleaner;

public class NativeAllocationRegistry {
    private final ClassLoader classLoader;
    private final long freeFunction;
    private final long size;

    public NativeAllocationRegistry(ClassLoader classLoader, long freeFunction, long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid native allocation size: " + size);
        }
        this.classLoader = classLoader;
        this.freeFunction = freeFunction;
        this.size = size;
    }

    public Runnable registerNativeAllocation(Object referent, long nativePtr) {
        if (referent == null) {
            throw new IllegalArgumentException("referent is null");
        }
        if (nativePtr == 0L) {
            throw new IllegalArgumentException("nativePtr is null");
        }
        try {
            NativeAllocationRegistry.registerNativeAllocation(this.size);
        }
        catch (OutOfMemoryError oome) {
            NativeAllocationRegistry.applyFreeFunction(this.freeFunction, nativePtr);
            throw oome;
        }
        Cleaner cleaner = Cleaner.create(referent, new CleanerThunk(nativePtr));
        return new CleanerRunner(cleaner);
    }

    public Runnable registerNativeAllocation(Object referent, Allocator allocator) {
        if (referent == null) {
            throw new IllegalArgumentException("referent is null");
        }
        NativeAllocationRegistry.registerNativeAllocation(this.size);
        CleanerThunk thunk = new CleanerThunk();
        Cleaner cleaner = Cleaner.create(referent, thunk);
        long nativePtr = allocator.allocate();
        if (nativePtr == 0L) {
            cleaner.clean();
            return null;
        }
        thunk.setNativePtr(nativePtr);
        return new CleanerRunner(cleaner);
    }

    private static void registerNativeAllocation(long size) {
        VMRuntime.getRuntime().registerNativeAllocation((int)Math.min(size, Integer.MAX_VALUE));
    }

    private static void registerNativeFree(long size) {
        VMRuntime.getRuntime().registerNativeFree((int)Math.min(size, Integer.MAX_VALUE));
    }

    public static native void applyFreeFunction(long var0, long var2);

    private static class CleanerRunner
    implements Runnable {
        private final Cleaner cleaner;

        public CleanerRunner(Cleaner cleaner) {
            this.cleaner = cleaner;
        }

        @Override
        public void run() {
            this.cleaner.clean();
        }
    }

    private class CleanerThunk
    implements Runnable {
        private long nativePtr;

        public CleanerThunk() {
            this.nativePtr = 0L;
        }

        public CleanerThunk(long nativePtr) {
            this.nativePtr = nativePtr;
        }

        @Override
        public void run() {
            if (this.nativePtr != 0L) {
                NativeAllocationRegistry.applyFreeFunction(NativeAllocationRegistry.this.freeFunction, this.nativePtr);
            }
            NativeAllocationRegistry.registerNativeFree(NativeAllocationRegistry.this.size);
        }

        public void setNativePtr(long nativePtr) {
            this.nativePtr = nativePtr;
        }
    }

    public static interface Allocator {
        public long allocate();
    }
}

