/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResponseUtils {
    public static Charset responseCharset(String contentTypeHeader) throws IllegalCharsetNameException, UnsupportedCharsetException {
        Map<String, String> contentTypeParams;
        String charsetParameter;
        Charset responseCharset = StandardCharsets.UTF_8;
        if (contentTypeHeader != null && (charsetParameter = (contentTypeParams = ResponseUtils.parseContentTypeParameters(contentTypeHeader)).get("charset")) != null) {
            responseCharset = Charset.forName(charsetParameter);
        }
        return responseCharset;
    }

    private static Map<String, String> parseContentTypeParameters(String contentTypeHeader) {
        HashMap<String, String> parameters = Collections.EMPTY_MAP;
        String[] fields = contentTypeHeader.split(";");
        if (fields.length > 1) {
            parameters = new HashMap<String, String>();
            for (int i = 1; i < fields.length; ++i) {
                String[] components;
                String parameter = fields[i];
                if (parameter.isEmpty() || (components = parameter.split("=")).length != 2) continue;
                String key = components[0].trim().toLowerCase();
                String value = components[1].trim();
                if (key.isEmpty() || value.isEmpty()) continue;
                parameters.put(key, value);
            }
        }
        return parameters;
    }
}

