/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.icu.util.Calendar;
import android.icu.util.ULocale;
import java.text.FieldPosition;
import java.util.TimeZone;
import libcore.icu.DateUtilsBridge;
import libcore.util.BasicLruCache;

public final class DateIntervalFormat {
    private static final BasicLruCache<String, android.icu.text.DateIntervalFormat> CACHED_FORMATTERS = new BasicLruCache(8);

    private DateIntervalFormat() {
    }

    public static String formatDateRange(long startMs, long endMs, int flags, String olsonId) {
        if ((flags & 0x2000) != 0) {
            olsonId = "UTC";
        }
        TimeZone tz = olsonId != null ? TimeZone.getTimeZone(olsonId) : TimeZone.getDefault();
        android.icu.util.TimeZone icuTimeZone = DateUtilsBridge.icuTimeZone(tz);
        ULocale icuLocale = ULocale.getDefault();
        return DateIntervalFormat.formatDateRange(icuLocale, icuTimeZone, startMs, endMs, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateRange(ULocale icuLocale, android.icu.util.TimeZone icuTimeZone, long startMs, long endMs, int flags) {
        Calendar startCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, startMs);
        Calendar endCalendar = startMs == endMs ? startCalendar : DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, endMs);
        boolean endsAtMidnight = DateIntervalFormat.isMidnight(endCalendar);
        if (startMs != endMs && endsAtMidnight && ((flags & 1) == 0 || DateUtilsBridge.dayDistance(startCalendar, endCalendar) <= 1)) {
            endCalendar.add(5, -1);
        }
        String skeleton = DateUtilsBridge.toSkeleton(startCalendar, endCalendar, flags);
        BasicLruCache<String, android.icu.text.DateIntervalFormat> basicLruCache = CACHED_FORMATTERS;
        synchronized (basicLruCache) {
            android.icu.text.DateIntervalFormat formatter = DateIntervalFormat.getFormatter(skeleton, icuLocale, icuTimeZone);
            return formatter.format(startCalendar, endCalendar, new StringBuffer(), new FieldPosition(0)).toString();
        }
    }

    private static android.icu.text.DateIntervalFormat getFormatter(String skeleton, ULocale locale, android.icu.util.TimeZone icuTimeZone) {
        String key = skeleton + "\t" + locale + "\t" + icuTimeZone;
        android.icu.text.DateIntervalFormat formatter = CACHED_FORMATTERS.get(key);
        if (formatter != null) {
            return formatter;
        }
        formatter = android.icu.text.DateIntervalFormat.getInstance(skeleton, locale);
        formatter.setTimeZone(icuTimeZone);
        CACHED_FORMATTERS.put(key, formatter);
        return formatter;
    }

    private static boolean isMidnight(Calendar c) {
        return c.get(11) == 0 && c.get(12) == 0 && c.get(13) == 0 && c.get(14) == 0;
    }
}

