/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.net.ServerSocketFactory;
import javax.net.ssl.DefaultSSLServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    private static SSLServerSocketFactory defaultServerSocketFactory;
    private static int lastVersion;

    private static void log(String msg) {
        if (SSLSocketFactory.DEBUG) {
            System.out.println(msg);
        }
    }

    protected SSLServerSocketFactory() {
    }

    public static synchronized ServerSocketFactory getDefault() {
        if (defaultServerSocketFactory != null && lastVersion == Security.getVersion()) {
            return defaultServerSocketFactory;
        }
        lastVersion = Security.getVersion();
        SSLServerSocketFactory previousDefaultServerSocketFactory = defaultServerSocketFactory;
        defaultServerSocketFactory = null;
        String clsName = SSLSocketFactory.getSecurityProperty("ssl.ServerSocketFactory.provider");
        if (clsName != null) {
            if (previousDefaultServerSocketFactory != null && clsName.equals(previousDefaultServerSocketFactory.getClass().getName())) {
                defaultServerSocketFactory = previousDefaultServerSocketFactory;
                return defaultServerSocketFactory;
            }
            SSLServerSocketFactory.log("setting up default SSLServerSocketFactory");
            try {
                Class<?> cls;
                block10: {
                    cls = null;
                    try {
                        cls = Class.forName(clsName);
                    }
                    catch (ClassNotFoundException e) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        if (cl == null) {
                            cl = ClassLoader.getSystemClassLoader();
                        }
                        if (cl == null) break block10;
                        cls = Class.forName(clsName, true, cl);
                    }
                }
                SSLServerSocketFactory.log("class " + clsName + " is loaded");
                SSLServerSocketFactory fac = (SSLServerSocketFactory)cls.newInstance();
                SSLServerSocketFactory.log("instantiated an instance of class " + clsName);
                defaultServerSocketFactory = fac;
                return fac;
            }
            catch (Exception e) {
                SSLServerSocketFactory.log("SSLServerSocketFactory instantiation failed: " + e);
            }
        }
        try {
            SSLContext context = SSLContext.getDefault();
            defaultServerSocketFactory = context != null ? context.getServerSocketFactory() : new DefaultSSLServerSocketFactory(new IllegalStateException("No factory found."));
            return defaultServerSocketFactory;
        }
        catch (NoSuchAlgorithmException e) {
            return new DefaultSSLServerSocketFactory(e);
        }
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    static {
        lastVersion = -1;
    }
}

