/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLParameters;

public abstract class SSLServerSocket
extends ServerSocket {
    protected SSLServerSocket() throws IOException {
    }

    protected SSLServerSocket(int port) throws IOException {
        super(port);
    }

    protected SSLServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    protected SSLServerSocket(int port, int backlog, InetAddress address) throws IOException {
        super(port, backlog, address);
    }

    public abstract String[] getEnabledCipherSuites();

    public abstract void setEnabledCipherSuites(String[] var1);

    public abstract String[] getSupportedCipherSuites();

    public abstract String[] getSupportedProtocols();

    public abstract String[] getEnabledProtocols();

    public abstract void setEnabledProtocols(String[] var1);

    public abstract void setNeedClientAuth(boolean var1);

    public abstract boolean getNeedClientAuth();

    public abstract void setWantClientAuth(boolean var1);

    public abstract boolean getWantClientAuth();

    public abstract void setUseClientMode(boolean var1);

    public abstract boolean getUseClientMode();

    public abstract void setEnableSessionCreation(boolean var1);

    public abstract boolean getEnableSessionCreation();

    public SSLParameters getSSLParameters() {
        SSLParameters parameters = new SSLParameters();
        parameters.setCipherSuites(this.getEnabledCipherSuites());
        parameters.setProtocols(this.getEnabledProtocols());
        if (this.getNeedClientAuth()) {
            parameters.setNeedClientAuth(true);
        } else if (this.getWantClientAuth()) {
            parameters.setWantClientAuth(true);
        }
        return parameters;
    }

    public void setSSLParameters(SSLParameters params) {
        String[] s = params.getCipherSuites();
        if (s != null) {
            this.setEnabledCipherSuites(s);
        }
        if ((s = params.getProtocols()) != null) {
            this.setEnabledProtocols(s);
        }
        if (params.getNeedClientAuth()) {
            this.setNeedClientAuth(true);
        } else if (params.getWantClientAuth()) {
            this.setWantClientAuth(true);
        } else {
            this.setWantClientAuth(false);
        }
    }

    @Override
    public String toString() {
        return "SSL" + super.toString();
    }
}

