/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.JceSecurity;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import sun.security.jca.GetInstance;

public class KeyAgreement {
    private Provider provider;
    private KeyAgreementSpi spi;
    private final String algorithm;
    private final Object lock;
    private static int warnCount = 10;
    private static final int I_NO_PARAMS = 1;
    private static final int I_PARAMS = 2;

    protected KeyAgreement(KeyAgreementSpi keyAgreeSpi, Provider provider, String algorithm) {
        this.spi = keyAgreeSpi;
        this.provider = provider;
        this.algorithm = algorithm;
        this.lock = null;
    }

    private KeyAgreement(String algorithm) {
        this.algorithm = algorithm;
        this.lock = new Object();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyAgreement getInstance(String algorithm) throws NoSuchAlgorithmException {
        List<Provider.Service> services = GetInstance.getServices("KeyAgreement", algorithm);
        for (Provider.Service s : services) {
            if (!JceSecurity.canUseProvider(s.getProvider())) continue;
            return new KeyAgreement(algorithm);
        }
        throw new NoSuchAlgorithmException("Algorithm " + algorithm + " not available");
    }

    public static final KeyAgreement getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = JceSecurity.getInstance("KeyAgreement", KeyAgreementSpi.class, algorithm, provider);
        return new KeyAgreement((KeyAgreementSpi)instance.impl, instance.provider, algorithm);
    }

    public static final KeyAgreement getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = JceSecurity.getInstance("KeyAgreement", KeyAgreementSpi.class, algorithm, provider);
        return new KeyAgreement((KeyAgreementSpi)instance.impl, instance.provider, algorithm);
    }

    void chooseFirstProvider() {
        if (this.spi != null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.spi != null) {
                return;
            }
            Exception lastException = null;
            for (Provider.Service s : GetInstance.getServices("KeyAgreement", this.algorithm)) {
                if (!JceSecurity.canUseProvider(s.getProvider())) continue;
                try {
                    Object obj = s.newInstance(null);
                    if (!(obj instanceof KeyAgreementSpi)) continue;
                    this.spi = (KeyAgreementSpi)obj;
                    this.provider = s.getProvider();
                    return;
                }
                catch (Exception e) {
                    lastException = e;
                }
            }
            ProviderException e = new ProviderException("Could not construct KeyAgreementSpi instance");
            if (lastException != null) {
                e.initCause(lastException);
            }
            throw e;
        }
    }

    private void implInit(KeyAgreementSpi spi, int type, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (type == 1) {
            spi.engineInit(key, random);
        } else {
            spi.engineInit(key, params, random);
        }
    }

    private void chooseProvider(int initType, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object = this.lock;
        synchronized (object) {
            if (this.spi != null && key == null) {
                this.implInit(this.spi, initType, key, params, random);
                return;
            }
            Exception lastException = null;
            for (Provider.Service s : GetInstance.getServices("KeyAgreement", this.algorithm)) {
                if (!s.supportsParameter(key) || !JceSecurity.canUseProvider(s.getProvider())) continue;
                try {
                    KeyAgreementSpi spi = (KeyAgreementSpi)s.newInstance(null);
                    this.implInit(spi, initType, key, params, random);
                    this.provider = s.getProvider();
                    this.spi = spi;
                    return;
                }
                catch (Exception e) {
                    if (lastException != null) continue;
                    lastException = e;
                }
            }
            if (lastException instanceof InvalidKeyException) {
                throw (InvalidKeyException)lastException;
            }
            if (lastException instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)lastException;
            }
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            String kName = key != null ? key.getClass().getName() : "(null)";
            throw new InvalidKeyException("No installed provider supports this key: " + kName, lastException);
        }
    }

    public final Provider getProvider() {
        this.chooseFirstProvider();
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.init(key, JceSecurity.RANDOM);
    }

    public final void init(Key key, SecureRandom random) throws InvalidKeyException {
        if (this.spi != null && (key == null || this.lock == null)) {
            this.spi.engineInit(key, random);
        } else {
            try {
                this.chooseProvider(1, key, null, random);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidKeyException(e);
            }
        }
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(key, params, JceSecurity.RANDOM);
    }

    public final void init(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.spi != null) {
            this.spi.engineInit(key, params, random);
        } else {
            this.chooseProvider(2, key, params, random);
        }
    }

    public final Key doPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        this.chooseFirstProvider();
        return this.spi.engineDoPhase(key, lastPhase);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        this.chooseFirstProvider();
        return this.spi.engineGenerateSecret();
    }

    public final int generateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        this.chooseFirstProvider();
        return this.spi.engineGenerateSecret(sharedSecret, offset);
    }

    public final SecretKey generateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        this.chooseFirstProvider();
        return this.spi.engineGenerateSecret(algorithm);
    }
}

