/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends FilterInputStream {
    private Cipher cipher;
    private InputStream input;
    private byte[] ibuffer = new byte[512];
    private boolean done = false;
    private byte[] obuffer;
    private int ostart = 0;
    private int ofinish = 0;
    private boolean closed = false;

    private int getMoreData() throws IOException {
        int readin;
        if (this.done) {
            return -1;
        }
        this.ofinish = 0;
        this.ostart = 0;
        int expectedOutputSize = this.cipher.getOutputSize(this.ibuffer.length);
        if (this.obuffer == null || expectedOutputSize > this.obuffer.length) {
            this.obuffer = new byte[expectedOutputSize];
        }
        if ((readin = this.input.read(this.ibuffer)) == -1) {
            this.done = true;
            try {
                this.ofinish = this.cipher.doFinal(this.obuffer, 0);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                this.obuffer = null;
                throw new IOException(e);
            }
            catch (ShortBufferException e) {
                this.obuffer = null;
                throw new IllegalStateException("ShortBufferException is not expected", e);
            }
        }
        try {
            this.ofinish = this.cipher.update(this.ibuffer, 0, readin, this.obuffer, 0);
        }
        catch (IllegalStateException e) {
            this.obuffer = null;
            throw e;
        }
        catch (ShortBufferException e) {
            this.obuffer = null;
            throw new IllegalStateException("ShortBufferException is not expected", e);
        }
        return this.ofinish;
    }

    public CipherInputStream(InputStream is, Cipher c) {
        super(is);
        this.input = is;
        this.cipher = c;
    }

    protected CipherInputStream(InputStream is) {
        super(is);
        this.input = is;
        this.cipher = new NullCipher();
    }

    @Override
    public int read() throws IOException {
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.getMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        return this.obuffer[this.ostart++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.getMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        if (len <= 0) {
            return 0;
        }
        int available = this.ofinish - this.ostart;
        if (len < available) {
            available = len;
        }
        if (b != null) {
            System.arraycopy(this.obuffer, this.ostart, b, off, available);
        }
        this.ostart += available;
        return available;
    }

    @Override
    public long skip(long n) throws IOException {
        int available = this.ofinish - this.ostart;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.ostart = (int)((long)this.ostart + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.ofinish - this.ostart;
    }

    @Override
    public void close() throws IOException {
        block4: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.input.close();
            if (!this.done) {
                try {
                    this.cipher.doFinal();
                }
                catch (BadPaddingException | IllegalBlockSizeException ex) {
                    if (!(ex instanceof AEADBadTagException)) break block4;
                    throw new IOException(ex);
                }
            }
        }
        this.ostart = 0;
        this.ofinish = 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

