/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;

class ZipUtils {
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;

    ZipUtils() {
    }

    public static final FileTime winTimeToFileTime(long wtime) {
        return FileTime.from(wtime / 10L + -11644473600000000L, TimeUnit.MICROSECONDS);
    }

    public static final long fileTimeToWinTime(FileTime ftime) {
        return (ftime.to(TimeUnit.MICROSECONDS) - -11644473600000000L) * 10L;
    }

    public static final FileTime unixTimeToFileTime(long utime) {
        return FileTime.from(utime, TimeUnit.SECONDS);
    }

    public static final long fileTimeToUnixTime(FileTime ftime) {
        return ftime.to(TimeUnit.SECONDS);
    }

    private static long dosToJavaTime(long dtime) {
        Date d = new Date((int)((dtime >> 25 & 0x7FL) + 80L), (int)((dtime >> 21 & 0xFL) - 1L), (int)(dtime >> 16 & 0x1FL), (int)(dtime >> 11 & 0x1FL), (int)(dtime >> 5 & 0x3FL), (int)(dtime << 1 & 0x3EL));
        return d.getTime();
    }

    public static long extendedDosToJavaTime(long xdostime) {
        long time = ZipUtils.dosToJavaTime(xdostime);
        return time + (xdostime >> 32);
    }

    private static long javaToDosTime(long time) {
        Date d = new Date(time);
        int year = d.getYear() + 1900;
        if (year < 1980) {
            return 0x210000L;
        }
        return (long)(year - 1980 << 25 | d.getMonth() + 1 << 21 | d.getDate() << 16 | d.getHours() << 11 | d.getMinutes() << 5 | d.getSeconds() >> 1) & 0xFFFFFFFFL;
    }

    public static long javaToExtendedDosTime(long time) {
        if (time < 0L) {
            return 0x210000L;
        }
        long dostime = ZipUtils.javaToDosTime(time);
        return dostime != 0x210000L ? dostime + (time % 2000L << 32) : 0x210000L;
    }

    public static final int get16(byte[] b, int off) {
        return Byte.toUnsignedInt(b[off]) | Byte.toUnsignedInt(b[off + 1]) << 8;
    }

    public static final long get32(byte[] b, int off) {
        return ((long)ZipUtils.get16(b, off) | (long)ZipUtils.get16(b, off + 2) << 16) & 0xFFFFFFFFL;
    }

    public static final long get64(byte[] b, int off) {
        return ZipUtils.get32(b, off) | ZipUtils.get32(b, off + 4) << 32;
    }
}

