/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;

public class DeflaterInputStream
extends FilterInputStream {
    protected final Deflater def;
    protected final byte[] buf;
    private byte[] rbuf = new byte[1];
    private boolean usesDefaultDeflater = false;
    private boolean reachEOF = false;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public DeflaterInputStream(InputStream in) {
        this(in, new Deflater());
        this.usesDefaultDeflater = true;
    }

    public DeflaterInputStream(InputStream in, Deflater defl) {
        this(in, defl, 512);
    }

    public DeflaterInputStream(InputStream in, Deflater defl, int bufLen) {
        super(in);
        if (in == null) {
            throw new NullPointerException("Null input");
        }
        if (defl == null) {
            throw new NullPointerException("Null deflater");
        }
        if (bufLen < 1) {
            throw new IllegalArgumentException("Buffer size < 1");
        }
        this.def = defl;
        this.buf = new byte[bufLen];
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                if (this.usesDefaultDeflater) {
                    this.def.end();
                }
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    @Override
    public int read() throws IOException {
        int len = this.read(this.rbuf, 0, 1);
        if (len <= 0) {
            return -1;
        }
        return this.rbuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException("Null buffer for read");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int cnt = 0;
        while (len > 0 && !this.def.finished()) {
            int n;
            if (this.def.needsInput()) {
                n = this.in.read(this.buf, 0, this.buf.length);
                if (n < 0) {
                    this.def.finish();
                } else if (n > 0) {
                    this.def.setInput(this.buf, 0, n);
                }
            }
            n = this.def.deflate(b, off, len);
            cnt += n;
            off += n;
            len -= n;
        }
        if (this.def.finished()) {
            this.reachEOF = true;
            if (cnt == 0) {
                cnt = -1;
            }
        }
        return cnt;
    }

    @Override
    public long skip(long n) throws IOException {
        int len;
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        if (this.rbuf.length < 512) {
            this.rbuf = new byte[512];
        }
        long cnt = 0L;
        for (int total = (int)Math.min(n, Integer.MAX_VALUE); total > 0 && (len = this.read(this.rbuf, 0, total <= this.rbuf.length ? total : this.rbuf.length)) >= 0; total -= len) {
            cnt += (long)len;
        }
        return cnt;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.reachEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int limit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

