/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntFunction;
import java.util.stream.AbstractPipeline;
import java.util.stream.ForEachOps;
import java.util.stream.Node;
import java.util.stream.Nodes;
import java.util.stream.PipelineHelper;
import java.util.stream.ReduceOps;
import java.util.stream.ReferencePipeline;
import java.util.stream.Sink;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.StreamSpliterators;
import java.util.stream.TerminalOp;

final class DistinctOps {
    private DistinctOps() {
    }

    static <T> ReferencePipeline<T, T> makeRef(AbstractPipeline<?, T, ?> upstream) {
        return new ReferencePipeline.StatefulOp<T, T>(upstream, StreamShape.REFERENCE, StreamOpFlag.IS_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            <P_IN> Node<T> reduce(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                TerminalOp<Object, LinkedHashSet> reduceOp = ReduceOps.makeRef(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
                return Nodes.node(reduceOp.evaluateParallel(helper, spliterator));
            }

            @Override
            public <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> helper, Spliterator<P_IN> spliterator, IntFunction<T[]> generator) {
                if (StreamOpFlag.DISTINCT.isKnown(helper.getStreamAndOpFlags())) {
                    return helper.evaluate(spliterator, false, generator);
                }
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.reduce(helper, spliterator);
                }
                AtomicBoolean seenNull = new AtomicBoolean(false);
                ConcurrentHashMap map = new ConcurrentHashMap();
                TerminalOp<Object, Void> forEachOp = ForEachOps.makeRef(t -> {
                    if (t == null) {
                        seenNull.set(true);
                    } else {
                        map.putIfAbsent(t, Boolean.TRUE);
                    }
                }, false);
                forEachOp.evaluateParallel(helper, spliterator);
                Set keys = map.keySet();
                if (seenNull.get()) {
                    keys = new HashSet(keys);
                    keys.add(null);
                }
                return Nodes.node(keys);
            }

            @Override
            public <P_IN> Spliterator<T> opEvaluateParallelLazy(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.DISTINCT.isKnown(helper.getStreamAndOpFlags())) {
                    return helper.wrapSpliterator(spliterator);
                }
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.reduce(helper, spliterator).spliterator();
                }
                return new StreamSpliterators.DistinctSpliterator(helper.wrapSpliterator(spliterator));
            }

            @Override
            public Sink<T> opWrapSink(int flags, Sink<T> sink) {
                Objects.requireNonNull(sink);
                if (StreamOpFlag.DISTINCT.isKnown(flags)) {
                    return sink;
                }
                if (StreamOpFlag.SORTED.isKnown(flags)) {
                    return new Sink.ChainedReference<T, T>(sink){
                        boolean seenNull;
                        T lastSeen;

                        @Override
                        public void begin(long size) {
                            this.seenNull = false;
                            this.lastSeen = null;
                            this.downstream.begin(-1L);
                        }

                        @Override
                        public void end() {
                            this.seenNull = false;
                            this.lastSeen = null;
                            this.downstream.end();
                        }

                        @Override
                        public void accept(T t) {
                            if (t == null) {
                                if (!this.seenNull) {
                                    this.seenNull = true;
                                    this.lastSeen = null;
                                    this.downstream.accept(null);
                                }
                            } else if (this.lastSeen == null || !t.equals(this.lastSeen)) {
                                this.lastSeen = t;
                                this.downstream.accept(this.lastSeen);
                            }
                        }
                    };
                }
                return new Sink.ChainedReference<T, T>(sink){
                    Set<T> seen;

                    @Override
                    public void begin(long size) {
                        this.seen = new HashSet();
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void end() {
                        this.seen = null;
                        this.downstream.end();
                    }

                    @Override
                    public void accept(T t) {
                        if (!this.seen.contains(t)) {
                            this.seen.add(t);
                            this.downstream.accept(t);
                        }
                    }
                };
            }
        };
    }
}

