/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import libcore.util.EmptyArray;
import libcore.util.NativeAllocationRegistry;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    public static final int UNICODE_CHARACTER_CLASS = 256;
    private static final long serialVersionUID = 5073258162644648461L;
    private final String pattern;
    private final int flags;
    transient long address;
    private static final NativeAllocationRegistry registry = new NativeAllocationRegistry(Pattern.class.getClassLoader(), Pattern.getNativeFinalizer(), Pattern.nativeSize());
    private static final String FASTSPLIT_METACHARACTERS = "\\?*+[](){}^$.|";

    public static Pattern compile(String regex) {
        return new Pattern(regex, 0);
    }

    public static Pattern compile(String regex, int flags) throws PatternSyntaxException {
        return new Pattern(regex, flags);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    public Matcher matcher(CharSequence input) {
        Matcher m = new Matcher(this, input);
        return m;
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String regex, CharSequence input) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public String[] split(CharSequence input, int limit) {
        int resultSize;
        String[] fast = Pattern.fastSplit(this.pattern, input.toString(), limit);
        if (fast != null) {
            return fast;
        }
        int index = 0;
        boolean matchLimited = limit > 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = this.matcher(input);
        while (m.find()) {
            String match;
            if (!matchLimited || matchList.size() < limit - 1) {
                match = input.subSequence(index, m.start()).toString();
                matchList.add(match);
                index = m.end();
                continue;
            }
            if (matchList.size() != limit - 1) continue;
            match = input.subSequence(index, input.length()).toString();
            matchList.add(match);
            index = m.end();
        }
        if (index == 0) {
            return new String[]{input.toString()};
        }
        if (!matchLimited || matchList.size() < limit) {
            matchList.add(input.subSequence(index, input.length()).toString());
        }
        if (limit == 0) {
            for (resultSize = matchList.size(); resultSize > 0 && ((String)matchList.get(resultSize - 1)).equals(""); --resultSize) {
            }
        }
        String[] result = new String[resultSize];
        return matchList.subList(0, resultSize).toArray(result);
    }

    public static String[] fastSplit(String re, String input, int limit) {
        int end;
        int len = re.length();
        if (len == 0) {
            return null;
        }
        char ch = re.charAt(0);
        if (len != 1 || FASTSPLIT_METACHARACTERS.indexOf(ch) != -1) {
            if (len == 2 && ch == '\\') {
                ch = re.charAt(1);
                if (FASTSPLIT_METACHARACTERS.indexOf(ch) == -1) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (input.isEmpty()) {
            return new String[]{""};
        }
        int separatorCount = 0;
        int begin = 0;
        while (separatorCount + 1 != limit && (end = input.indexOf(ch, begin)) != -1) {
            ++separatorCount;
            begin = end + 1;
        }
        int lastPartEnd = input.length();
        if (limit == 0 && begin == lastPartEnd) {
            if (separatorCount == lastPartEnd) {
                return EmptyArray.STRING;
            }
            while (input.charAt(--begin - 1) == ch) {
            }
            separatorCount -= input.length() - begin;
            lastPartEnd = begin;
        }
        String[] result = new String[separatorCount + 1];
        begin = 0;
        for (int i = 0; i != separatorCount; ++i) {
            end = input.indexOf(ch, begin);
            result[i] = input.substring(begin, end);
            begin = end + 1;
        }
        result[separatorCount] = input.substring(begin, lastPartEnd);
        return result;
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public static String quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.compile();
    }

    private Pattern(String p, int f) {
        if ((f & 0x80) != 0) {
            throw new UnsupportedOperationException("CANON_EQ flag not supported");
        }
        int supportedFlags = 127;
        if ((f & ~supportedFlags) != 0) {
            throw new IllegalArgumentException("Unsupported flags: " + (f & ~supportedFlags));
        }
        this.pattern = p;
        this.flags = f;
        this.compile();
    }

    private void compile() throws PatternSyntaxException {
        if (this.pattern == null) {
            throw new NullPointerException("pattern == null");
        }
        String icuPattern = this.pattern;
        if ((this.flags & 0x10) != 0) {
            icuPattern = Pattern.quote(this.pattern);
        }
        int icuFlags = this.flags & 0x2F;
        this.address = Pattern.compileImpl(icuPattern, icuFlags);
        registry.registerNativeAllocation((Object)this, this.address);
    }

    private static native long compileImpl(String var0, int var1);

    private static native long getNativeFinalizer();

    private static native int nativeSize();

    public Predicate<String> asPredicate() {
        return s -> this.matcher((CharSequence)s).find();
    }

    public Stream<String> splitAsStream(final CharSequence input) {
        class MatcherIterator
        implements Iterator<String> {
            private final Matcher matcher;
            private int current;
            private String nextElement;
            private int emptyElementCount;

            MatcherIterator() {
                this.matcher = Pattern.this.matcher(input);
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.emptyElementCount == 0) {
                    String n = this.nextElement;
                    this.nextElement = null;
                    return n;
                }
                --this.emptyElementCount;
                return "";
            }

            @Override
            public boolean hasNext() {
                if (this.nextElement != null || this.emptyElementCount > 0) {
                    return true;
                }
                if (this.current == input.length()) {
                    return false;
                }
                while (this.matcher.find()) {
                    this.nextElement = input.subSequence(this.current, this.matcher.start()).toString();
                    this.current = this.matcher.end();
                    if (!this.nextElement.isEmpty()) {
                        return true;
                    }
                    if (this.current <= 0) continue;
                    ++this.emptyElementCount;
                }
                this.nextElement = input.subSequence(this.current, input.length()).toString();
                this.current = input.length();
                if (!this.nextElement.isEmpty()) {
                    return true;
                }
                this.emptyElementCount = 0;
                this.nextElement = null;
                return false;
            }
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new MatcherIterator(), 272), false);
    }
}

