/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import libcore.util.NativeAllocationRegistry;

public final class Matcher
implements MatchResult {
    private Pattern pattern;
    private long address;
    private Runnable nativeFinalizer;
    private static final NativeAllocationRegistry registry = new NativeAllocationRegistry(Matcher.class.getClassLoader(), Matcher.getNativeFinalizer(), Matcher.nativeSize());
    private CharSequence originalInput;
    private String input;
    private int regionStart;
    private int regionEnd;
    private int appendPos;
    private boolean matchFound;
    private int[] matchOffsets;
    private boolean anchoringBounds = true;
    private boolean transparentBounds;

    Matcher(Pattern parent, CharSequence text) {
        this.usePattern(parent);
        this.reset(text);
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public MatchResult toMatchResult() {
        this.ensureMatch();
        return new OffsetBasedMatchResult(this.input, this.matchOffsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matcher usePattern(Pattern newPattern) {
        if (newPattern == null) {
            throw new IllegalArgumentException("newPattern == null");
        }
        this.pattern = newPattern;
        Matcher matcher = this;
        synchronized (matcher) {
            if (this.nativeFinalizer != null) {
                this.nativeFinalizer.run();
                this.address = 0L;
                this.nativeFinalizer = null;
            }
            this.address = Matcher.openImpl(this.pattern.address);
            this.nativeFinalizer = registry.registerNativeAllocation((Object)this, this.address);
        }
        if (this.input != null) {
            this.resetForInput();
        }
        this.matchOffsets = new int[(this.groupCount() + 1) * 2];
        this.matchFound = false;
        return this;
    }

    @Override
    public int end() {
        return this.end(0);
    }

    @Override
    public int end(int group) {
        this.ensureMatch();
        return this.matchOffsets[group * 2 + 1];
    }

    public int end(String name) {
        this.ensureMatch();
        return this.matchOffsets[Matcher.getMatchedGroupIndex(this.pattern.address, name) * 2 + 1];
    }

    @Override
    public String group() {
        return this.group(0);
    }

    @Override
    public String group(int group) {
        this.ensureMatch();
        int from = this.matchOffsets[group * 2];
        int to = this.matchOffsets[group * 2 + 1];
        if (from == -1 || to == -1) {
            return null;
        }
        return this.input.substring(from, to);
    }

    public String group(String name) {
        this.ensureMatch();
        int group = Matcher.getMatchedGroupIndex(this.pattern.address, name);
        int from = this.matchOffsets[group * 2];
        int to = this.matchOffsets[group * 2 + 1];
        if (from == -1 || to == -1) {
            return null;
        }
        return this.input.substring(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int groupCount() {
        Matcher matcher = this;
        synchronized (matcher) {
            return Matcher.groupCountImpl(this.address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches() {
        Matcher matcher = this;
        synchronized (matcher) {
            this.matchFound = Matcher.matchesImpl(this.address, this.matchOffsets);
        }
        return this.matchFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean find() {
        Matcher matcher = this;
        synchronized (matcher) {
            this.matchFound = Matcher.findNextImpl(this.address, this.matchOffsets);
        }
        return this.matchFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean find(int start) {
        this.reset();
        if (start < 0 || start > this.input.length()) {
            throw new IndexOutOfBoundsException("start=" + start + "; length=" + this.input.length());
        }
        Matcher matcher = this;
        synchronized (matcher) {
            this.matchFound = Matcher.findImpl(this.address, start, this.matchOffsets);
        }
        return this.matchFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lookingAt() {
        Matcher matcher = this;
        synchronized (matcher) {
            this.matchFound = Matcher.lookingAtImpl(this.address, this.matchOffsets);
        }
        return this.matchFound;
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        sb.append(this.input.substring(this.appendPos, this.start()));
        this.appendEvaluated(sb, replacement);
        this.appendPos = this.end();
        return this;
    }

    private void appendEvaluated(StringBuffer buffer, String s) {
        boolean escape = false;
        boolean dollar = false;
        boolean escapeNamedGroup = false;
        int escapeNamedGroupStart = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && !escape) {
                escape = true;
                continue;
            }
            if (c == '$' && !escape) {
                dollar = true;
                continue;
            }
            if (c >= '0' && c <= '9' && dollar) {
                buffer.append(this.group(c - 48));
                dollar = false;
                continue;
            }
            if (c == '{' && dollar) {
                escapeNamedGroup = true;
                escapeNamedGroupStart = i;
                continue;
            }
            if (c == '}' && dollar && escapeNamedGroup) {
                String namedGroupName = s.substring(escapeNamedGroupStart + 1, i);
                buffer.append(this.group(namedGroupName));
                dollar = false;
                escapeNamedGroup = false;
                continue;
            }
            if (c != '}' && dollar && escapeNamedGroup) continue;
            buffer.append(c);
            dollar = false;
            escape = false;
            escapeNamedGroup = false;
        }
        if (escapeNamedGroup) {
            throw new IllegalArgumentException("Missing ending brace '}' from replacement string");
        }
        if (escape) {
            throw new ArrayIndexOutOfBoundsException(s.length());
        }
    }

    public StringBuffer appendTail(StringBuffer sb) {
        if (this.appendPos < this.regionEnd) {
            sb.append(this.input.substring(this.appendPos, this.regionEnd));
        }
        return sb;
    }

    public String replaceAll(String replacement) {
        this.reset();
        StringBuffer buffer = new StringBuffer(this.input.length());
        while (this.find()) {
            this.appendReplacement(buffer, replacement);
        }
        return this.appendTail(buffer).toString();
    }

    public String replaceFirst(String replacement) {
        this.reset();
        StringBuffer buffer = new StringBuffer(this.input.length());
        if (this.find()) {
            this.appendReplacement(buffer, replacement);
        }
        return this.appendTail(buffer).toString();
    }

    public Matcher region(int start, int end) {
        return this.reset(this.originalInput, start, end);
    }

    public int regionStart() {
        return this.regionStart;
    }

    public int regionEnd() {
        return this.regionEnd;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matcher useTransparentBounds(boolean value) {
        Matcher matcher = this;
        synchronized (matcher) {
            this.transparentBounds = value;
            Matcher.useTransparentBoundsImpl(this.address, value);
        }
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matcher useAnchoringBounds(boolean value) {
        Matcher matcher = this;
        synchronized (matcher) {
            this.anchoringBounds = value;
            Matcher.useAnchoringBoundsImpl(this.address, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("java.util.regex.Matcher");
        sb.append("[pattern=" + this.pattern());
        sb.append(" region=");
        sb.append(this.regionStart() + "," + this.regionEnd());
        sb.append(" lastmatch=");
        if (this.matchFound && this.group() != null) {
            sb.append(this.group());
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hitEnd() {
        Matcher matcher = this;
        synchronized (matcher) {
            return Matcher.hitEndImpl(this.address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requireEnd() {
        Matcher matcher = this;
        synchronized (matcher) {
            return Matcher.requireEndImpl(this.address);
        }
    }

    public Matcher reset() {
        return this.reset(this.originalInput, 0, this.originalInput.length());
    }

    public Matcher reset(CharSequence input) {
        return this.reset(input, 0, input.length());
    }

    private Matcher reset(CharSequence input, int start, int end) {
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        if (start < 0 || end < 0 || start > input.length() || end > input.length() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        this.originalInput = input;
        this.input = input.toString();
        this.regionStart = start;
        this.regionEnd = end;
        this.resetForInput();
        this.matchFound = false;
        this.appendPos = 0;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetForInput() {
        Matcher matcher = this;
        synchronized (matcher) {
            Matcher.setInputImpl(this.address, this.input, this.regionStart, this.regionEnd);
            Matcher.useAnchoringBoundsImpl(this.address, this.anchoringBounds);
            Matcher.useTransparentBoundsImpl(this.address, this.transparentBounds);
        }
    }

    private void ensureMatch() {
        if (!this.matchFound) {
            throw new IllegalStateException("No successful match so far");
        }
    }

    @Override
    public int start() {
        return this.start(0);
    }

    @Override
    public int start(int group) throws IllegalStateException {
        this.ensureMatch();
        return this.matchOffsets[group * 2];
    }

    public int start(String name) {
        this.ensureMatch();
        return this.matchOffsets[Matcher.getMatchedGroupIndex(this.pattern.address, name) * 2];
    }

    private static int getMatchedGroupIndex(long patternAddr, String name) {
        int result = Matcher.getMatchedGroupIndex0(patternAddr, name);
        if (result < 0) {
            throw new IllegalArgumentException("No capturing group in the pattern with the name " + name);
        }
        return result;
    }

    private static native int getMatchedGroupIndex0(long var0, String var2);

    private static native boolean findImpl(long var0, int var2, int[] var3);

    private static native boolean findNextImpl(long var0, int[] var2);

    private static native long getNativeFinalizer();

    private static native int groupCountImpl(long var0);

    private static native boolean hitEndImpl(long var0);

    private static native boolean lookingAtImpl(long var0, int[] var2);

    private static native boolean matchesImpl(long var0, int[] var2);

    private static native int nativeSize();

    private static native long openImpl(long var0);

    private static native boolean requireEndImpl(long var0);

    private static native void setInputImpl(long var0, String var2, int var3, int var4);

    private static native void useAnchoringBoundsImpl(long var0, boolean var2);

    private static native void useTransparentBoundsImpl(long var0, boolean var2);

    static final class OffsetBasedMatchResult
    implements MatchResult {
        private final String input;
        private final int[] offsets;

        OffsetBasedMatchResult(String input, int[] offsets) {
            this.input = input;
            this.offsets = (int[])offsets.clone();
        }

        @Override
        public int start() {
            return this.start(0);
        }

        @Override
        public int start(int group) {
            return this.offsets[2 * group];
        }

        @Override
        public int end() {
            return this.end(0);
        }

        @Override
        public int end(int group) {
            return this.offsets[2 * group + 1];
        }

        @Override
        public String group() {
            return this.group(0);
        }

        @Override
        public String group(int group) {
            int start = this.start(group);
            int end = this.end(group);
            if (start == -1 || end == -1) {
                return null;
            }
            return this.input.substring(start, end);
        }

        @Override
        public int groupCount() {
            return this.offsets.length / 2 - 1;
        }
    }
}

