/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Base64;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.prefs.XmlSupport;
import sun.util.logging.PlatformLogger;

public class FileSystemPreferences
extends AbstractPreferences {
    private static File systemRootDir;
    private static boolean isSystemRootWritable;
    private static File userRootDir;
    private static boolean isUserRootWritable;
    static Preferences userRoot;
    static Preferences systemRoot;
    private static final int USER_READ_WRITE = 384;
    private static final int USER_RW_ALL_READ = 420;
    private static final int USER_RWX_ALL_RX = 493;
    private static final int USER_RWX = 448;
    static File userLockFile;
    static File systemLockFile;
    private static int userRootLockHandle;
    private static int systemRootLockHandle;
    private final File dir;
    private final File prefsFile;
    private final File tmpFile;
    private static File userRootModFile;
    private static boolean isUserRootModified;
    private static long userRootModTime;
    private static File systemRootModFile;
    private static boolean isSystemRootModified;
    private static long systemRootModTime;
    private Map<String, String> prefsCache = null;
    private long lastSyncTime = 0L;
    private static final int EAGAIN = 11;
    private static final int EACCES = 13;
    private static final int LOCK_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    final List<Change> changeLog = new ArrayList<Change>();
    NodeCreate nodeCreate = null;
    private final boolean isUserNode;
    private static final String[] EMPTY_STRING_ARRAY;
    private static int INIT_SLEEP_TIME;
    private static int MAX_ATTEMPTS;

    private static PlatformLogger getLogger() {
        return PlatformLogger.getLogger("java.util.prefs");
    }

    static synchronized Preferences getUserRoot() {
        if (userRoot == null) {
            FileSystemPreferences.setupUserRoot();
            userRoot = new FileSystemPreferences(true);
        }
        return userRoot;
    }

    private static void setupUserRoot() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                userRootDir = new File(System.getProperty("java.util.prefs.userRoot", System.getProperty("user.home")), ".java/.userPrefs");
                if (!userRootDir.exists()) {
                    if (userRootDir.mkdirs()) {
                        try {
                            FileSystemPreferences.chmod(userRootDir.getCanonicalPath(), 448);
                        }
                        catch (IOException e) {
                            FileSystemPreferences.getLogger().warning("Could not change permissions on userRoot directory. ");
                        }
                        FileSystemPreferences.getLogger().info("Created user preferences directory.");
                    } else {
                        FileSystemPreferences.getLogger().warning("Couldn't create user preferences directory. User preferences are unusable.");
                    }
                }
                isUserRootWritable = userRootDir.canWrite();
                String USER_NAME = System.getProperty("user.name");
                userLockFile = new File(userRootDir, ".user.lock." + USER_NAME);
                userRootModFile = new File(userRootDir, ".userRootModFile." + USER_NAME);
                if (!userRootModFile.exists()) {
                    try {
                        userRootModFile.createNewFile();
                        int result = FileSystemPreferences.chmod(userRootModFile.getCanonicalPath(), 384);
                        if (result != 0) {
                            FileSystemPreferences.getLogger().warning("Problem creating userRoot mod file. Chmod failed on " + userRootModFile.getCanonicalPath() + " Unix error code " + result);
                        }
                    }
                    catch (IOException e) {
                        FileSystemPreferences.getLogger().warning(e.toString());
                    }
                }
                userRootModTime = userRootModFile.lastModified();
                return null;
            }
        });
    }

    static synchronized Preferences getSystemRoot() {
        if (systemRoot == null) {
            FileSystemPreferences.setupSystemRoot();
            systemRoot = new FileSystemPreferences(false);
        }
        return systemRoot;
    }

    private static void setupSystemRoot() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String systemPrefsDirName = System.getProperty("java.util.prefs.systemRoot", "/etc/.java");
                systemRootDir = new File(systemPrefsDirName, ".systemPrefs");
                if (!systemRootDir.exists()) {
                    systemRootDir = new File(System.getProperty("java.home"), ".systemPrefs");
                    if (!systemRootDir.exists()) {
                        if (systemRootDir.mkdirs()) {
                            FileSystemPreferences.getLogger().info("Created system preferences directory in java.home.");
                            try {
                                FileSystemPreferences.chmod(systemRootDir.getCanonicalPath(), 493);
                            }
                            catch (IOException iOException) {}
                        } else {
                            FileSystemPreferences.getLogger().warning("Could not create system preferences directory. System preferences are unusable.");
                        }
                    }
                }
                isSystemRootWritable = systemRootDir.canWrite();
                systemLockFile = new File(systemRootDir, ".system.lock");
                systemRootModFile = new File(systemRootDir, ".systemRootModFile");
                if (!systemRootModFile.exists() && isSystemRootWritable) {
                    try {
                        systemRootModFile.createNewFile();
                        int result = FileSystemPreferences.chmod(systemRootModFile.getCanonicalPath(), 420);
                        if (result != 0) {
                            FileSystemPreferences.getLogger().warning("Chmod failed on " + systemRootModFile.getCanonicalPath() + " Unix error code " + result);
                        }
                    }
                    catch (IOException e) {
                        FileSystemPreferences.getLogger().warning(e.toString());
                    }
                }
                systemRootModTime = systemRootModFile.lastModified();
                return null;
            }
        });
    }

    private void replayChanges() {
        int n = this.changeLog.size();
        for (int i = 0; i < n; ++i) {
            this.changeLog.get(i).replay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncWorld() {
        Class<FileSystemPreferences> clazz = FileSystemPreferences.class;
        synchronized (FileSystemPreferences.class) {
            Preferences userRt = userRoot;
            Preferences systemRt = systemRoot;
            // ** MonitorExit[var2] (shouldn't be in output)
            try {
                if (userRt != null) {
                    userRt.flush();
                }
            }
            catch (BackingStoreException e) {
                FileSystemPreferences.getLogger().warning("Couldn't flush user prefs: " + e);
            }
            try {
                if (systemRt != null) {
                    systemRt.flush();
                }
            }
            catch (BackingStoreException e) {
                FileSystemPreferences.getLogger().warning("Couldn't flush system prefs: " + e);
            }
            return;
        }
    }

    private FileSystemPreferences(boolean user) {
        super(null, "");
        this.isUserNode = user;
        this.dir = user ? userRootDir : systemRootDir;
        this.prefsFile = new File(this.dir, "prefs.xml");
        this.tmpFile = new File(this.dir, "prefs.tmp");
    }

    public FileSystemPreferences(String path, File lockFile, boolean isUserNode) {
        super(null, "");
        this.isUserNode = isUserNode;
        this.dir = new File(path);
        this.prefsFile = new File(this.dir, "prefs.xml");
        this.tmpFile = new File(this.dir, "prefs.tmp");
        boolean bl = this.newNode = !this.dir.exists();
        if (this.newNode) {
            this.prefsCache = new TreeMap<String, String>();
            this.nodeCreate = new NodeCreate();
            this.changeLog.add(this.nodeCreate);
        }
        if (isUserNode) {
            userLockFile = lockFile;
            userRootModFile = new File(lockFile.getParentFile(), lockFile.getName() + ".rootmod");
        } else {
            systemLockFile = lockFile;
            systemRootModFile = new File(lockFile.getParentFile(), lockFile.getName() + ".rootmod");
        }
    }

    private FileSystemPreferences(FileSystemPreferences parent, String name) {
        super(parent, name);
        this.isUserNode = parent.isUserNode;
        this.dir = new File(parent.dir, FileSystemPreferences.dirName(name));
        this.prefsFile = new File(this.dir, "prefs.xml");
        this.tmpFile = new File(this.dir, "prefs.tmp");
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FileSystemPreferences.this.newNode = !FileSystemPreferences.this.dir.exists();
                return null;
            }
        });
        if (this.newNode) {
            this.prefsCache = new TreeMap<String, String>();
            this.nodeCreate = new NodeCreate();
            this.changeLog.add(this.nodeCreate);
        }
    }

    @Override
    public boolean isUserNode() {
        return this.isUserNode;
    }

    @Override
    protected void putSpi(String key, String value) {
        this.initCacheIfNecessary();
        this.changeLog.add(new Put(key, value));
        this.prefsCache.put(key, value);
    }

    @Override
    protected String getSpi(String key) {
        this.initCacheIfNecessary();
        return this.prefsCache.get(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.initCacheIfNecessary();
        this.changeLog.add(new Remove(key));
        this.prefsCache.remove(key);
    }

    private void initCacheIfNecessary() {
        if (this.prefsCache != null) {
            return;
        }
        try {
            this.loadCache();
        }
        catch (Exception e) {
            this.prefsCache = new TreeMap<String, String>();
        }
    }

    private void loadCache() throws BackingStoreException {
        TreeMap<String, String> m = new TreeMap<String, String>();
        long newLastSyncTime = 0L;
        try {
            newLastSyncTime = this.prefsFile.lastModified();
            try (FileInputStream fis = new FileInputStream(this.prefsFile);){
                XmlSupport.importMap(fis, m);
            }
        }
        catch (Exception e) {
            if (e instanceof InvalidPreferencesFormatException) {
                FileSystemPreferences.getLogger().warning("Invalid preferences format in " + this.prefsFile.getPath());
                this.prefsFile.renameTo(new File(this.prefsFile.getParentFile(), "IncorrectFormatPrefs.xml"));
                m = new TreeMap();
            }
            if (e instanceof FileNotFoundException) {
                FileSystemPreferences.getLogger().warning("Prefs file removed in background " + this.prefsFile.getPath());
            }
            FileSystemPreferences.getLogger().warning("Exception while reading cache: " + e.getMessage());
            throw new BackingStoreException(e);
        }
        this.prefsCache = m;
        this.lastSyncTime = newLastSyncTime;
    }

    private void writeBackCache() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws BackingStoreException {
                    try {
                        if (!FileSystemPreferences.this.dir.exists() && !FileSystemPreferences.this.dir.mkdirs()) {
                            throw new BackingStoreException(FileSystemPreferences.this.dir + " create failed.");
                        }
                        try (FileOutputStream fos = new FileOutputStream(FileSystemPreferences.this.tmpFile);){
                            XmlSupport.exportMap(fos, FileSystemPreferences.this.prefsCache);
                        }
                        if (!FileSystemPreferences.this.tmpFile.renameTo(FileSystemPreferences.this.prefsFile)) {
                            throw new BackingStoreException("Can't rename " + FileSystemPreferences.this.tmpFile + " to " + FileSystemPreferences.this.prefsFile);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof BackingStoreException) {
                            throw (BackingStoreException)e;
                        }
                        throw new BackingStoreException(e);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BackingStoreException)e.getException();
        }
    }

    @Override
    protected String[] keysSpi() {
        this.initCacheIfNecessary();
        return this.prefsCache.keySet().toArray(new String[this.prefsCache.size()]);
    }

    @Override
    protected String[] childrenNamesSpi() {
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                ArrayList<String> result = new ArrayList<String>();
                File[] dirContents = FileSystemPreferences.this.dir.listFiles();
                if (dirContents != null) {
                    for (int i = 0; i < dirContents.length; ++i) {
                        if (!dirContents[i].isDirectory()) continue;
                        result.add(FileSystemPreferences.nodeName(dirContents[i].getName()));
                    }
                }
                return result.toArray(EMPTY_STRING_ARRAY);
            }
        });
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        return new FileSystemPreferences(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode() throws BackingStoreException {
        File file = this.isUserNode() ? userLockFile : systemLockFile;
        synchronized (file) {
            if (!this.lockFile(false)) {
                throw new BackingStoreException("Couldn't get file lock.");
            }
            try {
                super.removeNode();
            }
            finally {
                this.unlockFile();
            }
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws BackingStoreException {
                    if (FileSystemPreferences.this.changeLog.contains(FileSystemPreferences.this.nodeCreate)) {
                        FileSystemPreferences.this.changeLog.remove(FileSystemPreferences.this.nodeCreate);
                        FileSystemPreferences.this.nodeCreate = null;
                        return null;
                    }
                    if (!FileSystemPreferences.this.dir.exists()) {
                        return null;
                    }
                    FileSystemPreferences.this.prefsFile.delete();
                    FileSystemPreferences.this.tmpFile.delete();
                    File[] junk = FileSystemPreferences.this.dir.listFiles();
                    if (junk.length != 0) {
                        FileSystemPreferences.getLogger().warning("Found extraneous files when removing node: " + Arrays.asList(junk));
                        for (int i = 0; i < junk.length; ++i) {
                            junk[i].delete();
                        }
                    }
                    if (!FileSystemPreferences.this.dir.delete()) {
                        throw new BackingStoreException("Couldn't delete dir: " + FileSystemPreferences.this.dir);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BackingStoreException)e.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sync() throws BackingStoreException {
        boolean userNode = this.isUserNode();
        boolean shared = userNode ? false : !isSystemRootWritable;
        File file = this.isUserNode() ? userLockFile : systemLockFile;
        synchronized (file) {
            if (!this.lockFile(shared)) {
                throw new BackingStoreException("Couldn't get file lock.");
            }
            final Long newModTime = AccessController.doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    long nmt;
                    if (FileSystemPreferences.this.isUserNode()) {
                        nmt = userRootModFile.lastModified();
                        isUserRootModified = userRootModTime == nmt;
                    } else {
                        nmt = systemRootModFile.lastModified();
                        isSystemRootModified = systemRootModTime == nmt;
                    }
                    return new Long(nmt);
                }
            });
            try {
                super.sync();
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        if (FileSystemPreferences.this.isUserNode()) {
                            userRootModTime = newModTime + 1000L;
                            userRootModFile.setLastModified(userRootModTime);
                        } else {
                            systemRootModTime = newModTime + 1000L;
                            systemRootModFile.setLastModified(systemRootModTime);
                        }
                        return null;
                    }
                });
            }
            finally {
                this.unlockFile();
            }
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        this.syncSpiPrivileged();
    }

    private void syncSpiPrivileged() throws BackingStoreException {
        long lastModifiedTime;
        if (this.isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        if (this.prefsCache == null) {
            return;
        }
        if (this.isUserNode() ? isUserRootModified : isSystemRootModified) {
            lastModifiedTime = this.prefsFile.lastModified();
            if (lastModifiedTime != this.lastSyncTime) {
                this.loadCache();
                this.replayChanges();
                this.lastSyncTime = lastModifiedTime;
            }
        } else if (this.lastSyncTime != 0L && !this.dir.exists()) {
            this.prefsCache = new TreeMap<String, String>();
            this.replayChanges();
        }
        if (!this.changeLog.isEmpty()) {
            this.writeBackCache();
            lastModifiedTime = this.prefsFile.lastModified();
            if (this.lastSyncTime <= lastModifiedTime) {
                this.lastSyncTime = lastModifiedTime + 1000L;
                this.prefsFile.setLastModified(this.lastSyncTime);
            }
            this.changeLog.clear();
        }
    }

    @Override
    public void flush() throws BackingStoreException {
        if (this.isRemoved()) {
            return;
        }
        this.sync();
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    private static boolean isDirChar(char ch) {
        return ch > '\u001f' && ch < '\u007f' && ch != '/' && ch != '.' && ch != '_';
    }

    private static String dirName(String nodeName) {
        int n = nodeName.length();
        for (int i = 0; i < n; ++i) {
            if (FileSystemPreferences.isDirChar(nodeName.charAt(i))) continue;
            return "_" + Base64.byteArrayToAltBase64(FileSystemPreferences.byteArray(nodeName));
        }
        return nodeName;
    }

    private static byte[] byteArray(String s) {
        int len = s.length();
        byte[] result = new byte[2 * len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            result[j++] = (byte)(c >> 8);
            result[j++] = (byte)c;
        }
        return result;
    }

    private static String nodeName(String dirName) {
        if (dirName.charAt(0) != '_') {
            return dirName;
        }
        byte[] a = Base64.altBase64ToByteArray(dirName.substring(1));
        StringBuffer result = new StringBuffer(a.length / 2);
        int i = 0;
        while (i < a.length) {
            int highByte = a[i++] & 0xFF;
            int lowByte = a[i++] & 0xFF;
            result.append((char)(highByte << 8 | lowByte));
        }
        return result.toString();
    }

    private boolean lockFile(boolean shared) throws SecurityException {
        boolean usernode = this.isUserNode();
        int errorCode = 0;
        File lockFile = usernode ? userLockFile : systemLockFile;
        long sleepTime = INIT_SLEEP_TIME;
        for (int i = 0; i < MAX_ATTEMPTS; ++i) {
            try {
                int perm = usernode ? 384 : 420;
                int[] result = FileSystemPreferences.lockFile0(lockFile.getCanonicalPath(), perm, shared);
                errorCode = result[1];
                if (result[0] != 0) {
                    if (usernode) {
                        userRootLockHandle = result[0];
                    } else {
                        systemRootLockHandle = result[0];
                    }
                    return true;
                }
            }
            catch (IOException perm) {
                // empty catch block
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                this.checkLockFile0ErrorCode(errorCode);
                return false;
            }
            sleepTime *= 2L;
        }
        this.checkLockFile0ErrorCode(errorCode);
        return false;
    }

    private void checkLockFile0ErrorCode(int errorCode) throws SecurityException {
        if (errorCode == 13) {
            throw new SecurityException("Could not lock " + (this.isUserNode() ? "User prefs." : "System prefs.") + " Lock file access denied.");
        }
        if (errorCode != 11) {
            FileSystemPreferences.getLogger().warning("Could not lock " + (this.isUserNode() ? "User prefs. " : "System prefs.") + " Unix error code " + errorCode + ".");
        }
    }

    private static native int[] lockFile0(String var0, int var1, boolean var2);

    private static native int unlockFile0(int var0);

    private static native int chmod(String var0, int var1);

    private void unlockFile() {
        int lockHandle;
        boolean usernode = this.isUserNode();
        File lockFile = usernode ? userLockFile : systemLockFile;
        int n = lockHandle = usernode ? userRootLockHandle : systemRootLockHandle;
        if (lockHandle == 0) {
            FileSystemPreferences.getLogger().warning("Unlock: zero lockHandle for " + (usernode ? "user" : "system") + " preferences.)");
            return;
        }
        int result = FileSystemPreferences.unlockFile0(lockHandle);
        if (result != 0) {
            FileSystemPreferences.getLogger().warning("Could not drop file-lock on " + (this.isUserNode() ? "user" : "system") + " preferences. Unix error code " + result + ".");
            if (result == 13) {
                throw new SecurityException("Could not unlock" + (this.isUserNode() ? "User prefs." : "System prefs.") + " Lock file access denied.");
            }
        }
        if (this.isUserNode()) {
            userRootLockHandle = 0;
        } else {
            systemRootLockHandle = 0;
        }
    }

    static {
        userRoot = null;
        userRootLockHandle = 0;
        systemRootLockHandle = 0;
        isUserRootModified = false;
        isSystemRootModified = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                FileSystemPreferences.syncWorld();
            }
        });
        EMPTY_STRING_ARRAY = new String[0];
        INIT_SLEEP_TIME = 50;
        MAX_ATTEMPTS = 5;
    }

    private class NodeCreate
    extends Change {
        private NodeCreate() {
        }

        @Override
        void replay() {
        }
    }

    private class Remove
    extends Change {
        String key;

        Remove(String key) {
            this.key = key;
        }

        @Override
        void replay() {
            FileSystemPreferences.this.prefsCache.remove(this.key);
        }
    }

    private class Put
    extends Change {
        String key;
        String value;

        Put(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        void replay() {
            FileSystemPreferences.this.prefsCache.put(this.key, this.value);
        }
    }

    private abstract class Change {
        private Change() {
        }

        abstract void replay();
    }
}

