/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class MemoryHandler
extends Handler {
    private static final int DEFAULT_SIZE = 1000;
    private volatile Level pushLevel;
    private int size;
    private Handler target;
    private LogRecord[] buffer;
    int start;
    int count;

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this.pushLevel = manager.getLevelProperty(cname + ".push", Level.SEVERE);
        this.size = manager.getIntProperty(cname + ".size", 1000);
        if (this.size <= 0) {
            this.size = 1000;
        }
        this.setLevel(manager.getLevelProperty(cname + ".level", Level.ALL));
        this.setFilter(manager.getFilterProperty(cname + ".filter", null));
        this.setFormatter(manager.getFormatterProperty(cname + ".formatter", new SimpleFormatter()));
    }

    public MemoryHandler() {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        LogManager manager = LogManager.getLogManager();
        String handlerName = this.getClass().getName();
        String targetName = manager.getProperty(handlerName + ".target");
        if (targetName == null) {
            throw new RuntimeException("The handler " + handlerName + " does not specify a target");
        }
        try {
            Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(targetName);
            this.target = (Handler)clz.newInstance();
        }
        catch (Exception ex) {
            try {
                Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(targetName);
                this.target = (Handler)clz.newInstance();
            }
            catch (Exception innerE) {
                throw new RuntimeException("MemoryHandler can't load handler target \"" + targetName + "\"", innerE);
            }
        }
        this.init();
    }

    private void init() {
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
    }

    public MemoryHandler(Handler target, int size, Level pushLevel) {
        if (target == null || pushLevel == null) {
            throw new NullPointerException();
        }
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.target = target;
        this.pushLevel = pushLevel;
        this.size = size;
        this.init();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = record;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
            this.start %= this.buffer.length;
        }
        if (record.getLevel().intValue() >= this.pushLevel.intValue()) {
            this.push();
        }
    }

    public synchronized void push() {
        for (int i = 0; i < this.count; ++i) {
            int ix = (this.start + i) % this.buffer.length;
            LogRecord record = this.buffer[ix];
            this.target.publish(record);
        }
        this.start = 0;
        this.count = 0;
    }

    @Override
    public void flush() {
        this.target.flush();
    }

    @Override
    public void close() throws SecurityException {
        this.target.close();
        this.setLevel(Level.OFF);
    }

    public synchronized void setPushLevel(Level newLevel) throws SecurityException {
        if (newLevel == null) {
            throw new NullPointerException();
        }
        this.checkPermission();
        this.pushLevel = newLevel;
    }

    public Level getPushLevel() {
        return this.pushLevel;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return super.isLoggable(record);
    }
}

