/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    private static final String defaultBundle = "sun.util.logging.resources.logging";
    private final String name;
    private final int value;
    private final String resourceBundleName;
    private transient String localizedLevelName;
    private transient Locale cachedLocale;
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE, "sun.util.logging.resources.logging");
    public static final Level SEVERE = new Level("SEVERE", 1000, "sun.util.logging.resources.logging");
    public static final Level WARNING = new Level("WARNING", 900, "sun.util.logging.resources.logging");
    public static final Level INFO = new Level("INFO", 800, "sun.util.logging.resources.logging");
    public static final Level CONFIG = new Level("CONFIG", 700, "sun.util.logging.resources.logging");
    public static final Level FINE = new Level("FINE", 500, "sun.util.logging.resources.logging");
    public static final Level FINER = new Level("FINER", 400, "sun.util.logging.resources.logging");
    public static final Level FINEST = new Level("FINEST", 300, "sun.util.logging.resources.logging");
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE, "sun.util.logging.resources.logging");
    private static final long serialVersionUID = -8176160795706313070L;

    protected Level(String name, int value) {
        this(name, value, null);
    }

    protected Level(String name, int value, String resourceBundleName) {
        this(name, value, resourceBundleName, true);
    }

    private Level(String name, int value, String resourceBundleName, boolean visible) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.value = value;
        this.resourceBundleName = resourceBundleName;
        this.localizedLevelName = resourceBundleName == null ? name : null;
        this.cachedLocale = null;
        if (visible) {
            KnownLevel.add(this);
        }
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        return this.getLocalizedLevelName();
    }

    final String getLevelName() {
        return this.name;
    }

    private String computeLocalizedLevelName(Locale newLocale) {
        ResourceBundle rb = ResourceBundle.getBundle(this.resourceBundleName, newLocale, Thread.currentThread().getContextClassLoader());
        String localizedName = rb.getString(this.name);
        boolean isDefaultBundle = defaultBundle.equals(this.resourceBundleName);
        if (!isDefaultBundle) {
            return localizedName;
        }
        Locale rbLocale = rb.getLocale();
        Locale locale = Locale.ROOT.equals(rbLocale) || this.name.equals(localizedName.toUpperCase(Locale.ROOT)) ? Locale.ROOT : rbLocale;
        return Locale.ROOT.equals(locale) ? this.name : localizedName.toUpperCase(locale);
    }

    final String getCachedLocalizedLevelName() {
        if (this.localizedLevelName != null && this.cachedLocale != null && this.cachedLocale.equals(Locale.getDefault())) {
            return this.localizedLevelName;
        }
        if (this.resourceBundleName == null) {
            return this.name;
        }
        return null;
    }

    final synchronized String getLocalizedLevelName() {
        String cachedLocalizedName = this.getCachedLocalizedLevelName();
        if (cachedLocalizedName != null) {
            return cachedLocalizedName;
        }
        Locale newLocale = Locale.getDefault();
        try {
            this.localizedLevelName = this.computeLocalizedLevelName(newLocale);
        }
        catch (Exception ex) {
            this.localizedLevelName = this.name;
        }
        this.cachedLocale = newLocale;
        return this.localizedLevelName;
    }

    static Level findLevel(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        KnownLevel level = KnownLevel.findByName(name);
        if (level != null) {
            return level.mirroredLevel;
        }
        try {
            int x = Integer.parseInt(name);
            level = KnownLevel.findByValue(x);
            if (level == null) {
                Level levelObject = new Level(name, x);
                level = KnownLevel.findByValue(x);
            }
            return level.mirroredLevel;
        }
        catch (NumberFormatException numberFormatException) {
            level = KnownLevel.findByLocalizedLevelName(name);
            if (level != null) {
                return level.mirroredLevel;
            }
            return null;
        }
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    private Object readResolve() {
        KnownLevel o = KnownLevel.matches(this);
        if (o != null) {
            return o.levelObject;
        }
        Level level = new Level(this.name, this.value, this.resourceBundleName);
        return level;
    }

    public static synchronized Level parse(String name) throws IllegalArgumentException {
        name.length();
        KnownLevel level = KnownLevel.findByName(name);
        if (level != null) {
            return level.levelObject;
        }
        try {
            int x = Integer.parseInt(name);
            level = KnownLevel.findByValue(x);
            if (level == null) {
                Level levelObject = new Level(name, x);
                level = KnownLevel.findByValue(x);
            }
            return level.levelObject;
        }
        catch (NumberFormatException numberFormatException) {
            level = KnownLevel.findByLocalizedLevelName(name);
            if (level != null) {
                return level.levelObject;
            }
            throw new IllegalArgumentException("Bad level \"" + name + "\"");
        }
    }

    public boolean equals(Object ox) {
        try {
            Level lx = (Level)ox;
            return lx.value == this.value;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    static final class KnownLevel {
        private static Map<String, List<KnownLevel>> nameToLevels = new HashMap<String, List<KnownLevel>>();
        private static Map<Integer, List<KnownLevel>> intToLevels = new HashMap<Integer, List<KnownLevel>>();
        final Level levelObject;
        final Level mirroredLevel;

        KnownLevel(Level l) {
            this.levelObject = l;
            this.mirroredLevel = l.getClass() == Level.class ? l : new Level(l.name, l.value, l.resourceBundleName, false);
        }

        static synchronized void add(Level l) {
            KnownLevel o = new KnownLevel(l);
            List<KnownLevel> list = nameToLevels.get(l.name);
            if (list == null) {
                list = new ArrayList<KnownLevel>();
                nameToLevels.put(l.name, list);
            }
            list.add(o);
            list = intToLevels.get(l.value);
            if (list == null) {
                list = new ArrayList<KnownLevel>();
                intToLevels.put(l.value, list);
            }
            list.add(o);
        }

        static synchronized KnownLevel findByName(String name) {
            List<KnownLevel> list = nameToLevels.get(name);
            if (list != null) {
                return list.get(0);
            }
            return null;
        }

        static synchronized KnownLevel findByValue(int value) {
            List<KnownLevel> list = intToLevels.get(value);
            if (list != null) {
                return list.get(0);
            }
            return null;
        }

        static synchronized KnownLevel findByLocalizedLevelName(String name) {
            for (List<KnownLevel> levels : nameToLevels.values()) {
                for (KnownLevel l : levels) {
                    String lname = l.levelObject.getLocalizedLevelName();
                    if (!name.equals(lname)) continue;
                    return l;
                }
            }
            return null;
        }

        static synchronized KnownLevel matches(Level l) {
            List<KnownLevel> list = nameToLevels.get(l.name);
            if (list != null) {
                for (KnownLevel level : list) {
                    Level other = level.mirroredLevel;
                    Class<?> type = level.levelObject.getClass();
                    if (l.value != other.value || l.resourceBundleName != other.resourceBundleName && (l.resourceBundleName == null || !l.resourceBundleName.equals(other.resourceBundleName)) || type != l.getClass()) continue;
                    return level;
                }
            }
            return null;
        }
    }
}

