/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Spliterators;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.IOUtils;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

public class JarFile
extends ZipFile {
    static final String META_DIR = "META-INF/";
    private Manifest manifest;
    private JarEntry manEntry;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    private boolean hasClassPathAttribute;
    private volatile boolean hasCheckedSpecialAttributes;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final char[] CLASSPATH_CHARS = new char[]{'c', 'l', 'a', 's', 's', '-', 'p', 'a', 't', 'h'};
    private static final int[] CLASSPATH_LASTOCC = new int[128];
    private static final int[] CLASSPATH_OPTOSFT = new int[10];

    public JarFile(String name) throws IOException {
        this(new File(name), true, 1);
    }

    public JarFile(String name, boolean verify) throws IOException {
        this(new File(name), verify, 1);
    }

    public JarFile(File file) throws IOException {
        this(file, true, 1);
    }

    public JarFile(File file, boolean verify) throws IOException {
        this(file, verify, 1);
    }

    public JarFile(File file, boolean verify, int mode) throws IOException {
        super(file, mode);
        this.verify = verify;
    }

    public Manifest getManifest() throws IOException {
        return this.getManifestFromReference();
    }

    private synchronized Manifest getManifestFromReference() throws IOException {
        JarEntry manEntry;
        if (this.manifest == null && (manEntry = this.getManEntry()) != null) {
            if (this.verify) {
                byte[] b = this.getBytes(manEntry);
                this.manifest = new Manifest(new ByteArrayInputStream(b));
                if (!this.jvInitialized) {
                    this.jv = new JarVerifier(b);
                }
            } else {
                this.manifest = new Manifest(super.getInputStream(manEntry));
            }
        }
        return this.manifest;
    }

    private native String[] getMetaInfEntryNames();

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        ZipEntry ze = super.getEntry(name);
        if (ze != null) {
            return new JarFileEntry(ze);
        }
        return null;
    }

    public Enumeration<JarEntry> entries() {
        return new JarEntryIterator();
    }

    public Stream<JarEntry> stream() {
        return StreamSupport.stream(Spliterators.spliterator(new JarEntryIterator(), (long)this.size(), 1297), false);
    }

    private void maybeInstantiateVerifier() throws IOException {
        if (this.jv != null) {
            return;
        }
        if (this.verify) {
            String[] names = this.getMetaInfEntryNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i].toUpperCase(Locale.ENGLISH);
                    if (!name.endsWith(".DSA") && !name.endsWith(".RSA") && !name.endsWith(".EC") && !name.endsWith(".SF")) continue;
                    this.getManifest();
                    return;
                }
            }
            this.verify = false;
        }
    }

    private void initializeVerifier() {
        block10: {
            ManifestEntryVerifier mev = null;
            try {
                String[] names = this.getMetaInfEntryNames();
                if (names != null) {
                    for (int i = 0; i < names.length; ++i) {
                        byte[] b;
                        String uname = names[i].toUpperCase(Locale.ENGLISH);
                        if (!MANIFEST_NAME.equals(uname) && !SignatureFileVerifier.isBlockOrSF(uname)) continue;
                        JarEntry e = this.getJarEntry(names[i]);
                        if (e == null) {
                            throw new JarException("corrupted jar file");
                        }
                        if (mev == null) {
                            mev = new ManifestEntryVerifier(this.getManifestFromReference());
                        }
                        if ((b = this.getBytes(e)) == null || b.length <= 0) continue;
                        this.jv.beginEntry(e, mev);
                        this.jv.update(b.length, b, 0, b.length, mev);
                        this.jv.update(-1, null, 0, 0, mev);
                    }
                }
            }
            catch (IOException ex) {
                this.jv = null;
                this.verify = false;
                if (JarVerifier.debug == null) break block10;
                JarVerifier.debug.println("jarfile parsing error!");
                ex.printStackTrace();
            }
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
                this.verify = false;
            }
        }
    }

    private byte[] getBytes(ZipEntry ze) throws IOException {
        try (InputStream is = super.getInputStream(ze);){
            byte[] byArray = IOUtils.readFully(is, (int)ze.getSize(), true);
            return byArray;
        }
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry ze) throws IOException {
        this.maybeInstantiateVerifier();
        if (this.jv == null) {
            return super.getInputStream(ze);
        }
        if (!this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
            if (this.jv == null) {
                return super.getInputStream(ze);
            }
        }
        return new JarVerifier.VerifierStream(this.getManifestFromReference(), ze instanceof JarFileEntry ? (JarEntry)ze : this.getJarEntry(ze.getName()), super.getInputStream(ze), this.jv);
    }

    private synchronized JarEntry getManEntry() {
        if (this.manEntry == null) {
            String[] names;
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            if (this.manEntry == null && (names = this.getMetaInfEntryNames()) != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (!MANIFEST_NAME.equals(names[i].toUpperCase(Locale.ENGLISH))) continue;
                    this.manEntry = this.getJarEntry(names[i]);
                    break;
                }
            }
        }
        return this.manEntry;
    }

    public boolean hasClassPathAttribute() throws IOException {
        this.checkForSpecialAttributes();
        return this.hasClassPathAttribute;
    }

    private boolean match(char[] src, byte[] b, int[] lastOcc, int[] optoSft) {
        char c;
        int j;
        int len = src.length;
        int last = b.length - len;
        block0: for (int i = 0; i <= last; i += Math.max(j + 1 - lastOcc[c & 0x7F], optoSft[j])) {
            for (j = len - 1; j >= 0; --j) {
                c = (char)b[i + j];
                char c2 = c = (c - 65 | 90 - c) >= 0 ? (char)(c + 32) : c;
                if (c == src[j]) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private void checkForSpecialAttributes() throws IOException {
        byte[] b;
        if (this.hasCheckedSpecialAttributes) {
            return;
        }
        JarEntry manEntry = this.getManEntry();
        if (manEntry != null && this.match(CLASSPATH_CHARS, b = this.getBytes(manEntry), CLASSPATH_LASTOCC, CLASSPATH_OPTOSFT)) {
            this.hasClassPathAttribute = true;
        }
        this.hasCheckedSpecialAttributes = true;
    }

    JarEntry newEntry(ZipEntry ze) {
        return new JarFileEntry(ze);
    }

    static {
        JarFile.CLASSPATH_LASTOCC[99] = 1;
        JarFile.CLASSPATH_LASTOCC[108] = 2;
        JarFile.CLASSPATH_LASTOCC[115] = 5;
        JarFile.CLASSPATH_LASTOCC[45] = 6;
        JarFile.CLASSPATH_LASTOCC[112] = 7;
        JarFile.CLASSPATH_LASTOCC[97] = 8;
        JarFile.CLASSPATH_LASTOCC[116] = 9;
        JarFile.CLASSPATH_LASTOCC[104] = 10;
        for (int i = 0; i < 9; ++i) {
            JarFile.CLASSPATH_OPTOSFT[i] = 10;
        }
        JarFile.CLASSPATH_OPTOSFT[9] = 1;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry ze) {
            super(ze);
        }

        @Override
        public Attributes getAttributes() throws IOException {
            Manifest man = JarFile.this.getManifest();
            if (man != null) {
                return man.getAttributes(this.getName());
            }
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.certs == null && JarFile.this.jv != null) {
                this.certs = JarFile.this.jv.getCerts(JarFile.this, this);
            }
            return this.certs == null ? null : (Certificate[])this.certs.clone();
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.signers == null && JarFile.this.jv != null) {
                this.signers = JarFile.this.jv.getCodeSigners(JarFile.this, this);
            }
            return this.signers == null ? null : (CodeSigner[])this.signers.clone();
        }
    }

    private class JarEntryIterator
    implements Enumeration<JarEntry>,
    Iterator<JarEntry> {
        final Enumeration<? extends ZipEntry> e;

        private JarEntryIterator() {
            this.e = JarFile.super.entries();
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public JarEntry next() {
            ZipEntry ze = this.e.nextElement();
            return new JarFileEntry(ze);
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public JarEntry nextElement() {
            return this.next();
        }
    }
}

